/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text;

import java.io.OutputStream;
import net.thevpc.nuts.runtime.standalone.io.terminal.NTerminalModeOp;
import net.thevpc.nuts.runtime.standalone.io.terminal.NTerminalModeOpUtils;
import net.thevpc.nuts.runtime.standalone.text.EscapeOutputStream;
import net.thevpc.nuts.runtime.standalone.text.ExtendedFormatAware;
import net.thevpc.nuts.runtime.standalone.text.FilterFormatOutputStream;
import net.thevpc.nuts.runtime.standalone.text.RawOutputStream;
import net.thevpc.nuts.runtime.standalone.text.RenderedOutputStream;
import net.thevpc.nuts.runtime.standalone.text.UnescapeOutputStream;
import net.thevpc.nuts.spi.NSystemTerminalBase;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NUnsupportedEnumException;

public class FormatOutputStream
extends RenderedOutputStream
implements ExtendedFormatAware {
    public FormatOutputStream(OutputStream out, NSystemTerminalBase term) {
        super(out, term, false);
        NTerminalModeOp op = NTerminalModeOpUtils.resolveNutsTerminalModeOp(out);
        if (op != NTerminalModeOp.NOP) {
            throw new NIllegalArgumentException(NMsg.ofPlain("expected Raw"));
        }
    }

    @Override
    public NTerminalModeOp getModeOp() {
        return NTerminalModeOp.FORMAT;
    }

    @Override
    public ExtendedFormatAware convert(NTerminalModeOp other) {
        if (other == null || other == this.getModeOp()) {
            return this;
        }
        switch (other) {
            case NOP: {
                if (this.out instanceof ExtendedFormatAware) {
                    return (ExtendedFormatAware)((Object)this.out);
                }
                return new RawOutputStream(this.out, this.getTerminal());
            }
            case FORMAT: {
                return this;
            }
            case FILTER: {
                return new FilterFormatOutputStream(this.out, this.getTerminal());
            }
            case ESCAPE: {
                return new EscapeOutputStream(this, this.getTerminal());
            }
            case UNESCAPE: {
                return new UnescapeOutputStream(this, this.getTerminal());
            }
        }
        throw new NUnsupportedEnumException(other);
    }
}

