/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text;

import java.io.OutputStream;
import net.thevpc.nuts.runtime.standalone.io.terminal.NTerminalModeOp;
import net.thevpc.nuts.runtime.standalone.text.EscapeOutputStream;
import net.thevpc.nuts.runtime.standalone.text.ExtendedFormatAware;
import net.thevpc.nuts.runtime.standalone.text.FormatOutputStream;
import net.thevpc.nuts.runtime.standalone.text.RawOutputStream;
import net.thevpc.nuts.runtime.standalone.text.RenderedOutputStream;
import net.thevpc.nuts.runtime.standalone.text.UnescapeOutputStream;
import net.thevpc.nuts.spi.NSystemTerminalBase;
import net.thevpc.nuts.util.NUnsupportedEnumException;

public class FilterFormatOutputStream
extends RenderedOutputStream
implements ExtendedFormatAware {
    public FilterFormatOutputStream(OutputStream out, NSystemTerminalBase term) {
        super(out, term, true);
    }

    @Override
    public NTerminalModeOp getModeOp() {
        return NTerminalModeOp.FILTER;
    }

    @Override
    public ExtendedFormatAware convert(NTerminalModeOp other) {
        if (other == null || other == this.getModeOp()) {
            return this;
        }
        switch (other) {
            case NOP: {
                if (this.out instanceof ExtendedFormatAware) {
                    NTerminalModeOp m = ((ExtendedFormatAware)((Object)this.out)).getModeOp();
                    return (ExtendedFormatAware)((Object)this.out);
                }
                return new RawOutputStream(this.out, this.getTerminal());
            }
            case FORMAT: {
                return new FormatOutputStream(this.out, this.getTerminal());
            }
            case FILTER: {
                return this;
            }
            case ESCAPE: {
                return new EscapeOutputStream(this, this.getTerminal());
            }
            case UNESCAPE: {
                return new UnescapeOutputStream(this, this.getTerminal());
            }
        }
        throw new NUnsupportedEnumException(other);
    }
}

