/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.net.URL;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.time.Duration;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.elem.NElementDescribables;
import net.thevpc.nuts.io.NContentMetadata;
import net.thevpc.nuts.io.NInputSource;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.reflect.NReflectUtils;
import net.thevpc.nuts.runtime.standalone.format.DefaultFormatBase;
import net.thevpc.nuts.runtime.standalone.io.path.NFormatFromSPI;
import net.thevpc.nuts.runtime.standalone.text.AbstractNTextNodeParser;
import net.thevpc.nuts.runtime.standalone.text.DefaultNTextBuilder;
import net.thevpc.nuts.runtime.standalone.text.DefaultNTextManagerModel;
import net.thevpc.nuts.runtime.standalone.text.DefaultNTextTransformerContext;
import net.thevpc.nuts.runtime.standalone.text.DefaultNTitleSequence;
import net.thevpc.nuts.runtime.standalone.text.NMsgCFormatHelper;
import net.thevpc.nuts.runtime.standalone.text.NMsgJFormatHelper;
import net.thevpc.nuts.runtime.standalone.text.NMsgVFormatHelper;
import net.thevpc.nuts.runtime.standalone.text.highlighter.CustomStyleCodeHighlighter;
import net.thevpc.nuts.runtime.standalone.text.parser.AbstractNTextNodeParserDefaults;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNTextAnchor;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNTextCode;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNTextCommand;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNTextInclude;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNTextLink;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNTextList;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNTextPlain;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNTextStyled;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNTextTitle;
import net.thevpc.nuts.runtime.standalone.text.util.DefaultNDurationFormat2;
import net.thevpc.nuts.runtime.standalone.text.util.DefaultUnitFormat;
import net.thevpc.nuts.runtime.standalone.text.util.NTextUtils;
import net.thevpc.nuts.runtime.standalone.util.BytesSizeFormat;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.spi.NCodeHighlighter;
import net.thevpc.nuts.spi.NComponentScope;
import net.thevpc.nuts.spi.NFormatSPI;
import net.thevpc.nuts.spi.NScopeType;
import net.thevpc.nuts.text.NFormat;
import net.thevpc.nuts.text.NFormats;
import net.thevpc.nuts.text.NFormattable;
import net.thevpc.nuts.text.NFormatted;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NMsgFormattable;
import net.thevpc.nuts.text.NNormalizedText;
import net.thevpc.nuts.text.NStringFormat;
import net.thevpc.nuts.text.NTableModel;
import net.thevpc.nuts.text.NTerminalCmd;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextAnchor;
import net.thevpc.nuts.text.NTextArt;
import net.thevpc.nuts.text.NTextBuilder;
import net.thevpc.nuts.text.NTextCmd;
import net.thevpc.nuts.text.NTextCode;
import net.thevpc.nuts.text.NTextFormat;
import net.thevpc.nuts.text.NTextFormatTheme;
import net.thevpc.nuts.text.NTextFormatType;
import net.thevpc.nuts.text.NTextFormattable;
import net.thevpc.nuts.text.NTextInclude;
import net.thevpc.nuts.text.NTextLink;
import net.thevpc.nuts.text.NTextList;
import net.thevpc.nuts.text.NTextParser;
import net.thevpc.nuts.text.NTextPlain;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTextStyleType;
import net.thevpc.nuts.text.NTextStyled;
import net.thevpc.nuts.text.NTextStyles;
import net.thevpc.nuts.text.NTextTitle;
import net.thevpc.nuts.text.NTextTransformConfig;
import net.thevpc.nuts.text.NTextTransformer;
import net.thevpc.nuts.text.NTextTransformerContext;
import net.thevpc.nuts.text.NTextType;
import net.thevpc.nuts.text.NTextVisitor;
import net.thevpc.nuts.text.NTexts;
import net.thevpc.nuts.text.NTitleSequence;
import net.thevpc.nuts.text.NTreeNode;
import net.thevpc.nuts.time.NDuration;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NClassMap;
import net.thevpc.nuts.util.NEnum;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NRef;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NStream;
import net.thevpc.nuts.util.NStringUtils;
import net.thevpc.nuts.util.NUnsupportedEnumException;

@NComponentScope(value=NScopeType.SESSION)
public class DefaultNTexts
implements NTexts {
    private final DefaultNTextManagerModel shared;
    private NClassMap<NTextMapper> mapper = new NClassMap<NTextMapper>(NTextMapper.class);

    public DefaultNTexts() {
        this.shared = NWorkspaceExt.of().getModel().textModel;
        this.registerDefaults();
    }

    private void registerDefaults() {
        this.register(NFormattable.class, (o, t) -> ((NFormattable)o).formatter().setNtf(true).format());
        this.register(NFormatted.class, (o, t) -> ((NFormatted)o).format());
        this.register(NTextFormattable.class, (o, t) -> (NText)o);
        this.register(NMsgFormattable.class, (o, t) -> this._NMsg_toString(((NMsgFormattable)o).toMsg()));
        this.register(NMsg.class, (o, t) -> this._NMsg_toString((NMsg)o));
        this.register(NText.class, (o, t) -> (NText)o);
        this.register(InputStream.class, (o, t) -> {
            NContentMetadata metaData = NInputSource.of((InputStream)o).getMetaData();
            return t.ofStyled(metaData.getName().orElse(o.toString()), NTextStyle.path());
        });
        this.register(OutputStream.class, (o, t) -> t.ofStyled(o.toString(), NTextStyle.path()));
        this.register(NPrintStream.class, (o, t) -> t.ofStyled(o.toString(), NTextStyle.path()));
        this.register(Writer.class, (o, t) -> t.ofStyled(o.toString(), NTextStyle.path()));
        this.register(NEnum.class, (o, t) -> t.ofStyled(((NEnum)o).id(), NTextStyle.option()));
        this.register(Enum.class, (o, t) -> o instanceof NEnum ? t.ofStyled(((NEnum)o).id(), NTextStyle.option()) : this.ofStyled(((Enum)o).name(), NTextStyle.option()));
        this.register(Number.class, (o, t) -> t.ofStyled(o.toString(), NTextStyle.number()));
        this.register(Date.class, (o, t) -> t.ofStyled(o.toString(), NTextStyle.date()));
        this.register(Temporal.class, (o, t) -> t.ofStyled(o.toString(), NTextStyle.date()));
        this.register(TemporalAmount.class, (o, t) -> t.ofStyled(o.toString(), NTextStyle.date()));
        this.register(Boolean.class, (o, t) -> t.ofStyled(o.toString(), NTextStyle.bool()));
        this.register(Path.class, (o, t) -> t.ofStyled(o.toString(), NTextStyle.path()));
        this.register(File.class, (o, t) -> t.ofStyled(o.toString(), NTextStyle.path()));
        this.register(URL.class, (o, t) -> t.ofStyled(o.toString(), NTextStyle.path()));
        this.register(NTreeNode.class, (o, t) -> NTextArt.of().getTreeRenderer().get().render((NTreeNode)o));
        this.register(NTableModel.class, (o, t) -> NTextArt.of().getTableRenderer().get().render((NTableModel)o));
        this.register(Class.class, (o, t) -> {
            Class cc = (Class)o;
            Class<?> dc = cc.getDeclaringClass();
            if (dc != null) {
                NText p = t.of(dc);
                DefaultNTextBuilder tb = new DefaultNTextBuilder();
                tb.append(p);
                tb.append(t.ofStyled(".", NTextStyle.comments()));
                tb.append(t.ofStyled(cc.getSimpleName(), NTextStyle.option()));
                return tb.build();
            }
            DefaultNTextBuilder tb = new DefaultNTextBuilder();
            Package p = cc.getPackage();
            if (p != null) {
                tb.append(t.ofStyled(p.getName(), NTextStyle.comments()));
                tb.append(t.ofStyled(".", NTextStyle.comments()));
            }
            tb.append(t.ofStyled(cc.getSimpleName(), NTextStyle.info()));
            return tb.build();
        });
        this.register(Level.class, (o, t) -> {
            switch (((Level)o).getName()) {
                case "OFF": {
                    return t.ofStyled(o.toString(), NTextStyle.pale());
                }
                case "SEVERE": {
                    return t.ofStyled(o.toString(), NTextStyle.error());
                }
                case "WARNING": {
                    return t.ofStyled(o.toString(), NTextStyle.warn());
                }
                case "INFO": {
                    return t.ofStyled(o.toString(), NTextStyle.info());
                }
                case "CONFIG": {
                    return t.ofStyled(o.toString(), NTextStyle.config());
                }
                case "FINE": 
                case "FINER": 
                case "FINEST": {
                    return t.ofStyled(o.toString(), NTextStyle.pale());
                }
                case "ALL": {
                    return t.ofStyled(o.toString(), NTextStyle.success());
                }
            }
            return t.ofStyled(o.toString(), NTextStyle.bold());
        });
        this.register(Throwable.class, (o, t) -> t.ofStyled(this.of(CoreStringUtils.exceptionToMessage((Throwable)o)), NTextStyle.error()));
        this.register(Collection.class, (o, t) -> {
            NTextBuilder b = this.ofBuilder();
            b.append((Object)"[", NTextStyle.separator());
            boolean first = true;
            for (Object v : (Collection)o) {
                if (!first) {
                    b.append((Object)",", NTextStyle.separator());
                    b.append(" ");
                } else {
                    first = false;
                }
                b.append(t.of(v));
            }
            b.append((Object)"]", NTextStyle.separator());
            return b.build();
        });
        this.register(Map.Entry.class, (o, t) -> {
            NTextBuilder b = this.ofBuilder();
            Map.Entry e = (Map.Entry)o;
            b.append(t.of(e.getKey()));
            b.append((Object)":", NTextStyle.separator());
            b.append(" ");
            b.append(t.of(e.getValue()));
            return b.build();
        });
        this.register(Map.class, (o, t) -> {
            NTextBuilder b = this.ofBuilder();
            b.append((Object)"{", NTextStyle.separator());
            boolean first = true;
            for (Map.Entry v : ((Map)o).entrySet()) {
                if (!first) {
                    b.append((Object)",", NTextStyle.separator());
                    b.append(" ");
                } else {
                    first = false;
                }
                b.append(t.of(v));
            }
            b.append((Object)"}", NTextStyle.separator());
            return b.build();
        });
    }

    private void register(Class clz, NTextMapper mapper) {
        if (mapper == null) {
            this.mapper.remove(clz);
        } else {
            this.mapper.put(clz, mapper);
        }
    }

    private NText _NMsg_toString(NMsg m) {
        NTextFormatType format = m.getFormat();
        if (format == null) {
            format = NTextFormatType.JFORMAT;
        }
        Object msg = m.getMessage();
        switch (format) {
            case CFORMAT: {
                return new NMsgCFormatHelper(m, this).format();
            }
            case JFORMAT: {
                return new NMsgJFormatHelper(m, this).format();
            }
            case VFORMAT: {
                return new NMsgVFormatHelper(m, this).format();
            }
            case PLAIN: {
                return this.ofPlain((String)msg);
            }
            case NTF: {
                if (msg instanceof String) {
                    return this.of((String)msg);
                }
                return this.of(msg);
            }
            case STYLED: {
                return this.ofStyled(this.of(msg), m.getStyles());
            }
            case CODE: {
                return this.ofCodeOrCommand(m.getCodeLang(), (String)msg);
            }
        }
        throw new NUnsupportedEnumException(format);
    }

    public NText fg(String t, int level) {
        return this.fg(this.ofPlain(t), level);
    }

    public NText fg(NText t, int level) {
        NTextStyle textStyle = NTextStyle.primary(level);
        return this.ofStyled(t, NTextStyles.of(textStyle));
    }

    @Override
    public NTextBuilder ofBuilder() {
        return new DefaultNTextBuilder();
    }

    @Override
    public NText ofBlank() {
        return this.ofPlain("");
    }

    @Override
    public NText of(NMsg t) {
        return this._NMsg_toString(t);
    }

    @Override
    public NText of(Object t) {
        if (t == null) {
            return this.ofBlank();
        }
        if (t instanceof NText) {
            return (NText)t;
        }
        Class<?> c = t.getClass();
        if (c.isArray()) {
            NTextBuilder b = this.ofBuilder();
            b.append((Object)"[", NTextStyle.separator());
            int max = Array.getLength(t);
            if (max > 0) {
                b.append(this.of(Array.get(t, 0)));
                for (int i = 1; i < max; ++i) {
                    b.append((Object)",", NTextStyle.separator());
                    b.append(" ");
                    b.append(this.of(Array.get(t, i)));
                }
            }
            b.append((Object)"]", NTextStyle.separator());
            return b.build();
        }
        NTextMapper e = this.mapper.get(c);
        if (e != null) {
            return e.ofText(t, this);
        }
        NFormat nFormat = NFormats.of().ofFormat(t).orNull();
        if (nFormat != null) {
            return nFormat.setNtf(true).format();
        }
        return this.ofPlain(t.toString());
    }

    @Override
    public NTextPlain ofPlain(String t) {
        return new DefaultNTextPlain(t);
    }

    @Override
    public NTextList ofList(NText ... nodes) {
        return this.ofList(Arrays.asList(nodes));
    }

    @Override
    public NTextList ofList(Collection<NText> nodes) {
        if (nodes == null) {
            return new DefaultNTextList(new NText[0]);
        }
        return new DefaultNTextList(nodes.toArray(new NText[0]));
    }

    @Override
    public NText ofStyled(String other, NTextStyles styles) {
        return this.ofStyled((NText)(other == null ? null : this.ofPlain(other)), styles);
    }

    @Override
    public NText ofStyled(NText other, NTextStyles styles) {
        if (other == null) {
            return this.ofBlank();
        }
        if (styles == null || styles.isPlain()) {
            return other;
        }
        return new DefaultNTextStyled("##:" + styles.id() + ":", "##", other, true, styles);
    }

    @Override
    public NText ofStyled(String plainText, NTextStyle style) {
        return this.ofStyled((NText)this.ofPlain(plainText), style);
    }

    @Override
    public NText ofStyled(NMsg other, NTextStyles styles) {
        return this.ofStyled(this.of(other), styles);
    }

    @Override
    public NText ofStyled(NMsg other, NTextStyle style) {
        return this.ofStyled(this.of(other), style);
    }

    @Override
    public NText ofStyled(NText other, NTextStyle style) {
        return this.ofStyled(other, NTextStyles.of(style));
    }

    @Override
    public NTextCmd ofCommand(NTerminalCmd command) {
        return new DefaultNTextCommand("```!", command, "", "```");
    }

    @Override
    public NText ofCodeOrCommand(String lang, String text) {
        return this.ofCodeOrCommand(lang, text, " ");
    }

    @Override
    public NText ofCodeOrCommand(String text) {
        char c;
        int i;
        if (text == null) {
            text = "";
        }
        for (i = 0; i < text.length() && (c = text.charAt(i)) != ':' && !Character.isWhitespace(c) && (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || i > 0 && (c >= '0' && c <= '9' || c == '_' || c == '-') || i == 0 && c == '!'); ++i) {
        }
        String cmd = null;
        String value = null;
        if (i == text.length()) {
            if (text.startsWith("!")) {
                cmd = text.trim();
                value = "";
            } else {
                cmd = "";
                value = text;
            }
            return this.ofCodeOrCommand(cmd, value);
        }
        int sep = 32;
        if (i < text.length()) {
            cmd = text.substring(0, i);
            sep = text.charAt(i);
            if (sep == 32 || sep == 9 || sep == 58) {
                value = text.substring(i + 1);
            } else if (sep == 10) {
                value = text.substring(i + 1);
                if (value.length() > 0 && value.charAt(0) == '\r') {
                    value = value.substring(1);
                }
            } else if (sep == 13) {
                sep = 10;
                value = text.substring(i + 1);
            } else {
                value = text.substring(i);
                sep = 32;
            }
        } else {
            cmd = null;
            value = text;
        }
        return this.ofCodeOrCommand(cmd, value, String.valueOf((char)sep));
    }

    @Override
    public NText ofCodeOrCommand(String name, String text, String sep) {
        this.checkValidSeparator(sep);
        if (name != null && name.startsWith("!")) {
            switch (name) {
                case "!anchor": {
                    return this.ofAnchor(text.trim(), sep);
                }
                case "!link": {
                    return this.ofLink(text.trim(), sep);
                }
                case "!include": {
                    return this.ofInclude(text, sep);
                }
            }
            return this.ofCommand(NTerminalCmd.of(name.substring(1), text));
        }
        return this.ofCode(text, name, sep);
    }

    private void checkValidSeparator(String sep) {
        for (char c : sep.toCharArray()) {
            if (c == ':' || Character.isWhitespace(c)) continue;
            throw new NIllegalArgumentException(NMsg.ofC("invalid separator '%s'", Character.valueOf(c)));
        }
    }

    @Override
    public NTextCode ofCode(String lang, String text) {
        return this.ofCode(text, lang, " ");
    }

    @Override
    public NTextCode ofCode(String text, String lang, String sep) {
        this.checkValidSeparator(sep);
        if (text == null) {
            text = "";
        }
        DefaultNTexts factory0 = (DefaultNTexts)NTexts.of();
        return factory0.createCode("```", lang, "" + sep, "```", text);
    }

    @Override
    public NTitleSequence ofNumbering() {
        return new DefaultNTitleSequence("");
    }

    @Override
    public NTitleSequence ofNumbering(String pattern) {
        return new DefaultNTitleSequence(pattern == null || pattern.isEmpty() ? "1.1.1.a.1" : pattern);
    }

    @Override
    public NTextAnchor ofAnchor(String anchorName) {
        return this.ofAnchor(anchorName, " ");
    }

    @Override
    public NTextAnchor ofAnchor(String anchorName, String sep) {
        this.checkValidSeparator(sep);
        return this.createAnchor("```!", "" + sep, "```", anchorName);
    }

    @Override
    public NTextLink ofLink(String value) {
        return this.ofLink(value, " ");
    }

    @Override
    public NTextLink ofLink(String value, String sep) {
        this.checkValidSeparator(sep);
        return new DefaultNTextLink("" + sep, value);
    }

    @Override
    public NTextInclude ofInclude(String value) {
        return this.ofInclude(value, " ");
    }

    @Override
    public NTextInclude ofInclude(String value, String sep) {
        this.checkValidSeparator(sep);
        return new DefaultNTextInclude("" + sep, value);
    }

    @Override
    public NOptional<NTextFormatTheme> getTheme(String name) {
        return this.shared.getTheme(name);
    }

    @Override
    public NTextFormatTheme getTheme() {
        return this.shared.getTheme();
    }

    @Override
    public NTexts setTheme(NTextFormatTheme theme) {
        this.shared.setTheme(theme);
        return this;
    }

    @Override
    public NTexts setTheme(String theme) {
        this.shared.setTheme(theme);
        return this;
    }

    @Override
    public NCodeHighlighter getCodeHighlighter(String kind) {
        return this.shared.getCodeHighlighter(kind);
    }

    @Override
    public NTexts addCodeHighlighter(NCodeHighlighter format) {
        this.shared.addCodeHighlighter(format);
        return this;
    }

    @Override
    public NTexts removeCodeHighlighter(String id) {
        this.shared.removeCodeHighlighter(id);
        return this;
    }

    @Override
    public List<NCodeHighlighter> getCodeHighlighters() {
        return Arrays.asList(this.shared.getCodeHighlighters());
    }

    @Override
    public NText of(String t) {
        return t == null ? this.ofBlank() : this.parser().parse(new StringReader(t));
    }

    @Override
    public NTextParser parser() {
        return AbstractNTextNodeParserDefaults.createDefault();
    }

    public NText bg(String t, int level) {
        return this.bg(this.ofPlain(t), level);
    }

    public NText bg(NText t, int variant) {
        NTextStyle textStyle = NTextStyle.secondary(variant);
        return this.ofStyled(t, NTextStyles.of(textStyle));
    }

    public NText comments(String image) {
        return this.fg(image, 4);
    }

    public NText literal(String image) {
        return this.fg(image, 1);
    }

    public NText stringLiteral(String image) {
        return this.fg(image, 3);
    }

    public NText numberLiteral(String image) {
        return this.fg(image, 1);
    }

    public NText reservedWord(String image) {
        return this.fg(image, 1);
    }

    public NText annotation(String image) {
        return this.fg(image, 3);
    }

    public NText separator(String image) {
        return this.fg(image, 6);
    }

    public NText commandName(String image) {
        return this.fg(image, 1);
    }

    public NText subCommand1Name(String image) {
        return this.fg(image, 2);
    }

    public NText subCommand2Name(String image) {
        return this.fg(image, 3);
    }

    public NText optionName(String image) {
        return this.fg(image, 4);
    }

    public NText userInput(String image) {
        return this.fg(image, 8);
    }

    public NCodeHighlighter resolveCodeHighlighter(String kind) {
        NCodeHighlighter format;
        if (kind == null) {
            kind = "";
        }
        if ((format = this.getCodeHighlighter(kind)) != null) {
            return format;
        }
        if (kind.length() > 0) {
            try {
                String cc = kind.toUpperCase();
                int x = cc.length();
                while (Character.isDigit(cc.charAt(x - 1))) {
                    --x;
                }
                if (x < cc.length()) {
                    NTextStyle found = NTextStyle.of(NTextStyleType.valueOf(this.expandAlias(kind.toUpperCase().substring(0, x))), NLiteral.of(kind.substring(x)).asInt().orElse(0));
                    return new CustomStyleCodeHighlighter(found);
                }
                NTextStyle found = NTextStyle.of(NTextStyleType.valueOf(this.expandAlias(kind.toUpperCase())));
                return new CustomStyleCodeHighlighter(found);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.getCodeHighlighter("plain");
    }

    private String expandAlias(String ss) {
        switch (ss.toUpperCase()) {
            case "BOOL": {
                ss = "BOOLEAN";
                break;
            }
            case "KW": {
                ss = "KEYWORD";
            }
        }
        return ss;
    }

    @Override
    public NTextTitle ofTitle(NText other, int level) {
        String prefix = CoreStringUtils.fillString('#', level) + ")";
        return new DefaultNTextTitle(prefix, level, other);
    }

    @Override
    public NTextTitle ofTitle(String other, int level) {
        return this.ofTitle(this.ofPlain(other), level);
    }

    public NTextCode createCode(String start, String kind, String separator, String end, String text) {
        return new DefaultNTextCode(start, kind, separator, end, text);
    }

    public NTextCmd createCommand(String start, NTerminalCmd command, String separator, String end) {
        return new DefaultNTextCommand(start, command, separator, end);
    }

    public NTextAnchor createAnchor(String start, String separator, String end, String value) {
        return new DefaultNTextAnchor(start, separator, end, value);
    }

    public NText createTitle(String start, int level, NText child, boolean complete) {
        return new DefaultNTextTitle(start, level, child);
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }

    @Override
    public NNormalizedText normalize(NText text) {
        return this.normalize(text, null, null);
    }

    @Override
    public NNormalizedText normalize(NText text, NTextTransformConfig config) {
        return this.normalize(text, null, config);
    }

    @Override
    public NNormalizedText normalize(NText text, NTextTransformer transformer, NTextTransformConfig config) {
        List<NNormalizedText> li = this.normalizeStream(text, transformer, config).toList();
        if (li.isEmpty()) {
            return (NNormalizedText)NText.ofBlank();
        }
        if (li.size() == 1) {
            return li.get(0);
        }
        return NText.ofList(li.toArray(new NNormalizedText[0]));
    }

    public NStream<NNormalizedText> normalizeStream(NText text, NTextTransformer transformer, NTextTransformConfig config) {
        if (config == null) {
            config = new NTextTransformConfig();
        }
        config.setFlatten(true);
        config.setNormalize(true);
        final NText z = this.transform(text, transformer, config);
        return (NStream)NStream.ofIterator(new Iterator<NText>(){
            Deque<NText> queue = new ArrayDeque<NText>();
            {
                if (z != null) {
                    this.queue.addFirst(z);
                }
                this.refactorNext();
            }

            private void refactorNext() {
                block5: while (!this.queue.isEmpty()) {
                    NText z2 = this.queue.peek();
                    switch (z2.type()) {
                        case PLAIN: 
                        case CODE: 
                        case ANCHOR: 
                        case LINK: 
                        case COMMAND: 
                        case TITLE: 
                        case STYLED: {
                            return;
                        }
                        case LIST: {
                            int i;
                            NText t = (NTextList)z2;
                            this.queue.removeFirst();
                            List<NText> children = t.getChildren();
                            if (children.size() <= 0) continue block5;
                            for (i = children.size() - 1; i >= 0; --i) {
                                this.queue.addFirst(children.get(i));
                            }
                            continue block5;
                        }
                        case BUILDER: {
                            int i;
                            NText t = (NTextBuilder)z2;
                            this.queue.removeFirst();
                            List<NText> children = t.getChildren();
                            if (children.size() <= 0) continue block5;
                            for (i = children.size() - 1; i >= 0; --i) {
                                this.queue.addFirst(children.get(i));
                            }
                            continue block5;
                        }
                        default: {
                            this.queue.removeFirst();
                        }
                    }
                }
            }

            @Override
            public boolean hasNext() {
                this.refactorNext();
                return !this.queue.isEmpty();
            }

            @Override
            public NText next() {
                this.refactorNext();
                return this.queue.remove();
            }
        }).instanceOf(NNormalizedText.class).redescribe(NElementDescribables.ofDesc("flattened text"));
    }

    @Override
    public NText transform(NText text, NTextTransformConfig config) {
        if (NBlankable.isBlank(config)) {
            return text;
        }
        return this.transform(text, null, config);
    }

    int resolveRootLevel(NText text) {
        NRef level = NRef.ofNull();
        this.traverseDFS(text, n -> {
            if (n.type() == NTextType.TITLE) {
                int lvl = ((NTextTitle)n).getLevel();
                if (level.isNull() || (Integer)level.get() > lvl) {
                    level.set(lvl);
                }
            }
        });
        return level.isNull() ? 0 : (Integer)level.get();
    }

    @Override
    public NText transform(NText text, NTextTransformer transformer, NTextTransformConfig config) {
        if (text == null) {
            return null;
        }
        if (NBlankable.isBlank(config) && transformer == null) {
            return text;
        }
        if (config == null) {
            config = new NTextTransformConfig();
        }
        if (config.isProcessIncludes()) {
            NTextTransformConfig iconfig = config.copy();
            iconfig.setProcessIncludes(true);
            iconfig.setImportClassLoader(config.getImportClassLoader());
            DefaultNTextTransformerContext c = new DefaultNTextTransformerContext(iconfig);
            text = this.transform(text, c.getDefaultTransformer(), c);
            config = config.copy().setProcessIncludes(false).setImportClassLoader(null);
        }
        if (NBlankable.isBlank(config) && transformer == null) {
            return text;
        }
        Integer rootLevel = config.getRootLevel();
        if (rootLevel != null) {
            config = config.copy().setRootLevel(null);
            int level = this.resolveRootLevel(text);
            if (level != rootLevel) {
                int offset = rootLevel - level;
                DefaultNTextTransformerContext c = new DefaultNTextTransformerContext(config);
                text = this.transform(text, (NText text1, NTextTransformerContext context) -> {
                    if (text1.type() == NTextType.TITLE) {
                        NTextTitle t = (NTextTitle)text1;
                        return this.ofTitle(t.getChild(), t.getLevel() + offset);
                    }
                    return text1;
                }, c);
            }
        }
        if (NBlankable.isBlank(config) && transformer == null) {
            return text;
        }
        String anchor = config.getAnchor();
        if (anchor != null) {
            config = config.copy().setAnchor(null);
        }
        if (transformer != null || !config.isBlank()) {
            DefaultNTextTransformerContext c = new DefaultNTextTransformerContext(config);
            if (transformer == null) {
                transformer = c.getDefaultTransformer();
            }
            text = this.transform(text, transformer == null ? c.getDefaultTransformer() : transformer, c);
        }
        if (anchor != null) {
            ArrayList<NText> ok = new ArrayList<NText>();
            boolean foundAnchor = false;
            if (text.type() == NTextType.LIST) {
                for (NText o : (NTextList)text) {
                    if (foundAnchor) {
                        ok.add(o);
                        continue;
                    }
                    if (o.type() != NTextType.ANCHOR || !anchor.equals(((DefaultNTextAnchor)o).getValue())) continue;
                    foundAnchor = true;
                }
            }
            if (foundAnchor) {
                text = this.ofList(ok).simplify();
            }
        }
        return text;
    }

    @Override
    public void traverseDFS(NText text, NTextVisitor visitor) {
        if (text == null) {
            return;
        }
        switch (text.type()) {
            case PLAIN: 
            case CODE: 
            case ANCHOR: 
            case LINK: 
            case COMMAND: {
                visitor.visit(text);
                break;
            }
            case TITLE: {
                NTextTitle t = (NTextTitle)text;
                NText child = t.getChild();
                if (child != null) {
                    visitor.visit(child);
                }
                visitor.visit(t);
                break;
            }
            case STYLED: {
                NTextStyled t = (NTextStyled)text;
                NText child = t.getChild();
                if (child != null) {
                    visitor.visit(child);
                }
                visitor.visit(t);
                break;
            }
            case LIST: {
                NTextList t = (NTextList)text;
                for (NText child : t.getChildren()) {
                    if (child == null) continue;
                    visitor.visit(child);
                }
                visitor.visit(t);
                break;
            }
            case BUILDER: {
                NTextBuilder t = (NTextBuilder)text;
                for (NText child : t.getChildren()) {
                    if (child == null) continue;
                    visitor.visit(child);
                }
                visitor.visit(t);
                break;
            }
            case INCLUDE: {
                NTextInclude t = (NTextInclude)text;
                visitor.visit(t);
                break;
            }
        }
    }

    @Override
    public void traverseBFS(NText text, NTextVisitor visitor) {
        ArrayDeque<NText> q = new ArrayDeque<NText>();
        q.add(text);
        while (!q.isEmpty()) {
            NText u = (NText)q.remove();
            switch (text.type()) {
                case PLAIN: 
                case CODE: 
                case ANCHOR: 
                case LINK: 
                case COMMAND: {
                    visitor.visit(text);
                    break;
                }
                case TITLE: {
                    NText t = (NTextTitle)text;
                    NText child = t.getChild();
                    if (child != null) {
                        q.add(child);
                    }
                    visitor.visit(t);
                    break;
                }
                case STYLED: {
                    NText t = (NTextStyled)text;
                    NText child = t.getChild();
                    if (child != null) {
                        q.add(child);
                    }
                    visitor.visit(t);
                    break;
                }
                case LIST: {
                    NText t = (NTextList)text;
                    for (NText child : t.getChildren()) {
                        if (child == null) continue;
                        q.add(child);
                    }
                    visitor.visit(t);
                    break;
                }
                case BUILDER: {
                    NText t = (NTextBuilder)text;
                    for (NText child : t.getChildren()) {
                        if (child == null) continue;
                        q.add(child);
                    }
                    visitor.visit(t);
                    break;
                }
                case INCLUDE: {
                    NText t = (NTextInclude)text;
                    visitor.visit(t);
                    break;
                }
            }
        }
    }

    private NText transform(NText text, NTextTransformer transformer, NTextTransformerContext c) {
        if (text == null) {
            return null;
        }
        NText pt = transformer.preTransform(text, c);
        if (pt != text) {
            return pt;
        }
        switch (text.type()) {
            case PLAIN: 
            case CODE: 
            case ANCHOR: 
            case LINK: 
            case COMMAND: {
                return transformer.postTransform(text, c);
            }
            case TITLE: {
                NTextTitle t = (NTextTitle)text;
                NText child = t.getChild();
                if (child == null) {
                    return null;
                }
                child = this.transform(child, transformer, c);
                return transformer.postTransform(this.ofTitle(child, t.getLevel()), c);
            }
            case STYLED: {
                NTextStyled t = (NTextStyled)text;
                NText child = t.getChild();
                if (child == null) {
                    return null;
                }
                child = this.transform(child, transformer, c);
                return transformer.postTransform(this.ofStyled(child, t.getStyles()), c);
            }
            case LIST: {
                NTextList t = (NTextList)text;
                ArrayList<NText> li = new ArrayList<NText>();
                for (NText child : t.getChildren()) {
                    if (child == null || (child = this.transform(child, transformer, c)) == null) continue;
                    li.add(child);
                }
                if (li.size() > 0) {
                    if (li.size() == 1) {
                        return transformer.postTransform((NText)li.get(0), c);
                    }
                    return transformer.postTransform(this.ofList(li), c);
                }
                return null;
            }
            case BUILDER: {
                NTextBuilder t = (NTextBuilder)text;
                ArrayList<NText> li = new ArrayList<NText>();
                for (NText child : t.getChildren()) {
                    if (child == null || (child = this.transform(child, transformer, c)) == null) continue;
                    li.add(child);
                }
                if (li.size() > 0) {
                    if (li.size() == 1) {
                        return transformer.postTransform((NText)li.get(0), c);
                    }
                    return transformer.postTransform(this.ofList(li), c);
                }
                return null;
            }
            case INCLUDE: {
                return null;
            }
        }
        return null;
    }

    @Override
    public String escapeText(String str) {
        return NTextUtils.escapeText0(str);
    }

    private void writeFilteredText(NText t, ByteArrayOutputStream out) {
        if (t != null) {
            if (t instanceof NTextPlain) {
                try {
                    out.write(((NTextPlain)t).getValue().getBytes());
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            } else if (t instanceof NTextList) {
                for (NText child : ((NTextList)t).getChildren()) {
                    this.writeFilteredText(child, out);
                }
            } else {
                throw new IllegalArgumentException("unexpected");
            }
        }
    }

    @Override
    public String filterText(String text) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            NText parsed = this.parser().parse(new StringReader(text));
            parsed = NTexts.of().transform(parsed, new NTextTransformConfig().setFiltered(true));
            this.writeFilteredText(parsed, out);
            return out.toString();
        }
        catch (Exception ex) {
            NLog.of(AbstractNTextNodeParser.class).log(NMsg.ofC("error parsing : %s", text).withIntent(NMsgIntent.ALERT).withLevel(Level.FINEST));
            return text;
        }
    }

    @Override
    public NFormat createFormat(NFormatSPI format) {
        return new NFormatFromSPI(format);
    }

    @Override
    public <T> NFormat createFormat(final T object, final NTextFormat<T> format) {
        return new DefaultFormatBase<NFormat>("NTextFormat"){

            @Override
            public void print(NPrintStream out) {
                NText u = format.toText(object);
                out.print(u);
            }

            @Override
            public boolean configureFirst(NCmdLine cmdLine) {
                return false;
            }

            @Override
            public int getScore(NScorableContext context) {
                return 10;
            }
        };
    }

    @Override
    public NOptional<NTextFormat<Number>> createNumberTextFormat(String type, String pattern) {
        return this.createTextFormat(type, pattern, Number.class);
    }

    @Override
    public NOptional<NStringFormat<Number>> createNumberStringFormat(String type, String pattern) {
        return this.createStringFormat(type, pattern, Number.class);
    }

    @Override
    public <T> NOptional<NStringFormat<T>> createStringFormat(String type, String pattern, Class<T> expectedType) {
        NOptional<NTextFormat<NTextFormat>> e = this.createTextFormat(type, pattern, expectedType);
        if (e.isEmpty()) {
            return NOptional.ofEmpty(() -> NMsg.ofC("unknown %s format with type %s. Expected %s.", type, expectedType, "Double"));
        }
        return e.map(x -> x);
    }

    @Override
    public <T> NOptional<NTextFormat<T>> createTextFormat(String type, String pattern, Class<T> expectedType) {
        Class finalExpectedType = expectedType;
        NAssert.requireNonNull(type, "type");
        NAssert.requireNonNull(expectedType, "expectedType");
        NAssert.requireNonNull(pattern, "pattern");
        if (expectedType.isPrimitive()) {
            expectedType = NReflectUtils.toBoxedType(expectedType).get();
        }
        switch (type.toLowerCase().trim()) {
            case "duration": {
                final DefaultNDurationFormat2 d = new DefaultNDurationFormat2(pattern);
                if (NDuration.class.equals(expectedType)) {
                    return NOptional.of(new NTextFormat<NDuration>(){

                        @Override
                        public NText toText(NDuration object) {
                            return d.format(object);
                        }
                    });
                }
                if (Duration.class.equals(expectedType)) {
                    return NOptional.of(new NTextFormat<Duration>(){

                        @Override
                        public NText toText(Duration object) {
                            return d.format(object);
                        }
                    });
                }
                return NOptional.ofEmpty(() -> NMsg.ofC("unknown duration format with type %s. Expected Duration or NDuration.", finalExpectedType));
            }
            case "double": 
            case "decimal": 
            case "number": {
                if (pattern.endsWith("%")) {
                    final DecimalFormat d = new DecimalFormat(pattern.substring(0, pattern.length() - 1));
                    if (Number.class.isAssignableFrom(expectedType)) {
                        return NOptional.of(new NTextFormat<Number>(){

                            @Override
                            public NText toText(Number object) {
                                if (object == null) {
                                    return NTextBuilder.of().build();
                                }
                                return NTextBuilder.of().append((Object)d.format(object.doubleValue() * 100.0), NTextStyle.number()).append((Object)"%", NTextStyle.separator()).build();
                            }
                        });
                    }
                    return NOptional.ofEmpty(() -> NMsg.ofC("unknown %s format with type %s. Expected .", type, finalExpectedType, "Number"));
                }
                if (pattern.endsWith("'\u00b0'")) {
                    final DecimalFormat d = new DecimalFormat(pattern.substring(0, pattern.length() - 3));
                    if (Number.class.isAssignableFrom(expectedType)) {
                        return NOptional.of(new NTextFormat<Number>(){

                            @Override
                            public NText toText(Number object) {
                                if (object == null) {
                                    return NTextBuilder.of().build();
                                }
                                return NTextBuilder.of().append((Object)d.format(object), NTextStyle.number()).append((Object)"\u00b0", NTextStyle.separator()).build();
                            }
                        });
                    }
                    return NOptional.ofEmpty(() -> NMsg.ofC("unknown %s format with type %s. Expected .", type, finalExpectedType, "Number"));
                }
                final DecimalFormat d = new DecimalFormat(pattern);
                if (Number.class.isAssignableFrom(expectedType)) {
                    return NOptional.of(new NTextFormat<Number>(){

                        @Override
                        public NText toText(Number object) {
                            if (object == null) {
                                return NTextBuilder.of().build();
                            }
                            return NTextBuilder.of().append((Object)d.format(object), NTextStyle.number()).build();
                        }
                    });
                }
                return NOptional.ofEmpty(() -> NMsg.ofC("unknown %s format with type %s. Expected .", type, finalExpectedType, "Number"));
            }
            case "m": 
            case "meter": 
            case "metric": {
                String p = NStringUtils.trim(pattern);
                final DefaultUnitFormat d = new DefaultUnitFormat("m " + (p.isEmpty() ? "M-3 M3 I2 D2" : p));
                if (Number.class.isAssignableFrom(expectedType)) {
                    return NOptional.of(new NTextFormat<Number>(){

                        @Override
                        public NText toText(Number object) {
                            return d.format(object.doubleValue());
                        }
                    });
                }
                return NOptional.ofEmpty(() -> NMsg.ofC("unknown %s format with type %s. Expected .", type, finalExpectedType, "Number"));
            }
            case "memory": 
            case "bytes": 
            case "size": {
                String p = NStringUtils.trim(pattern);
                final BytesSizeFormat d = new BytesSizeFormat(null);
                if (Number.class.isAssignableFrom(expectedType)) {
                    return NOptional.of(new NTextFormat<Number>(){

                        @Override
                        public NText toText(Number object) {
                            return d.formatText(object.longValue());
                        }
                    });
                }
                return NOptional.ofEmpty(() -> NMsg.ofC("unknown %s format with type %s. Expected .", type, finalExpectedType, "Number"));
            }
            case "freq": 
            case "frequency": 
            case "hz": {
                String p = NStringUtils.trim(pattern);
                final DefaultUnitFormat d = new DefaultUnitFormat("Hz " + (p.isEmpty() ? "M1 M12 I2 D3" : p));
                if (Number.class.isAssignableFrom(expectedType)) {
                    return NOptional.of(new NTextFormat<Number>(){

                        @Override
                        public NText toText(Number object) {
                            return d.format(object.longValue());
                        }
                    });
                }
                return NOptional.ofEmpty(() -> NMsg.ofC("unknown %s format with type %s. Expected .", type, finalExpectedType, "Number"));
            }
        }
        String p = NStringUtils.trim(pattern);
        final DefaultUnitFormat d = new DefaultUnitFormat(type + " " + (p.isEmpty() ? "M-6 M12 I2 D3" : p));
        if (Number.class.isAssignableFrom(expectedType)) {
            return NOptional.of(new NTextFormat<Number>(){

                @Override
                public NText toText(Number object) {
                    return d.format(object.doubleValue());
                }
            });
        }
        return NOptional.ofEmpty(() -> NMsg.ofC("unknown %s format with type %s. Expected %s.", type, finalExpectedType, "Number"));
    }

    private static interface NTextMapper {
        public NText ofText(Object var1, NTexts var2);
    }
}

