/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text;

import net.thevpc.nuts.runtime.standalone.text.DefaultNTextTransformer;
import net.thevpc.nuts.runtime.standalone.text.DefaultNTitleSequence;
import net.thevpc.nuts.text.NTextTransformConfig;
import net.thevpc.nuts.text.NTextTransformer;
import net.thevpc.nuts.text.NTextTransformerContext;
import net.thevpc.nuts.text.NTitleSequence;

public class DefaultNTextTransformerContext
implements NTextTransformerContext {
    private NTitleSequence sequence;
    private NTextTransformer defaultTransformer;
    private NTextTransformConfig config;

    public DefaultNTextTransformerContext(NTextTransformerContext o) {
        this.sequence = o.getTitleSequence();
        this.defaultTransformer = o.getDefaultTransformer();
    }

    public DefaultNTextTransformerContext(NTextTransformConfig config) {
        if (config == null) {
            config = new NTextTransformConfig();
        }
        this.config = config;
        this.defaultTransformer = new DefaultNTextTransformer(config);
        this.sequence = config.getTitleNumberSequence();
        if (this.sequence == null) {
            this.sequence = new DefaultNTitleSequence();
        }
    }

    public DefaultNTextTransformerContext() {
    }

    @Override
    public NTextTransformConfig getConfig() {
        return this.config;
    }

    @Override
    public NTitleSequence getTitleSequence() {
        return this.sequence;
    }

    @Override
    public DefaultNTextTransformerContext setTitleSequence(NTitleSequence sequence) {
        this.sequence = sequence;
        return this;
    }

    @Override
    public NTextTransformer getDefaultTransformer() {
        return this.defaultTransformer;
    }

    @Override
    public DefaultNTextTransformerContext setDefaultTransformer(NTextTransformer defaultTransformer) {
        this.defaultTransformer = defaultTransformer;
        return this;
    }

    @Override
    public NTextTransformerContext copy() {
        return new DefaultNTextTransformerContext(this);
    }
}

