/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceVarExpansionFunction;
import net.thevpc.nuts.runtime.standalone.xtra.expr.StringPlaceHolderParser;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextBuilder;
import net.thevpc.nuts.text.NTextCode;
import net.thevpc.nuts.text.NTextFormatTheme;
import net.thevpc.nuts.text.NTextInclude;
import net.thevpc.nuts.text.NTextLink;
import net.thevpc.nuts.text.NTextList;
import net.thevpc.nuts.text.NTextPlain;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTextStyled;
import net.thevpc.nuts.text.NTextStyles;
import net.thevpc.nuts.text.NTextTitle;
import net.thevpc.nuts.text.NTextTransformConfig;
import net.thevpc.nuts.text.NTextTransformer;
import net.thevpc.nuts.text.NTextTransformerContext;
import net.thevpc.nuts.text.NTextType;
import net.thevpc.nuts.text.NTexts;
import net.thevpc.nuts.text.NTitleSequence;
import net.thevpc.nuts.util.NIllegalArgumentException;

public class DefaultNTextTransformer
implements NTextTransformer {
    private final NTexts txts;
    private final NTextTransformConfig config;
    private final NWorkspaceVarExpansionFunction d;

    public DefaultNTextTransformer(NTextTransformConfig config) {
        this.config = config;
        this.txts = NTexts.of();
        this.d = NWorkspaceVarExpansionFunction.of();
    }

    @Override
    public NText preTransform(NText text, NTextTransformerContext context) {
        return text;
    }

    private String transformText(String t) {
        if (this.config.isProcessVars()) {
            Function<String, String> r = this.config.getVarProvider();
            return StringPlaceHolderParser.replaceDollarPlaceHolders(t, s -> {
                String u = null;
                if (r != null && (u = (String)r.apply((String)s)) != null) {
                    return u;
                }
                return this.d.apply((String)s);
            });
        }
        return t;
    }

    @Override
    public NText postTransform(NText text, NTextTransformerContext context) {
        switch (text.type()) {
            case LIST: {
                if (this.config.isFlatten()) {
                    NTextList t = (NTextList)text;
                    List<NText> all = t.getChildren();
                    ArrayList<NText> all2 = new ArrayList<NText>();
                    for (NText a : all) {
                        if (a instanceof NTextList) {
                            all2.addAll(((NTextList)a).getChildren());
                            continue;
                        }
                        if (a instanceof NTextBuilder) {
                            all2.addAll(((NTextBuilder)a).getChildren());
                            continue;
                        }
                        all2.add(a);
                    }
                    text = this.txts.ofList(all2);
                }
                return this.mapApplyThemeAndFilter(text);
            }
            case BUILDER: {
                if (this.config.isFlatten()) {
                    NTextBuilder t = (NTextBuilder)text;
                    List<NText> all = t.getChildren();
                    ArrayList<NText> all2 = new ArrayList<NText>();
                    for (NText a : all) {
                        if (a instanceof NTextList) {
                            all2.addAll(((NTextList)a).getChildren());
                            continue;
                        }
                        if (a instanceof NTextBuilder) {
                            all2.addAll(((NTextBuilder)a).getChildren());
                            continue;
                        }
                        all2.add(a);
                    }
                    if (all.size() == all2.size()) {
                        return text;
                    }
                    return this.txts.ofList(all2);
                }
                return text;
            }
            case PLAIN: {
                NTextPlain t = (NTextPlain)text;
                String str = this.transformText(t.getValue());
                text = this.config.isFlatten() ? this.flatten(str) : this.txts.ofPlain(str);
                return text;
            }
            case STYLED: {
                NTextStyled t = (NTextStyled)text;
                NText child = t.getChild();
                ArrayList<NText> cc = new ArrayList<NText>();
                boolean filtered = this.config.isFiltered();
                if (this.config.isFlatten()) {
                    if (child instanceof NTextList) {
                        for (NText x2 : ((NTextList)child).getChildren()) {
                            if (this.isNewline(x2)) {
                                cc.add(x2);
                                continue;
                            }
                            if (filtered) {
                                cc.add(x2);
                                continue;
                            }
                            cc.add(this.txts.ofStyled(x2, t.getStyles()));
                        }
                    } else {
                        cc.add(this.mapTxt(child, x -> {
                            if (this.isNewline((NText)x)) {
                                return x;
                            }
                            if (filtered) {
                                return x;
                            }
                            return this.txts.ofStyled((NText)x, t.getStyles());
                        }));
                    }
                } else if (filtered) {
                    cc.add(child);
                } else {
                    cc.add(text);
                }
                if (filtered) {
                    return this.compressTxt(cc.stream().map(x -> this.mapTxt((NText)x, y -> {
                        if (y.type() == NTextType.STYLED) {
                            return ((NTextStyled)y).getChild();
                        }
                        return y;
                    })).collect(Collectors.toList()));
                }
                if (this.config.isApplyTheme()) {
                    NTextFormatTheme theme = this.txts.getTheme(this.config.getThemeName()).orElse(this.txts.getTheme());
                    NTextStyles basicStyles = theme.toBasicStyles(t.getStyles(), this.config.isBasicTrueStyles());
                    return this.compressTxt(cc.stream().map(x -> this.mapTxt((NText)x, y -> {
                        if (y.type() == NTextType.STYLED) {
                            return this.txts.ofStyled(((NTextStyled)y).getChild(), basicStyles);
                        }
                        if (y.type() == NTextType.PLAIN) {
                            return y;
                        }
                        throw new IllegalArgumentException("unexpected...");
                    })).collect(Collectors.toList()));
                }
                return this.compressTxt(cc);
            }
            case LINK: {
                NTextLink t = (NTextLink)text;
                String str = this.transformText(t.getValue());
                if (this.config.isFlatten()) {
                    text = this.mapTxt(this.flatten(str), x -> {
                        NTextPlain p = (NTextPlain)x;
                        if (this.isNewline(p)) {
                            return p;
                        }
                        return this.txts.ofLink(p.getValue());
                    });
                }
                if (this.config.isNormalize()) {
                    text = this.mapTxt(text, x -> {
                        if (x.type() == NTextType.PLAIN) {
                            return x;
                        }
                        String lnk = ((NTextLink)x).getValue();
                        return this.txts.ofStyled(lnk, NTextStyle.underlined());
                    });
                }
                return this.mapApplyThemeAndFilter(text);
            }
            case TITLE: {
                NTextTitle t = (NTextTitle)text;
                String prefix = null;
                int level = t.getLevel();
                if (this.config.isFlatten() || this.config.isNormalize() || this.config.isProcessTitleNumbers()) {
                    if (this.config.isProcessTitleNumbers()) {
                        NTitleSequence n = context.getTitleSequence();
                        if (n == null) {
                            n = this.config.getTitleNumberSequence();
                            if (n == null) {
                                n = NText.ofNumbering();
                            }
                            context.setTitleSequence(n);
                        }
                        n = n.next(level);
                        context.setTitleSequence(n);
                        prefix = n.toString() + " ";
                    } else {
                        prefix = CoreStringUtils.fillString('#', level) + ") ";
                    }
                    ArrayList<NText> li = new ArrayList<NText>();
                    li.add(this.txts.ofPlain(prefix + " "));
                    if (this.config.isFlatten()) {
                        li.addAll(this.asList(t.getChild()));
                    } else {
                        li.add(t.getChild());
                    }
                    li.add(NText.ofNewLine());
                    text = this.txts.ofStyled((NText)this.txts.ofList(li), NTextStyle.primary(level));
                }
                return this.mapApplyThemeAndFilter(text);
            }
            case INCLUDE: {
                NCmdLine cmd;
                NTextInclude t = (NTextInclude)text;
                if (this.config.isProcessIncludes() && (cmd = NCmdLine.parseDefault(t.getText()).orNull()) != null && cmd.length() > 0) {
                    String p = (String)cmd.next().flatMap(NArg::asString).orNull();
                    NPath newP = this.resolveRelativePath(p, this.config.getCurrentDir());
                    NText n = this.txts.parser().parse(newP);
                    return this.txts.transform(n, this.config.copy().setProcessIncludes(true).setCurrentDir(newP.getParent()).setImportClassLoader(this.config.getImportClassLoader()));
                }
                return t;
            }
            case CODE: {
                NTextCode t = (NTextCode)text;
                if (this.config.isNormalize() || this.config.isFlatten()) {
                    text = t.highlight();
                    text = this.txts.transform(text, context.getConfig().copy().setFlatten(true).setNormalize(this.config.isNormalize()).setProcessVars(this.config.isProcessVars()).setVarProvider(this.config.getVarProvider()));
                }
                if (this.config.isApplyTheme()) {
                    NTextFormatTheme theme = this.txts.getTheme(this.config.getThemeName()).orElse(this.txts.getTheme());
                    text = this.mapTxt(text, x -> {
                        if (x.type() == NTextType.STYLED) {
                            NTextStyled y = (NTextStyled)x;
                            NTextStyles basicStyles = theme.toBasicStyles(y.getStyles(), this.config.isBasicTrueStyles());
                            if (!y.getStyles().equals(basicStyles)) {
                                return this.txts.ofStyled(y.getChild(), basicStyles);
                            }
                            return x;
                        }
                        return x;
                    });
                }
                return text;
            }
        }
        return text;
    }

    private NText mapApplyThemeAndFilter(NText text) {
        if (this.config.isFiltered()) {
            text = this.mapTxt(text, x -> {
                if (x.type() == NTextType.STYLED) {
                    return ((NTextStyled)x).getChild();
                }
                return x;
            });
        } else if (this.config.isApplyTheme()) {
            NTextFormatTheme theme = this.txts.getTheme(this.config.getThemeName()).orElse(this.txts.getTheme());
            text = this.mapTxt(text, x -> {
                if (x.type() == NTextType.STYLED) {
                    NTextStyled y = (NTextStyled)x;
                    NTextStyles basicStyles = theme.toBasicStyles(y.getStyles(), this.config.isBasicTrueStyles());
                    if (!y.getStyles().equals(basicStyles)) {
                        return this.txts.ofStyled(y.getChild(), basicStyles);
                    }
                    return x;
                }
                return x;
            });
        }
        return text;
    }

    private NText mapTxt(NText li, Function<NText, NText> f) {
        return this.compressTxt(this.asList(li).stream().map(f).collect(Collectors.toList()));
    }

    private NText compressTxt(List<NText> li) {
        return li.isEmpty() ? null : (li.size() == 1 ? li.get(0) : this.txts.ofList(li));
    }

    private boolean isNewline(String c) {
        return c != null && (c.startsWith("\n") || c.startsWith("\r"));
    }

    private boolean isNewline(NText c) {
        return c instanceof NTextPlain && this.isNewline(((NTextPlain)c).getValue());
    }

    private NPath resolveRelativePath(String path, NPath curr) {
        if (path.startsWith("classpath:")) {
            NPath p = NPath.of(path, Thread.currentThread().getContextClassLoader());
            if (p.exists()) {
                return p;
            }
            p = NPath.of(path, this.getClass().getClassLoader());
            if (p.exists()) {
                return p;
            }
            throw new NIllegalArgumentException(NMsg.ofC("unable to resolve path %s", path));
        }
        return NPath.of(path, this.getClass().getClassLoader());
    }

    private NText applyFlatStyle(NText tt, NTextStyles styles) {
        ArrayList<NText> li = new ArrayList<NText>();
        for (NText c : this.asList(tt)) {
            li.add(this.txts.ofStyled(c, styles));
        }
        return this.compressTxt(li);
    }

    private List<NText> asList(NText text) {
        if (text == null) {
            return Collections.emptyList();
        }
        if (text instanceof NTextList) {
            return ((NTextList)text).getChildren();
        }
        return Arrays.asList(text);
    }

    private NText flatten(NTextPlain tt) {
        return this.flatten(tt.getValue());
    }

    private NText flatten(String tt) {
        ArrayList<NText> li = new ArrayList<NText>();
        for (String line : CoreStringUtils.splitOnNewlines(tt)) {
            li.add(this.txts.ofPlain(line));
        }
        return this.compressTxt(li);
    }
}

