/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTextStyleGenerator;
import net.thevpc.nuts.text.NTextStyles;

public class DefaultNTextStyleGenerator
implements NTextStyleGenerator {
    private boolean includeForeground;
    private boolean includeBackground;
    private int colors = 8;
    private boolean includePlain;
    private boolean includeBold;
    private boolean includeBlink;
    private boolean includeReversed;
    private boolean includeItalic;
    private boolean includeUnderlined;
    private boolean includeStriked;
    private Random rnd = new Random();
    private List<NTextStyle> decos;
    private List<Function<Integer, NTextStyles>> supps;

    private int resolveColorType() {
        switch (this.colors) {
            case 0: 
            case 4: {
                return 1;
            }
            case 2: 
            case 8: {
                return 2;
            }
            case 3: 
            case 24: {
                return 3;
            }
        }
        return 3;
    }

    private NTextStyle fg(int i) {
        switch (this.resolveColorType()) {
            case 1: {
                if (i < 0) {
                    i = this.rnd.nextInt(16);
                }
                return NTextStyle.primary(i % 16);
            }
            case 2: {
                if (i < 0) {
                    i = this.rnd.nextInt(256);
                }
                return NTextStyle.foregroundColor(i % 256);
            }
        }
        if (i < 0) {
            i = this.rnd.nextInt(0x2000000);
        }
        return NTextStyle.foregroundTrueColor(i % 0x2000000);
    }

    private NTextStyle bg(int i) {
        switch (this.resolveColorType()) {
            case 1: {
                if (i < 0) {
                    i = this.rnd.nextInt(16);
                }
                return NTextStyle.secondary(i % 16);
            }
            case 2: {
                if (i < 0) {
                    i = this.rnd.nextInt(256);
                }
                return NTextStyle.backgroundColor(i % 256);
            }
        }
        if (i < 0) {
            i = this.rnd.nextInt(0x2000000);
        }
        return NTextStyle.backgroundTrueColor(i % 0x2000000);
    }

    private List<Function<Integer, NTextStyles>> supps() {
        if (this.supps == null) {
            boolean includeAny = this.isIncludeAny();
            this.supps = new ArrayList<Function<Integer, NTextStyles>>();
            if (this.includePlain || includeAny) {
                this.supps.add(i -> NTextStyles.PLAIN);
            }
            if (this.includeForeground || includeAny) {
                this.supps.add(i -> {
                    NTextStyle s = this.fg((int)i);
                    if (!this.decos().isEmpty() && this.rnd.nextBoolean()) {
                        NTextStyle s2 = this.decos().get(this.rnd.nextInt(this.decos().size()));
                        return NTextStyles.of(s, s2);
                    }
                    return NTextStyles.of(s);
                });
            }
            if (this.includeBackground || includeAny) {
                this.supps.add(i -> {
                    NTextStyle s = this.bg(-1);
                    if (!this.decos().isEmpty() && this.rnd.nextBoolean()) {
                        NTextStyle s2 = this.decos().get(this.rnd.nextInt(this.decos().size()));
                        return NTextStyles.of(s, s2);
                    }
                    return NTextStyles.of(s);
                });
            }
            if (!this.decos().isEmpty() && this.rnd.nextBoolean()) {
                this.supps.add(i -> {
                    NTextStyle s2 = this.decos().get(this.rnd.nextInt(this.decos().size()));
                    return NTextStyles.of(s2);
                });
            }
        }
        return this.supps;
    }

    @Override
    public NTextStyles hash(Object i) {
        return this.hash(i == null ? 0 : i.hashCode());
    }

    @Override
    public NTextStyles hash(int i) {
        i = Math.abs(i);
        int a = (i & 3) % this.supps().size();
        return this.supps().get(a).apply(i >>= 2);
    }

    @Override
    public NTextStyles random() {
        return this.supps().get(this.rnd.nextInt(this.supps().size())).apply(-1);
    }

    @Override
    public boolean isIncludePlain() {
        return this.includePlain;
    }

    @Override
    public NTextStyleGenerator setIncludePlain(boolean includePlain) {
        this.includePlain = includePlain;
        return this;
    }

    @Override
    public boolean isIncludeBold() {
        return this.includeBold;
    }

    @Override
    public NTextStyleGenerator setIncludeBold(boolean includeBold) {
        this.includeBold = includeBold;
        return this;
    }

    @Override
    public boolean isIncludeBlink() {
        return this.includeBlink;
    }

    @Override
    public NTextStyleGenerator setIncludeBlink(boolean includeBlink) {
        this.includeBlink = includeBlink;
        return this;
    }

    @Override
    public boolean isIncludeReversed() {
        return this.includeReversed;
    }

    @Override
    public NTextStyleGenerator setIncludeReversed(boolean includeReversed) {
        this.includeReversed = includeReversed;
        return this;
    }

    @Override
    public boolean isIncludeItalic() {
        return this.includeItalic;
    }

    @Override
    public NTextStyleGenerator setIncludeItalic(boolean includeItalic) {
        this.includeItalic = includeItalic;
        return this;
    }

    @Override
    public boolean isIncludeUnderlined() {
        return this.includeUnderlined;
    }

    @Override
    public NTextStyleGenerator setIncludeUnderlined(boolean includeUnderlined) {
        this.includeUnderlined = includeUnderlined;
        return this;
    }

    @Override
    public boolean isIncludeStriked() {
        return this.includeStriked;
    }

    @Override
    public NTextStyleGenerator setIncludeStriked(boolean includeStriked) {
        this.includeStriked = includeStriked;
        return this;
    }

    private List<NTextStyle> decos() {
        boolean includeAny = this.isIncludeAny();
        if (this.decos == null) {
            this.decos = new ArrayList<NTextStyle>();
            if (this.includeStriked || includeAny) {
                this.decos.add(NTextStyle.striked());
            }
            if (this.includeBold || includeAny) {
                this.decos.add(NTextStyle.bold());
            }
            if (this.includeBlink || includeAny) {
                this.decos.add(NTextStyle.blink());
            }
            if (this.includeReversed || includeAny) {
                this.decos.add(NTextStyle.reversed());
            }
            if (this.includeItalic || includeAny) {
                this.decos.add(NTextStyle.italic());
            }
            if (this.includeUnderlined || includeAny) {
                this.decos.add(NTextStyle.underlined());
            }
        }
        return this.decos;
    }

    public boolean isIncludeAny() {
        return !this.includeForeground && !this.includeBackground && !this.includeBold && !this.includeBlink && !this.includeUnderlined && !this.includeReversed && !this.includeStriked && !this.includeItalic && !this.includePlain;
    }

    @Override
    public boolean isIncludeForeground() {
        return this.includeForeground;
    }

    @Override
    public NTextStyleGenerator setIncludeForeground(boolean includeForeground) {
        this.includeForeground = includeForeground;
        return this;
    }

    @Override
    public boolean isIncludeBackground() {
        return this.includeBackground;
    }

    @Override
    public NTextStyleGenerator setIncludeBackground(boolean includeBackground) {
        this.includeBackground = includeBackground;
        return this;
    }

    @Override
    public boolean isUseThemeColors() {
        return this.colors == 4;
    }

    @Override
    public boolean isUsePaletteColors() {
        return this.colors == 8;
    }

    @Override
    public boolean isUseTrueColors() {
        return this.colors == 24;
    }

    @Override
    public NTextStyleGenerator setUseThemeColors() {
        this.colors = 4;
        return this;
    }

    @Override
    public NTextStyleGenerator setUsePaletteColors() {
        this.colors = 8;
        return this;
    }

    @Override
    public NTextStyleGenerator setUseTrueColors() {
        this.colors = 24;
        return this;
    }
}

