/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.thevpc.nuts.core.NBootOptions;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.ext.NExtensions;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.log.NLogs;
import net.thevpc.nuts.platform.NOsFamily;
import net.thevpc.nuts.platform.NShellFamily;
import net.thevpc.nuts.runtime.standalone.elem.DefaultNElementFactoryService;
import net.thevpc.nuts.runtime.standalone.elem.NElementFactoryService;
import net.thevpc.nuts.runtime.standalone.elem.NElementStreamFormat;
import net.thevpc.nuts.runtime.standalone.format.json.DefaultJsonElementFormat;
import net.thevpc.nuts.runtime.standalone.format.tson.DefaultTsonElementFormat;
import net.thevpc.nuts.runtime.standalone.format.xml.DefaultXmlNElementStreamFormat;
import net.thevpc.nuts.runtime.standalone.format.yaml.SimpleYaml;
import net.thevpc.nuts.runtime.standalone.text.highlighter.CustomStyleCodeHighlighter;
import net.thevpc.nuts.runtime.standalone.text.theme.DefaultNTextFormatTheme;
import net.thevpc.nuts.runtime.standalone.text.theme.NTextFormatPropertiesTheme;
import net.thevpc.nuts.runtime.standalone.text.theme.NTextFormatThemeWrapper;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.xtra.expr.StringTokenizerUtils;
import net.thevpc.nuts.spi.NCodeHighlighter;
import net.thevpc.nuts.text.NContentType;
import net.thevpc.nuts.text.NFormats;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NTextFormatTheme;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTexts;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NStringUtils;

public class DefaultNTextManagerModel {
    private final NWorkspace workspace;
    private final Map<String, String> kindToHighlighter = new HashMap<String, String>();
    private final Map<String, NCodeHighlighter> highlighters = new HashMap<String, NCodeHighlighter>();
    private final Map<String, NCodeHighlighter> _cachedHighlighters = new HashMap<String, NCodeHighlighter>();
    private String styleThemeName;
    private NTextFormatTheme defaultTheme;
    private NElementFactoryService elementFactoryService;
    private NElementStreamFormat jsonMan;
    private NElementStreamFormat yamlMan;
    private NElementStreamFormat xmlMan;
    private NElementStreamFormat tsonMan;
    private Map<String, NTextFormatTheme> cachedThemes = new HashMap<String, NTextFormatTheme>();
    public NTexts defaultNTexts;
    public NFormats defaultNFormats;
    public NLogs defaultNLogs;

    public DefaultNTextManagerModel(NWorkspace workspace) {
        this.workspace = workspace;
    }

    public void loadExtensions() {
        List<NCodeHighlighter> all = NExtensions.of().createComponents(NCodeHighlighter.class, null);
        for (NCodeHighlighter h : all) {
            this.highlighters.put(h.getId().toLowerCase(), h);
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/net/thevpc/nuts/runtime/highlighter-mappings.ini")));){
            String line;
            String group = null;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.length() <= 0) continue;
                if (line.startsWith("[") && line.endsWith("]")) {
                    group = line.substring(1, line.length() - 1).trim();
                    continue;
                }
                if (group == null) continue;
                for (String s : StringTokenizerUtils.splitDefault(line)) {
                    s = s.trim();
                    this.kindToHighlighter.put(s, group);
                }
            }
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
    }

    public NTextFormatTheme getDefaultTheme() {
        if (this.defaultTheme == null) {
            this.defaultTheme = NWorkspace.of().getOsFamily() == NOsFamily.WINDOWS ? new NTextFormatThemeWrapper(new NTextFormatPropertiesTheme("grass", null, this.workspace)) : new DefaultNTextFormatTheme();
        }
        return this.defaultTheme;
    }

    public NTextFormatTheme loadTheme(String y) {
        NTextFormatTheme t;
        if (NBlankable.isBlank(y = NStringUtils.trim(y))) {
            y = "default";
        }
        if ((t = this.cachedThemes.get(y)) != null) {
            return t;
        }
        if ("default".equals(y)) {
            t = this.getDefaultTheme();
            this.cachedThemes.put(y, t);
            return t;
        }
        t = new NTextFormatThemeWrapper(new NTextFormatPropertiesTheme(y, null, this.workspace));
        this.cachedThemes.put(y, t);
        return t;
    }

    public NOptional<NTextFormatTheme> getTheme(String name) {
        if (NBlankable.isBlank(name)) {
            return NOptional.ofNamedEmpty(NMsg.ofC("theme"));
        }
        if (NBlankable.isBlank(name)) {
            if (this.styleThemeName == null) {
                NBootOptions bootOptions = NWorkspaceExt.of().getModel().bootModel.getBootUserOptions();
                this.styleThemeName = bootOptions.getTheme().orNull();
            }
            if (NBlankable.isBlank(name = this.styleThemeName)) {
                name = "default";
            }
        }
        try {
            return NOptional.of(this.loadTheme(name));
        }
        catch (Exception ex) {
            return NOptional.ofNamedEmpty(NMsg.ofC("theme %s", name));
        }
    }

    public NTextFormatTheme getTheme() {
        return this.getTheme("").orElse(this.getDefaultTheme());
    }

    public void setTheme(NTextFormatTheme styleTheme) {
        if (styleTheme != null) {
            this.cachedThemes.put(styleTheme.getName(), styleTheme);
            this.styleThemeName = styleTheme.getName();
        } else {
            this.styleThemeName = "default";
        }
    }

    public void setTheme(String styleThemeName) {
        this.styleThemeName = this.loadTheme(styleThemeName).getName();
    }

    public NCodeHighlighter getCodeHighlighter(String highlighterId) {
        String lc = NStringUtils.trim(highlighterId).toLowerCase();
        NCodeHighlighter old = this._cachedHighlighters.get(lc);
        if (old != null) {
            return old;
        }
        NCodeHighlighter h = this.highlighters.get(lc);
        if (h != null) {
            this._cachedHighlighters.put(lc, h);
            return h;
        }
        int best = -1;
        for (NCodeHighlighter hh : this.highlighters.values()) {
            int lvl = hh.getScore(NScorableContext.of(lc));
            if (lvl <= 0 || best >= lvl) continue;
            best = lvl;
            h = hh;
        }
        if (best > 0) {
            this._cachedHighlighters.put(lc, h);
            return h;
        }
        String a = this.kindToHighlighter.get(lc);
        if (a != null && (h = this.highlighters.get(a)) != null) {
            this._cachedHighlighters.put(lc, h);
            return h;
        }
        if ("system".equals(lc)) {
            NShellFamily shellFamily = NWorkspace.of().getShellFamily();
            h = this.getCodeHighlighter(shellFamily.id());
            this._cachedHighlighters.put(lc, h);
            return h;
        }
        if (lc.length() > 0) {
            try {
                NTextStyle found = NTextStyle.parse(NStringUtils.trim(highlighterId)).orNull();
                if (found != null) {
                    h = new CustomStyleCodeHighlighter(found);
                    this._cachedHighlighters.put(lc, h);
                    return h;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((h = this.highlighters.get("plain")) != null) {
            return h;
        }
        throw new NIllegalArgumentException(NMsg.ofPlain("not found plain highlighter"));
    }

    private String expandAlias(String ss) {
        switch (ss.toUpperCase()) {
            case "BOOL": {
                ss = "BOOLEAN";
                break;
            }
            case "KW": {
                ss = "KEYWORD";
            }
        }
        return ss;
    }

    public void addCodeHighlighter(NCodeHighlighter format) {
        this.highlighters.put(format.getId(), format);
    }

    public void removeCodeHighlighter(String id) {
        this.highlighters.remove(id);
    }

    public NCodeHighlighter[] getCodeHighlighters() {
        return this.highlighters.values().toArray(new NCodeHighlighter[0]);
    }

    public NElementFactoryService getElementFactoryService() {
        if (this.elementFactoryService == null) {
            this.elementFactoryService = new DefaultNElementFactoryService(this.workspace);
        }
        return this.elementFactoryService;
    }

    public NElementStreamFormat getStreamFormat(NContentType contentType) {
        switch (contentType) {
            case JSON: {
                return this.getJsonMan();
            }
            case YAML: {
                return this.getYamlMan();
            }
            case XML: {
                return this.getXmlMan();
            }
            case TSON: {
                return this.getTsonMan();
            }
        }
        throw new NIllegalArgumentException(NMsg.ofC("invalid content type %s. Only structured content types are allowed.", contentType));
    }

    public NElementStreamFormat getJsonMan() {
        if (this.jsonMan == null) {
            this.jsonMan = new DefaultJsonElementFormat();
        }
        return this.jsonMan;
    }

    public NElementStreamFormat getYamlMan() {
        if (this.yamlMan == null) {
            this.yamlMan = new SimpleYaml();
        }
        return this.yamlMan;
    }

    public NElementStreamFormat getXmlMan() {
        if (this.xmlMan == null) {
            this.xmlMan = new DefaultXmlNElementStreamFormat();
        }
        return this.xmlMan;
    }

    public NElementStreamFormat getTsonMan() {
        if (this.tsonMan == null) {
            this.tsonMan = new DefaultTsonElementFormat();
        }
        return this.tsonMan;
    }

    public NWorkspace getWorkspace() {
        return this.workspace;
    }
}

