/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.thevpc.nuts.runtime.standalone.text.DefaultNTextStyleGenerator;
import net.thevpc.nuts.runtime.standalone.text.NTextNodeWriterStringer;
import net.thevpc.nuts.runtime.standalone.text.parser.AbstractNText;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNTextList;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNTextPlain;
import net.thevpc.nuts.runtime.standalone.text.parser.NTextListSimplifier;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NPrimitiveText;
import net.thevpc.nuts.text.NTerminalCmd;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextBuilder;
import net.thevpc.nuts.text.NTextList;
import net.thevpc.nuts.text.NTextPlain;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTextStyleGenerator;
import net.thevpc.nuts.text.NTextStyled;
import net.thevpc.nuts.text.NTextStyles;
import net.thevpc.nuts.text.NTextTransformConfig;
import net.thevpc.nuts.text.NTextType;
import net.thevpc.nuts.text.NTexts;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NStream;
import net.thevpc.nuts.util.NUnsupportedOperationException;

public class DefaultNTextBuilder
extends AbstractNText
implements NTextBuilder {
    private final List<NText> children = new ArrayList<NText>();
    private final NTexts txt = NTexts.of();
    private NTextStyleGenerator styleGenerator;
    private boolean flattened = true;

    @Override
    public Iterator<NText> iterator() {
        return Collections.unmodifiableList(this.getChildren()).iterator();
    }

    @Override
    public NTextType type() {
        return NTextType.BUILDER;
    }

    @Override
    public NTextStyleGenerator getStyleGenerator() {
        if (this.styleGenerator == null) {
            this.styleGenerator = new DefaultNTextStyleGenerator();
        }
        return this.styleGenerator;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public DefaultNTextBuilder setStyleGenerator(NTextStyleGenerator styleGenerator) {
        this.styleGenerator = styleGenerator;
        return this;
    }

    @Override
    public NTextBuilder appendCommand(NTerminalCmd command) {
        this.append(this.txt.ofCommand(command));
        return this;
    }

    @Override
    public NTextBuilder appendCode(String lang, String text) {
        this.append(this.txt.ofCode(lang, text));
        return this;
    }

    @Override
    public NTextBuilder appendHashStyle(Object text) {
        return this.appendHashStyle(text, text);
    }

    @Override
    public NTextBuilder appendRandomStyle(Object text) {
        if (text == null) {
            return this;
        }
        return this.append(text, this.getStyleGenerator().random());
    }

    @Override
    public NTextBuilder appendHashStyle(Object text, Object hash) {
        if (text == null) {
            return this;
        }
        if (hash == null) {
            hash = text;
        }
        return this.append(text, this.getStyleGenerator().hash(hash));
    }

    @Override
    public NTextBuilder append(Object text, NTextStyle style) {
        return this.append(text, NTextStyles.of(style));
    }

    @Override
    public NTextBuilder append(Object text, NTextStyles styles) {
        if (text != null) {
            if (styles.size() == 0) {
                this.append(NText.of(text));
            } else {
                this.append(this.txt.ofStyled(NText.of(text), styles));
            }
        }
        return this;
    }

    @Override
    public NTextBuilder append(Object node) {
        if (node != null) {
            return this.append(NText.of(node));
        }
        return this;
    }

    @Override
    public NTextBuilder append(NText node) {
        if (node != null) {
            if (node instanceof NTextBuilder) {
                this.children.add(((NTextBuilder)node).build());
            } else {
                this.children.add(node);
            }
            this.flattened = false;
        }
        return this;
    }

    @Override
    public NText substring(int start, int end) {
        if (start < 0 || end < start || end > this.length()) {
            throw new IndexOutOfBoundsException("Invalid start or end");
        }
        DefaultNTextBuilder result = new DefaultNTextBuilder();
        int pos = 0;
        for (NText child : this.getChildren()) {
            int childLen = child.filteredText().length();
            int childStart = pos;
            int childEnd = pos + childLen;
            if (childEnd > start) {
                if (childStart >= end) break;
                int subStart = Math.max(start - childStart, 0);
                int subEnd = Math.min(end - childStart, childLen);
                result.append(child.substring(subStart, subEnd));
            }
            pos += childLen;
        }
        return result.build();
    }

    @Override
    public NTextBuilder delete(int start, int end) {
        if (start < 0 || end < start || end > this.filteredText().length()) {
            throw new IndexOutOfBoundsException("Invalid start or end");
        }
        int pos = 0;
        ArrayList<NText> newChildren = new ArrayList<NText>();
        for (NText child : this.children) {
            int childLen = child.filteredText().length();
            int childStart = pos;
            int childEnd = pos + childLen;
            if (childEnd <= start) {
                newChildren.add(child);
            } else if (childStart >= end) {
                newChildren.add(child);
            } else {
                int leftEnd = Math.max(start - childStart, 0);
                int rightStart = Math.min(end - childStart, childLen);
                if (leftEnd > 0) {
                    newChildren.add(child.substring(0, leftEnd));
                }
                if (rightStart < childLen) {
                    newChildren.add(child.substring(rightStart, childLen));
                }
            }
            pos += childLen;
        }
        this.children.clear();
        this.children.addAll(newChildren);
        return this;
    }

    @Override
    public NTextBuilder appendJoined(Object separator, Collection<?> others) {
        if (others != null) {
            boolean first = true;
            for (Object other : others) {
                if (other == null) continue;
                if (first) {
                    first = false;
                } else if (separator != null) {
                    this.append(separator);
                }
                this.append(other);
            }
        }
        return this;
    }

    @Override
    public NTextBuilder appendAll(NText[] others) {
        if (others != null) {
            for (NText node : others) {
                if (node == null) continue;
                this.append(node);
            }
        }
        return this;
    }

    @Override
    public NTextBuilder appendAll(Collection<?> others) {
        if (others != null) {
            for (Object node : others) {
                if (node == null) continue;
                this.append(node);
            }
        }
        return this;
    }

    @Override
    public NText build() {
        List<NText> all = new NTextListSimplifier().addAll(this.children).toList();
        if (all.isEmpty()) {
            return DefaultNTextPlain.EMPTY;
        }
        if (all.size() == 1) {
            return all.get(0);
        }
        if (!all.equals(this.children)) {
            return new DefaultNTextList(all.toArray(new NText[0]));
        }
        return this;
    }

    @Override
    public List<NText> getChildren() {
        return new ArrayList<NText>(this.children);
    }

    @Override
    public NTextBuilder insert(int at, NText ... items) {
        if (items == null || items.length == 0) {
            return this;
        }
        if (at < 0 || at > this.length()) {
            throw new IndexOutOfBoundsException("Invalid position: " + at);
        }
        if (at == this.length()) {
            this.append(items);
            return this;
        }
        int currentPos = 0;
        for (int i = 0; i < this.children.size(); ++i) {
            NText part = this.children.get(i);
            int partLength = part.length();
            if (at < currentPos + partLength) {
                int offsetInPart = at - currentPos;
                if (offsetInPart == 0) {
                    this.children.addAll(i, Arrays.asList(items));
                } else if (offsetInPart == partLength) {
                    this.children.addAll(i + 1, Arrays.asList(items));
                } else {
                    NText left = part.substring(0, offsetInPart);
                    NText right = part.substring(offsetInPart, partLength);
                    this.children.set(i, left);
                    this.children.addAll(i + 1, Arrays.asList(items));
                    this.children.add(i + 1 + items.length, right);
                }
                return this;
            }
            currentPos += partLength;
        }
        this.children.addAll(Arrays.asList(items));
        return this;
    }

    @Override
    public NTextBuilder replace(int from, int to, NText ... newTexts) {
        if (from < 0 || to < from || to > this.length()) {
            throw new IndexOutOfBoundsException("Invalid range: " + from + " to " + to);
        }
        int pos = 0;
        int i = 0;
        ArrayList<NText> result = new ArrayList<NText>();
        for (NText t : this.children) {
            int splitStart;
            int len = t.length();
            if (pos + len <= from) {
                result.add(t);
            } else if (pos <= from && from < pos + len && (splitStart = from - pos) > 0) {
                result.add(t.substring(0, splitStart));
            }
            if (pos < to && to <= pos + len) {
                int splitEnd = to - pos;
                if (newTexts != null && newTexts.length > 0) {
                    result.addAll(Arrays.asList(newTexts));
                }
                if (splitEnd < len) {
                    result.add(t.substring(splitEnd, t.length()));
                }
            }
            if (pos >= to) {
                result.add(t);
            }
            pos += len;
            ++i;
        }
        this.children.clear();
        this.children.addAll(result);
        return this;
    }

    @Override
    public int size() {
        return this.children.size();
    }

    @Override
    public NText get(int index) {
        return this.children.get(index);
    }

    @Override
    public NTextBuilder flatten() {
        if (!this.flattened) {
            NText build = this.build();
            NText a = this.txt.transform(build, new NTextTransformConfig().setFlatten(true));
            this.children.clear();
            this.fill(a);
            this.flattened = true;
        }
        return this;
    }

    private void fill(NText z) {
        if (z != null) {
            if (z instanceof NTextList) {
                for (NText c : ((NTextList)z).getChildren()) {
                    this.fill(c);
                }
            } else if (z instanceof NTextPlain) {
                this.children.add(z);
            } else if (z instanceof NTextStyled) {
                if (((NTextStyled)z).getChild() instanceof NTextList) {
                    NText nText = this.txt.transform(z, new NTextTransformConfig().setFlatten(true));
                }
                this.children.add(z);
            } else {
                throw new NUnsupportedOperationException(NMsg.ofPlain("expected plain or styled nodes"));
            }
        }
    }

    @Override
    public NTextBuilder removeAt(int index) {
        this.children.remove(index);
        return this;
    }

    @Override
    public NStream<NTextBuilder> lines() {
        final DefaultNTextBuilder z = (DefaultNTextBuilder)this.copy().flatten();
        return NStream.ofIterator(new Iterator<NTextBuilder>(){
            NTextBuilder n;

            @Override
            public boolean hasNext() {
                this.n = z.readLine();
                return this.n != null;
            }

            @Override
            public NTextBuilder next() {
                return this.n;
            }
        });
    }

    @Override
    public NTextBuilder newLine() {
        return this.append(NText.ofNewLine());
    }

    @Override
    public NTextBuilder readLine() {
        if (this.size() == 0) {
            return null;
        }
        ArrayList<NText> r = new ArrayList<NText>();
        while (this.size() > 0) {
            NText t = this.get(0);
            this.removeAt(0);
            if (this.isNewLine(t)) break;
            r.add(t);
        }
        return NTextBuilder.of().appendAll(r);
    }

    @Override
    public NTextBuilder clear() {
        this.children.clear();
        return this;
    }

    private boolean isNewLine(NText t) {
        if (t.type() == NTextType.PLAIN) {
            String txt = ((NTextPlain)t).getValue();
            return txt.equals("\n") || txt.equals("\r\n");
        }
        return false;
    }

    public NTextBuilder copy() {
        DefaultNTextBuilder c = new DefaultNTextBuilder();
        c.appendAll(this.children);
        c.flattened = this.flattened;
        return c;
    }

    @Override
    public NText immutable() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        NTextNodeWriterStringer ss = new NTextNodeWriterStringer(out);
        ss.writeNode(this.build());
        return new DefaultNTextList(this.children.toArray(new NText[0])).simplify();
    }

    @Override
    public NText simplify() {
        List<NText> all = new NTextListSimplifier().addAll(this.children).toList();
        this.children.clear();
        this.children.addAll(all);
        return this;
    }

    @Override
    public String filteredText() {
        StringBuilder sb = new StringBuilder();
        for (NText child : this.children) {
            sb.append(child.filteredText());
        }
        return sb.toString();
    }

    @Override
    public int length() {
        int count = 0;
        for (NText child : this.children) {
            count += child.length();
        }
        return count;
    }

    @Override
    public boolean isEmpty() {
        for (NText child : this.children) {
            if (child.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public NTextBuilder builder() {
        return this.copy();
    }

    @Override
    public boolean isBlank() {
        return NBlankable.isBlank(this.filteredText());
    }

    @Override
    public NStream<NPrimitiveText> toCharStream() {
        if (this.children.isEmpty()) {
            return NStream.ofEmpty();
        }
        NStream<NPrimitiveText> s = this.children.get(0).toCharStream();
        for (int i = 1; i < this.children.size(); ++i) {
            s = s.concat(this.children.get(i).toCharStream());
        }
        return s;
    }

    @Override
    public boolean isWhitespace() {
        boolean hasContent = false;
        for (NText child : this.children) {
            if (child.isEmpty()) continue;
            if (!child.isWhitespace()) {
                return false;
            }
            hasContent = true;
        }
        return hasContent;
    }

    @Override
    public List<NText> split(String separators, boolean keepSeparators) {
        ArrayList<NText> result = new ArrayList<NText>();
        NTextBuilder current = NTextBuilder.of();
        for (NText child : this.getChildren()) {
            List<NText> parts = child.split(separators, keepSeparators);
            for (NText part : parts) {
                String s = part.filteredText();
                if (keepSeparators && s.length() == 1 && separators.indexOf(s.charAt(0)) >= 0) {
                    if (current.length() > 0) {
                        result.add(current.build());
                        current = NTextBuilder.of();
                    }
                    result.add(part);
                    continue;
                }
                current.append(part);
            }
        }
        if (current.length() > 0) {
            result.add(current.build());
        }
        return result;
    }

    @Override
    public NTextBuilder trimLeft() {
        for (int i = 0; i < this.children.size(); ++i) {
            NText c = this.children.get(i).trimLeft();
            int l = c.length();
            if (l > 0) {
                this.children.set(i, c);
                break;
            }
            this.children.remove(i);
            --i;
        }
        return this;
    }

    @Override
    public NTextBuilder trimRight() {
        for (int i = this.children.size() - 1; i >= 0; --i) {
            NText c = this.children.get(i).trimRight();
            int l = c.length();
            if (l > 0) {
                this.children.set(i, c);
                break;
            }
            this.children.remove(i);
        }
        return this;
    }

    @Override
    public NTextBuilder trim() {
        this.trimLeft();
        this.trimRight();
        return this;
    }
}

