/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.security;

import java.util.ArrayList;
import java.util.List;
import net.thevpc.nuts.security.NUser;
import net.thevpc.nuts.security.NUserConfig;
import net.thevpc.nuts.util.NBlankable;

public class DefaultNUser
implements NUser {
    private final String remoteIdentity;
    private final String user;
    private final boolean credentials;
    private final List<String> permissions;
    private final List<String> inheritedPermissions;
    private final List<String> groups;

    public DefaultNUser(NUserConfig config, List<String> inheritedPermissions) {
        this.user = config.getUser();
        this.remoteIdentity = config.getRemoteIdentity();
        this.credentials = !NBlankable.isBlank(config.getCredentials());
        this.permissions = new ArrayList<String>(config.getPermissions());
        this.groups = new ArrayList<String>(config.getGroups());
        this.inheritedPermissions = new ArrayList<String>(inheritedPermissions);
    }

    @Override
    public List<String> getInheritedPermissions() {
        return this.inheritedPermissions;
    }

    @Override
    public String getRemoteIdentity() {
        return this.remoteIdentity;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public boolean hasCredentials() {
        return this.credentials;
    }

    @Override
    public List<String> getPermissions() {
        return this.permissions;
    }

    @Override
    public List<String> getGroups() {
        return this.groups;
    }
}

