/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.security;

import java.util.Arrays;
import java.util.Map;
import net.thevpc.nuts.runtime.standalone.io.util.CoreSecurityUtils;
import net.thevpc.nuts.security.NAuthenticationAgent;
import net.thevpc.nuts.security.NSecurityException;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NScorableContext;

public abstract class AbstractNAuthenticationAgent
implements NAuthenticationAgent {
    private final String name;
    private int score;

    public AbstractNAuthenticationAgent(String name, int score) {
        this.name = name;
        this.score = score;
    }

    @Override
    public String getId() {
        return this.name;
    }

    @Override
    public boolean removeCredentials(char[] credentialsId, Map<String, String> envProvider) {
        this.extractId(credentialsId);
        return true;
    }

    @Override
    public int getScore(NScorableContext authenticationAgent) {
        return this.score;
    }

    @Override
    public void checkCredentials(char[] credentialsId, char[] password, Map<String, String> envProvider) {
        if (password == null || NBlankable.isBlank(new String(password))) {
            throw new NSecurityException(NMsg.ofPlain("missing old password"));
        }
        CredentialsId iid = this.extractId(credentialsId);
        switch (iid.type) {
            case 'H': {
                if (!Arrays.equals(iid.value, this.hashChars(password, this.getPassphrase(envProvider)))) break;
                return;
            }
            case 'B': {
                char[] encPwd = this.encryptChars(password, this.getPassphrase(envProvider));
                if (!Arrays.equals(iid.value, encPwd)) break;
                return;
            }
        }
        throw new NSecurityException(NMsg.ofPlain("invalid login or password"));
    }

    private CredentialsId extractId(char[] a) {
        char[] idc;
        if (a != null && !NBlankable.isBlank(new String(a)) && a.length > (idc = (this.getId() + ":").toCharArray()).length + 1) {
            boolean ok = true;
            for (int i = 0; i < idc.length; ++i) {
                if (a[i] == idc[i]) continue;
                ok = false;
                break;
            }
            if (ok && (a[idc.length] == 'H' || a[idc.length] == 'B')) {
                return new CredentialsId(a[idc.length], Arrays.copyOfRange(a, idc.length + 1, a.length));
            }
        }
        throw new NSecurityException(NMsg.ofC("credential id must start with '%s:'", this.getId()));
    }

    @Override
    public char[] getCredentials(char[] credentialsId, Map<String, String> envProvider) {
        CredentialsId validCredentialsId = this.extractId(credentialsId);
        if (validCredentialsId.type == 'B') {
            return this.decryptChars(validCredentialsId.value, this.getPassphrase(envProvider));
        }
        throw new NSecurityException(NMsg.ofPlain("credential is hashed and cannot be retrived"));
    }

    @Override
    public char[] createCredentials(char[] credentials, boolean allowRetrieve, char[] credentialId, Map<String, String> envProvider) {
        int type;
        char[] val;
        if (credentials == null || NBlankable.isBlank(new String(credentials))) {
            return null;
        }
        if (allowRetrieve) {
            val = this.encryptChars(credentials, this.getPassphrase(envProvider));
            type = 66;
        } else {
            val = this.hashChars(credentials, this.getPassphrase(envProvider));
            type = 72;
        }
        String id = this.getId();
        char[] r = new char[id.length() + 2 + val.length];
        System.arraycopy(id.toCharArray(), 0, r, 0, id.length());
        r[id.length()] = 58;
        r[id.length() + 1] = type;
        System.arraycopy(val, 0, r, id.length() + 2, val.length);
        return r;
    }

    public String getPassphrase(Map<String, String> envProvider) {
        String defVal = CoreSecurityUtils.DEFAULT_PASSPHRASE;
        if (envProvider != null) {
            String r = envProvider.get("nuts.authentication-agent.simple.passphrase");
            if (r == null) {
                r = defVal;
            }
            if (r == null || r.isEmpty()) {
                r = defVal;
            }
            return r;
        }
        return defVal;
    }

    protected abstract char[] decryptChars(char[] var1, String var2);

    protected abstract char[] encryptChars(char[] var1, String var2);

    protected abstract char[] hashChars(char[] var1, String var2);

    private static class CredentialsId {
        char type;
        char[] value;

        public CredentialsId(char type, char[] value) {
            this.type = type;
            this.value = value;
        }
    }
}

