/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.util;

import java.util.ArrayList;
import java.util.List;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.util.NBlankable;

public class MultiBaseIdFilterHelper {
    private List<NId> baseIds;
    private List<String> baseIdStrings;
    public List<List<String>> expectedPathNames;

    public MultiBaseIdFilterHelper(String ... baseIds) {
        ArrayList<NId> ids = new ArrayList<NId>();
        ArrayList<String> idstr = new ArrayList<String>();
        ArrayList<List<String>> names = new ArrayList<List<String>>();
        if (baseIds != null) {
            for (String baseId : baseIds) {
                if (!NBlankable.isBlank(baseId)) continue;
                NId longId = NId.of(baseId).getLongId();
                ids.add(longId);
                idstr.add(longId.toString());
                names.add(NPath.of(longId.getMavenPath("")).getNames());
            }
        }
        this.baseIds = ids;
        this.baseIdStrings = idstr;
        this.expectedPathNames = names;
    }

    public List<NId> getBaseIds() {
        return this.baseIds;
    }

    public List<String> getBaseIdStrings() {
        return this.baseIdStrings;
    }

    public List<List<String>> getExpectedPathNames() {
        return this.expectedPathNames;
    }

    public boolean isAcceptableBasePaths(NPath[] basePaths) {
        if (basePaths == null) {
            return true;
        }
        if (basePaths.length == 0) {
            return true;
        }
        for (NPath basePath : basePaths) {
            if (!this.isAcceptableBasePath(basePath)) continue;
            return true;
        }
        return false;
    }

    private boolean isAcceptableBasePath(List<String> names, List<String> expectedNames) {
        if (names.size() >= expectedNames.size()) {
            for (int i = 0; i < expectedNames.size(); ++i) {
                if (expectedNames.get(i).equals(names.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isAcceptableBasePath(NPath basePath) {
        List<String> names = basePath.getNames();
        List<List<String>> expectedNames2 = this.getExpectedPathNames();
        if (expectedNames2.isEmpty()) {
            return true;
        }
        for (List<String> strings : expectedNames2) {
            if (!this.isAcceptableBasePath(names, strings)) continue;
            return true;
        }
        return false;
    }
}

