/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.toolbox.helpers;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.thevpc.nuts.artifact.NArtifactCallBuilder;
import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NDescriptorBuilder;
import net.thevpc.nuts.artifact.NEnvConditionBuilder;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NIdBuilder;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.elem.NElementDescribables;
import net.thevpc.nuts.io.NCp;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPathOption;
import net.thevpc.nuts.runtime.standalone.definition.NDefinitionHelper;
import net.thevpc.nuts.runtime.standalone.repository.toolbox.ToolboxRepoHelper;
import net.thevpc.nuts.runtime.standalone.repository.toolbox.ToolboxRepositoryModel;
import net.thevpc.nuts.runtime.standalone.repository.util.SingleBaseIdFilterHelper;
import net.thevpc.nuts.runtime.standalone.util.NCoreLogUtils;
import net.thevpc.nuts.runtime.standalone.xtra.web.DefaultNWebCli;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NFunction;
import net.thevpc.nuts.util.NIterator;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NPredicate;
import net.thevpc.nuts.util.NStream;

public class TomcatRepoHelper
implements ToolboxRepoHelper {
    public static final String HTTPS_ARCHIVE_APACHE_ORG_DIST_TOMCAT = "https://archive.apache.org/dist/tomcat/";
    protected SingleBaseIdFilterHelper baseIdFilterHelper = new SingleBaseIdFilterHelper("org.apache.catalina:apache-tomcat");

    @Override
    public NIterator<NId> searchVersions(NId id, NDefinitionFilter filter, NRepository repository) {
        return this.search(filter, new NPath[]{null}, repository);
    }

    @Override
    public boolean acceptId(NId id) {
        return this.baseIdFilterHelper.accept(id);
    }

    @Override
    public NDescriptor fetchDescriptor(NId id, NRepository repository) {
        if (!this.acceptId(id)) {
            return null;
        }
        String r = this.getUrl(id.getVersion(), ".zip");
        URL url = null;
        boolean found = false;
        try {
            url = new URL(r);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        NSession session = NSession.of();
        if (url != null) {
            session.getTerminal().printProgress(NMsg.ofC("peek %s", NCoreLogUtils.forProgressUrl(url)));
            try (InputStream inputStream = DefaultNWebCli.prepareGlobalOpenStream(url);){
                found = true;
            }
            catch (Exception ex) {
                found = false;
            }
        }
        if (found) {
            int i = id.getVersion().getIntegerAt(0).orElse(-1);
            int j = id.getVersion().getIntegerAt(1).orElse(-1);
            String javaVersion = "";
            if (i > 0) {
                javaVersion = i <= 3 ? "#1.1" : (i <= 4 ? "#1.3" : (i <= 5 ? "#1.4" : (i <= 6 ? "#1.5" : (i <= 7 ? "#1.6" : (i <= 8 ? "#1.7" : (i <= 9 ? "#1.8" : (j <= 0 ? "#1.8" : "#11")))))));
            }
            return NDescriptorBuilder.of().setId(id.getLongId()).setPackaging("zip").setIcons("https://upload.wikimedia.org/wikipedia/commons/f/fe/Apache_Tomcat_logo.svg", "https://upload.wikimedia.org/wikipedia/commons/thumb/f/fe/Apache_Tomcat_logo.svg/595px-Apache_Tomcat_logo.svg.png").setInstaller(NArtifactCallBuilder.of().setId(NId.of("net.thevpc.nsh:nsh")).setArguments("$nutsIdInstallScriptPath").setScriptName("install-catalina.nsh").setScriptContent("unzip --skip-root \"$nutsIdContentPath\" \"$nutsIdBinPath/app\" \n" + (NWorkspace.of().getOsFamily().isPosix() ? "chmod a+x $nutsIdBinPath/app/*.sh \n" : "")).build()).setExecutor(NArtifactCallBuilder.of().setId(NId.of("exec")).setArguments(NWorkspace.of().getOsFamily().isWindow() ? "$nutsIdBinPath/app/bin/catalina.bat" : "$nutsIdBinPath/app/bin/catalina.sh").build()).setCondition(NEnvConditionBuilder.of().setPlatform(Arrays.asList("java" + javaVersion))).setDescription("Apache Tomcat Official Zip Bundle").setProperty("dynamic-descriptor", "true").build();
        }
        return null;
    }

    @Override
    public NIterator<NId> search(final NDefinitionFilter filter, NPath[] basePaths, final NRepository repository) {
        if (!this.baseIdFilterHelper.accept(basePaths)) {
            return null;
        }
        final NIdBuilder idBuilder = NIdBuilder.of("org.apache.catalina", "apache-tomcat");
        return NPath.of("htmlfs+https://archive.apache.org/dist/tomcat/").stream().filter((Predicate)NPredicate.of(x -> x.isDirectory() && x.getName().matches("tomcat-[0-9.]+")).redescribe(NElementDescribables.ofDesc("directory && tomcat"))).flatMapStream(NFunction.of(s -> s.stream().filter((Predicate)NPredicate.of(x2 -> x2.isDirectory() && x2.getName().startsWith("v")).redescribe(NElementDescribables.ofDesc("isDirectory"))).flatMapStream(NFunction.of(new Function<NPath, NStream<NId>>(){

            @Override
            public NStream<NId> apply(NPath x3) {
                boolean checkBin;
                String s2n = x3.getName();
                String prefix = "apache-tomcat-";
                String bin = "bin";
                if (s2n.endsWith("-alpha/") || s2n.endsWith("-beta/") || s2n.endsWith("-copyforpermissions/") || s2n.endsWith("-original/") || s2n.matches(".*-RC[0-9]+/") || s2n.matches(".*-M[0-9]+/")) {
                    return NStream.ofEmpty();
                }
                NVersion version = NVersion.get(s2n.substring(1, s2n.length() - 1)).get();
                if (version.compareTo("4.1.32") < 0) {
                    prefix = "jakarta-tomcat-";
                }
                if (version.compareTo("4.1.27") == 0) {
                    bin = "binaries";
                }
                if (checkBin = false) {
                    String finalPrefix = prefix;
                    return x3.resolve(bin).stream().filter((Predicate)NPredicate.of(x4 -> x4.getName().matches(finalPrefix + "[0-9]+\\.[0-9]+\\.[0-9]+\\.zip")).redescribe(NElementDescribables.ofDesc("name.isZip"))).map(NFunction.of(x5 -> {
                        String s3 = x5.getName();
                        String v0 = s3.substring(finalPrefix.length(), s3.length() - 4);
                        NVersion v = NVersion.get(v0).get();
                        NId id2 = idBuilder.setVersion(v).build();
                        if (filter == null || filter.acceptDefinition(NDefinitionHelper.ofIdOnlyFromRepo(id2, repository, "TomcatRepoHelper 1"))) {
                            return id2;
                        }
                        return null;
                    }).redescribe((Supplier)NElementDescribables.ofDesc("toZip"))).nonNull();
                }
                NId id2 = idBuilder.setVersion(version).build();
                if (filter == null || filter.acceptDefinition(NDefinitionHelper.ofIdOnlyFromRepo(id2, repository, "TomcatRepoHelper 2"))) {
                    return NStream.ofSingleton(id2);
                }
                return NStream.ofEmpty();
            }
        }).redescribe((Supplier)NElementDescribables.ofDesc("flatMap")))).redescribe((Supplier)NElementDescribables.ofDesc("flatMap"))).iterator();
    }

    @Override
    public NPath fetchContent(NId id, NDescriptor descriptor, NRepository repository) {
        if (!this.baseIdFilterHelper.accept(id)) {
            return null;
        }
        String r = this.getUrl(id.getVersion(), ".zip");
        NPath localPath = NPath.of(ToolboxRepositoryModel.getIdLocalFile(id.builder().setFaceContent().build(), repository));
        NCp.of().from(NPath.of(r)).to(localPath).addOptions(NPathOption.SAFE, NPathOption.LOG, NPathOption.TRACE).run();
        return localPath;
    }

    private String getUrl(NVersion version, String extension) {
        String bin = "bin";
        String prefix = "apache-tomcat-";
        if (version.compareTo("4.1.32") < 0) {
            prefix = "jakarta-tomcat-";
        }
        if (version.compareTo("4.1.27") == 0) {
            bin = "binaries";
        }
        return "https://archive.apache.org/dist/tomcat/tomcat-" + version.get(0).flatMap(NLiteral::asString).orElse("unknown") + "/v" + version + "/" + bin + "/" + prefix + version + extension;
    }
}

