/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.index;

import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDB;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBDefaultIndexDefinition;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBTableDefinition;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBTableStore;
import net.thevpc.nuts.util.NStream;

public class ArtifactsIndexDB {
    public static final String DEFAULT_ARTIFACT_TABLE_NAME = "Artifacts";
    private final NanoDBTableStore<NId> table;

    public ArtifactsIndexDB(String tableName, NanoDB db) {
        this.table = db.createTable(ArtifactsIndexDB.def(tableName, db), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArtifactsIndexDB of() {
        NWorkspace nWorkspace = NWorkspace.of();
        synchronized (nWorkspace) {
            ArtifactsIndexDB o = (ArtifactsIndexDB)NWorkspace.of().getProperties().get(ArtifactsIndexDB.class.getName());
            if (o == null) {
                o = new ArtifactsIndexDB(DEFAULT_ARTIFACT_TABLE_NAME, NWorkspaceExt.of().store().cacheDB());
                NWorkspace.of().getProperties().put(ArtifactsIndexDB.class.getName(), o);
            }
            return o;
        }
    }

    private static NanoDBTableDefinition<NId> def(String name, NanoDB db) {
        return new NanoDBTableDefinition<NId>(name, NId.class, db.getSerializers().of(NId.class, false), new NanoDBDefaultIndexDefinition<NId>("id", String.class, false, x -> x.getLongId().builder().setRepository(x.getRepository()).build().toString()), new NanoDBDefaultIndexDefinition<NId>("groupId", String.class, false, NId::getGroupId), new NanoDBDefaultIndexDefinition<NId>("artifactId", String.class, false, NId::getArtifactId), new NanoDBDefaultIndexDefinition<NId>("repository", String.class, false, NId::getRepository));
    }

    public NStream<NId> findAll() {
        return this.table.stream();
    }

    public NStream<NId> findByGroupId(String groupId) {
        return this.table.findByIndex("groupId", groupId);
    }

    public NStream<NId> findByArtifactId(String artifactId) {
        return this.table.findByIndex("artifactId", artifactId);
    }

    public void add(NId id) {
        this.table.add(id);
    }

    public void flush() {
        this.table.flush();
    }

    public boolean contains(NId id) {
        return this.table.findByIndex("id", id.getLongId().builder().setRepository(id.getRepository()).build().toDependency()).findAny().orNull() != null;
    }
}

