/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl.nuts;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.thevpc.nuts.artifact.NArtifactNotFoundException;
import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NDescriptorParser;
import net.thevpc.nuts.artifact.NDescriptorStyle;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.command.NFetchMode;
import net.thevpc.nuts.command.NFetchModeNotSupportedException;
import net.thevpc.nuts.core.NAddRepositoryOptions;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NIOUtils;
import net.thevpc.nuts.io.NInputSource;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.repository.impl.folder.NFolderRepositoryBase;
import net.thevpc.nuts.runtime.standalone.repository.impl.nuts.NRepoIter;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NStringUtils;
import net.thevpc.nuts.util.NUnsupportedArgumentException;

public class NFolderRepository
extends NFolderRepositoryBase {
    private boolean userPom = false;

    public NFolderRepository(NAddRepositoryOptions options, NRepository parentRepository) {
        super(options, parentRepository, null, true, "nuts", true);
        this.repoIter = new NRepoIter(this);
        this.extensions.put("src", "-src.zip");
    }

    @Override
    public NId searchLatestVersionCore(NId id, NDefinitionFilter filter, NFetchMode fetchMode) {
        return null;
    }

    @Override
    public String getIdExtension(NId id) {
        String f;
        Map<String, String> q = id.getProperties();
        switch (f = NStringUtils.trim(q.get("face"))) {
            case "descriptor": {
                return ".nuts";
            }
            case "descriptor-hash": {
                return ".nuts.sha1";
            }
            case "catalog": {
                return ".nuts.catalog";
            }
            case "content-hash": {
                return this.getIdExtension(id.builder().setFaceContent().build()) + ".sha1";
            }
            case "content": {
                String packaging = q.get("packaging");
                return NWorkspace.of().getDefaultIdContentExtension(packaging);
            }
        }
        throw new NUnsupportedArgumentException(NMsg.ofC("unsupported fact %s", f));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NDescriptor fetchDescriptorCore(NId id, NFetchMode fetchMode) {
        if (!this.acceptedFetchNoCache(fetchMode)) {
            throw new NArtifactNotFoundException(id, (Throwable)new NFetchModeNotSupportedException(this, fetchMode, id.toString(), null));
        }
        NPath nutsPath = this.getIdRemotePath(id);
        NArtifactNotFoundException nutsPathEx = null;
        try {
            InputStream stream = null;
            NId idDesc = id.builder().setFaceDescriptor().build();
            try {
                NDescriptor nutsDescriptor = null;
                byte[] bytes = null;
                String name = null;
                try {
                    stream = this.getStream(idDesc, "artifact descriptor", "retrieve");
                    bytes = NIOUtils.loadByteArray(stream, true);
                    name = NInputSource.of(stream).getMetaData().getName().orElse("no-name");
                    nutsDescriptor = NDescriptorParser.of().setDescriptorStyle(NDescriptorStyle.NUTS).parse(CoreIOUtils.createBytesStream(bytes, NMsg.ofNtf(name), "application/json", StandardCharsets.UTF_8.name(), "nuts.json")).get();
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
                this.checkSHA1Hash(id.builder().setFace("descriptor-hash").build(), CoreIOUtils.createBytesStream(bytes, name == null ? null : NMsg.ofNtf(name), "application/json", StandardCharsets.UTF_8.name(), "nuts.json"), "artifact descriptor");
                return nutsDescriptor;
            }
            catch (IOException | UncheckedIOException | NIOException ex) {
                throw new NArtifactNotFoundException(id, new NArtifactNotFoundException.NIdInvalidDependency[0], new NArtifactNotFoundException.NIdInvalidLocation[]{new NArtifactNotFoundException.NIdInvalidLocation(this.getName(), this.getIdRemotePath(idDesc).toString(), ex.getMessage())}, ex);
            }
        }
        catch (NArtifactNotFoundException e) {
            nutsPathEx = e;
            if (this.userPom) {
                InputStream stream = null;
                NPath pomURL = this.config().getLocationPath().resolve(this.getIdBasedir(id).resolve(this.getIdFilename(id, ".pom")));
                try {
                    NDescriptor nutsDescriptor = null;
                    byte[] bytes = null;
                    String name = null;
                    try {
                        stream = this.openStream(id, pomURL, id, "artifact descriptor", NMsg.ofC("retrieve %s", id.getLongId()));
                        bytes = NIOUtils.loadByteArray(stream, true);
                        name = NInputSource.of(stream).getMetaData().getName().orElse("no-name");
                        nutsDescriptor = NDescriptorParser.of().setDescriptorStyle(NDescriptorStyle.NUTS).parse(CoreIOUtils.createBytesStream(bytes, NMsg.ofNtf(name), "text/xml", StandardCharsets.UTF_8.name(), "pom.xml")).get();
                    }
                    finally {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    this.checkSHA1Hash(id.builder().setFace("descriptor-hash").build(), CoreIOUtils.createBytesStream(bytes, name == null ? null : NMsg.ofNtf(name), "text/xml", StandardCharsets.UTF_8.name(), "pom.xml"), "artifact descriptor");
                    return nutsDescriptor;
                }
                catch (IOException | UncheckedIOException | NIOException ex) {
                    throw new NArtifactNotFoundException(id, new NArtifactNotFoundException.NIdInvalidDependency[0], new NArtifactNotFoundException.NIdInvalidLocation[]{new NArtifactNotFoundException.NIdInvalidLocation(this.getName(), nutsPath.toString(), nutsPathEx.getMessage()), new NArtifactNotFoundException.NIdInvalidLocation(this.getName(), pomURL.toString(), ex.getMessage())}, ex);
                }
            }
            throw new NArtifactNotFoundException(id, new NArtifactNotFoundException.NIdInvalidDependency[0], new NArtifactNotFoundException.NIdInvalidLocation[]{new NArtifactNotFoundException.NIdInvalidLocation(this.getName(), nutsPath.toString(), nutsPathEx.getMessage())}, nutsPathEx);
        }
    }
}

