/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl.maven.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NArtifactCall;
import net.thevpc.nuts.artifact.NArtifactNotFoundException;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NDependencyBuilder;
import net.thevpc.nuts.artifact.NDependencyFilters;
import net.thevpc.nuts.artifact.NDependencyScope;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NDescriptorContributor;
import net.thevpc.nuts.artifact.NDescriptorFlag;
import net.thevpc.nuts.artifact.NDescriptorLicense;
import net.thevpc.nuts.artifact.NDescriptorProperty;
import net.thevpc.nuts.artifact.NEnvCondition;
import net.thevpc.nuts.artifact.NEnvConditionBuilder;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NIdBuilder;
import net.thevpc.nuts.artifact.NIdLocation;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.artifact.NVersionComparator;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.command.NFetchCmd;
import net.thevpc.nuts.command.NFetchMode;
import net.thevpc.nuts.command.NFetchStrategy;
import net.thevpc.nuts.core.NAddRepositoryOptions;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.expr.NParseException;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NIOUtils;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.platform.NArchFamily;
import net.thevpc.nuts.platform.NOsFamily;
import net.thevpc.nuts.platform.NShellFamily;
import net.thevpc.nuts.runtime.standalone.DefaultNArtifactCall;
import net.thevpc.nuts.runtime.standalone.DefaultNDescriptorBuilder;
import net.thevpc.nuts.runtime.standalone.DefaultNDescriptorContributor;
import net.thevpc.nuts.runtime.standalone.DefaultNDescriptorLicense;
import net.thevpc.nuts.runtime.standalone.DefaultNDescriptorOrganization;
import net.thevpc.nuts.runtime.standalone.DefaultNDescriptorPropertyBuilder;
import net.thevpc.nuts.runtime.standalone.DefaultNEnvConditionBuilder;
import net.thevpc.nuts.runtime.standalone.descriptor.util.NDescriptorUtils;
import net.thevpc.nuts.runtime.standalone.format.xml.XmlUtils;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.NPomIdResolver;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.NPomXmlParser;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.api.NPom;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.api.NPomDependency;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.api.NPomId;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.api.NPomProfile;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.api.NPomProfileActivation;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.util.MavenMetadata;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.util.MavenMetadataParser;
import net.thevpc.nuts.runtime.standalone.util.CoreNUtils;
import net.thevpc.nuts.runtime.standalone.util.MapToFunction;
import net.thevpc.nuts.runtime.standalone.util.NCoreLogUtils;
import net.thevpc.nuts.runtime.standalone.xtra.expr.StringTokenizerUtils;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NPositionType;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NException;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NStringUtils;
import org.w3c.dom.Element;

public class MavenUtils {
    private MavenUtils() {
    }

    public static MavenUtils of() {
        MavenUtils wp = (MavenUtils)NWorkspace.of().getProperties().get(MavenUtils.class.getName());
        if (wp == null) {
            wp = new MavenUtils();
            NWorkspace.of().setProperty(MavenUtils.class.getName(), wp);
        }
        return wp;
    }

    public static NPomIdResolver createPomIdResolver(NWorkspace workspace) {
        NPomIdResolver wp = (NPomIdResolver)NWorkspace.of().getProperties().get(NPomIdResolver.class.getName());
        if (wp == null) {
            wp = new NPomIdResolver();
            NWorkspace.of().setProperty(NPomIdResolver.class.getName(), wp);
        }
        return wp;
    }

    public List<NId> toNutsId(List<NPomId> ids) {
        return ids.stream().map(this::toNutsId).collect(Collectors.toList());
    }

    public NDependency[] toNutsDependencies(NPomDependency[] deps, NPom pom, NPomProfileActivation ac, String profile) {
        NDependency[] a = new NDependency[deps.length];
        for (int i = 0; i < deps.length; ++i) {
            a[i] = this.toNutsDependency(deps[i], pom, ac, profile);
        }
        return a;
    }

    public NId toNutsId(NPomId d) {
        return NIdBuilder.of(d.getGroupId(), d.getArtifactId()).setVersion(this.toNutsVersion(d.getVersion())).build();
    }

    public NEnvCondition toCondition(String os0, String arch0, NPomProfileActivation a, String profile) {
        NOsFamily os = NOsFamily.parse(os0).orNull();
        NArchFamily arch = NArchFamily.parse(arch0).orNull();
        String osVersion = null;
        String platform = null;
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        if (a != null) {
            NOsFamily os2;
            if (!NBlankable.isBlank(a.getOsVersion())) {
                osVersion = a.getOsVersion();
            }
            if (!NBlankable.isBlank(a.getOsArch())) {
                arch = NArchFamily.parse(a.getOsArch()).orNull();
            }
            if (!NBlankable.isBlank(a.getOsName())) {
                os2 = NOsFamily.parse(a.getOsName()).orNull();
                if (os2 != null) {
                    os = os2;
                }
            } else if (!NBlankable.isBlank(a.getOsFamily()) && (os2 = NOsFamily.parse(a.getOsFamily()).orNull()) != null) {
                os = os2;
            }
            if (!NBlankable.isBlank(a.getJdk())) {
                platform = "java#" + this.toNutsVersion(a.getJdk());
            }
            if (a.getPropertyName() != null) {
                props.put(a.getPropertyName(), a.getPropertyValue());
            }
        }
        String oss = null;
        if (os != null) {
            oss = osVersion == null ? os.id() : os.id() + "#" + osVersion;
        }
        String ars = null;
        if (arch != null) {
            ars = arch.id();
        }
        NEnvConditionBuilder bb = new DefaultNEnvConditionBuilder().setOs(oss == null ? null : Arrays.asList(oss)).setArch(ars == null ? null : Arrays.asList(ars)).setPlatform(platform == null ? null : Arrays.asList(platform)).setProfile(profile == null ? null : Arrays.asList(profile));
        bb.setProperties(props);
        return bb.build();
    }

    public NDependency toNutsDependency(NPomDependency d, NPom pom, NPomProfileActivation a, String profile) {
        String s = d.getScope();
        if (s == null) {
            s = "";
        }
        s = s.trim();
        NDependencyScope dependencyScope = NDependencyScope.API;
        switch (s) {
            case "": 
            case "compile": {
                dependencyScope = NDependencyScope.API;
                break;
            }
            case "test": {
                dependencyScope = NDependencyScope.TEST_API;
                break;
            }
            case "system": {
                dependencyScope = NDependencyScope.SYSTEM;
                break;
            }
            case "runtime": {
                dependencyScope = NDependencyScope.RUNTIME;
                break;
            }
            case "provided": {
                dependencyScope = NDependencyScope.PROVIDED;
                break;
            }
            case "import": {
                dependencyScope = NDependencyScope.IMPORT;
                break;
            }
            default: {
                dependencyScope = NDependencyScope.parse(s).orElse(NDependencyScope.API);
                if (dependencyScope != null) break;
                this.LOG().log(NMsg.ofJ("unable to parse maven scope {0} for {1}", s, d).asFinestFail());
                dependencyScope = NDependencyScope.API;
            }
        }
        return NDependencyBuilder.of().setGroupId(d.getGroupId()).setArtifactId(d.getArtifactId()).setClassifier(d.getClassifier()).setVersion(this.toNutsVersion(d.getVersion())).setOptional(d.getOptional()).setScope(dependencyScope.id()).setCondition(this.toCondition(d.getOs(), d.getArch(), a, profile)).setType(d.getType()).setExclusions(this.toNutsId(Arrays.asList(d.getExclusions()))).build();
    }

    private NLog LOG() {
        return NLog.of(MavenUtils.class);
    }

    public NDescriptor parsePomXml(InputStream stream, NFetchMode fetchMode, String urlDesc, NRepository repository) {
        long startTime = System.currentTimeMillis();
        try {
            String categories;
            if (stream == null) {
                return null;
            }
            byte[] bytes = NIOUtils.loadByteArray(stream);
            InputStream bytesStream = CoreIOUtils.createBytesStream(bytes, urlDesc == null ? NMsg.ofNtf("pom.xml") : NMsg.ofNtf(urlDesc), "text/xml", StandardCharsets.UTF_8.name(), urlDesc == null ? "pom.xml" : urlDesc);
            NPom pom = new NPomXmlParser().parse(bytesStream);
            LinkedHashSet<NDescriptorFlag> flags = new LinkedHashSet<NDescriptorFlag>();
            if (NLiteral.of(pom.getProperties().get("nuts.executable")).asBoolean().orElse(false).booleanValue()) {
                flags.add(NDescriptorFlag.EXEC);
            } else {
                Element ee = pom.getXml().getDocumentElement();
                if (XmlUtils.testNode(ee, x -> {
                    if (x instanceof Element) {
                        Element e = (Element)x;
                        if (XmlUtils.isNode(e, "build", "plugins", "plugin", "configuration", "archive", "manifest", "mainClass")) {
                            return true;
                        }
                        if (NStringUtils.trim(e.getTextContent()).equals("exec-war-only") && XmlUtils.isNode(e, "build", "plugins", "plugin", "executions", "execution", "goals", "goal")) {
                            return true;
                        }
                    }
                    return false;
                })) {
                    flags.add(NDescriptorFlag.EXEC);
                    flags.add(NDescriptorFlag.PLATFORM_APP);
                }
            }
            if (NLiteral.of(pom.getProperties().get("nuts.application")).asBoolean().orElse(false).booleanValue()) {
                flags.add(NDescriptorFlag.NUTS_APP);
                flags.add(NDescriptorFlag.EXEC);
            }
            if (NLiteral.of(pom.getProperties().get("nuts.gui")).asBoolean().orElse(false).booleanValue()) {
                flags.add(NDescriptorFlag.GUI);
                flags.add(NDescriptorFlag.EXEC);
            }
            if (NLiteral.of(pom.getProperties().get("nuts.term")).asBoolean().orElse(false).booleanValue()) {
                flags.add(NDescriptorFlag.TERM);
                flags.add(NDescriptorFlag.EXEC);
            }
            if (pom.getPackaging().isEmpty()) {
                pom.setPackaging("jar");
            }
            long time = System.currentTimeMillis() - startTime;
            if (fetchMode == null) {
                fetchMode = NFetchMode.REMOTE;
            }
            String fetchString = "[" + NStringUtils.formatAlign(fetchMode.id(), 7, NPositionType.FIRST) + "] ";
            this.LOG().log(NMsg.ofJ("{0}{1} parse pom    {2}", fetchString, NStringUtils.formatAlign(repository == null ? "<no-repo>" : repository.getName(), 20, NPositionType.FIRST), NText.ofStyledPath(urlDesc)).withLevel(Level.FINEST).withIntent(NMsgIntent.SUCCESS).withDurationMillis(time));
            String icons = pom.getProperties().get("nuts.icons");
            if (icons == null) {
                icons = "";
            }
            if ((categories = pom.getProperties().get("nuts.categories")) == null) {
                categories = "";
            }
            NPomProfile[] profiles = pom.getProfiles();
            ArrayList<NDependency> deps = new ArrayList<NDependency>(Arrays.asList(this.toNutsDependencies(pom.getDependencies(), pom, null, null)));
            for (NPomProfile profile : profiles) {
                deps.addAll(Arrays.asList(this.toNutsDependencies(profile.getDependencies(), pom, profile.getActivation(), profile.getId())));
            }
            ArrayList<NDependency> depsM = new ArrayList<NDependency>(Arrays.asList(this.toNutsDependencies(pom.getDependenciesManagement(), pom, null, null)));
            for (NPomProfile profile : profiles) {
                depsM.addAll(Arrays.asList(this.toNutsDependencies(profile.getDependenciesManagement(), pom, profile.getActivation(), profile.getId())));
            }
            ArrayList<NDescriptorProperty> props = new ArrayList<NDescriptorProperty>();
            for (Map.Entry<String, String> e : pom.getProperties().entrySet()) {
                props.add(new DefaultNDescriptorPropertyBuilder().setName(e.getKey()).setValue(e.getValue()).build());
            }
            for (NPomProfile profile : profiles) {
                for (Map.Entry<String, String> e : profile.getProperties().entrySet()) {
                    props.add(new DefaultNDescriptorPropertyBuilder().setName(e.getKey()).setValue(e.getValue()).setCondition(this.toCondition(null, null, profile.getActivation(), profile.getId())).build());
                }
            }
            NVersion mavenCompilerTarget = null;
            for (String v : new String[]{"maven.compiler.target", "project.target.level"}) {
                String vv = pom.getProperties().get(v);
                if (NBlankable.isBlank(vv) || mavenCompilerTarget != null && mavenCompilerTarget.compareTo(vv) >= 0) continue;
                mavenCompilerTarget = NVersion.get(vv).get();
            }
            LinkedHashSet<String> toRemoveProps = new LinkedHashSet<String>();
            NArtifactCall installerCall = this.parseCall(pom.getProperties().get("nuts.installer"), pom.getProperties().get("nuts.installer.scriptName"), pom.getProperties().get("nuts.installer.scriptContent"));
            NArtifactCall executorCall = this.parseCall(pom.getProperties().get("nuts.executor"), pom.getProperties().get("nuts.executor.scriptName"), pom.getProperties().get("nuts.executor.scriptContent"));
            LinkedHashSet<NIdLocation> idLocations = new LinkedHashSet<NIdLocation>();
            NIdLocation idLocation = this.parseLocation(pom.getProperties(), "nuts.location", toRemoveProps);
            if (idLocation != null) {
                idLocations.add(idLocation);
            }
            String genericName = pom.getProperties().get("nuts.genericName");
            idLocation = this.parseLocation(pom.getProperties(), "nuts.location.0", toRemoveProps);
            if (idLocation != null) {
                idLocations.add(idLocation);
            }
            for (int i = 0; i < 32 && (idLocation = this.parseLocation(pom.getProperties(), "nuts.location." + i, toRemoveProps)) != null; ++i) {
                idLocations.add(idLocation);
            }
            Iterator iterator = props.iterator();
            block23: while (iterator.hasNext()) {
                String n;
                NDescriptorProperty prop = (NDescriptorProperty)iterator.next();
                if (!prop.getCondition().isBlank()) continue;
                switch (n = prop.getName()) {
                    case "nuts.installer": 
                    case "nuts.executor": 
                    case "nuts.categories": 
                    case "nuts.icons": 
                    case "nuts.term": 
                    case "nuts.gui": 
                    case "nuts.application": 
                    case "nuts.executable": 
                    case "nuts.genericName": {
                        iterator.remove();
                        continue block23;
                    }
                }
                if (!toRemoveProps.contains(n)) continue;
                iterator.remove();
            }
            return new DefaultNDescriptorBuilder().setId(this.toNutsId(pom.getPomId())).setParents(pom.getParent() == null ? null : Arrays.asList(this.toNutsId(pom.getParent()))).setPackaging(pom.getPackaging()).setFlags(flags).setName(pom.getName()).setDescription(pom.getDescription()).setLocations(new ArrayList<NIdLocation>(idLocations)).setCondition(new DefaultNEnvConditionBuilder().setPlatform(Arrays.asList(mavenCompilerTarget == null ? "java" : "java#" + mavenCompilerTarget))).setDependencies(deps).setStandardDependencies(depsM).setCategories(StringTokenizerUtils.splitDefault(categories).stream().map(String::trim).filter(x -> !x.isEmpty()).collect(Collectors.toList())).setInstaller(installerCall).setExecutor(executorCall).setIcons(StringTokenizerUtils.splitDefault(icons).stream().map(String::trim).filter(x -> !x.isEmpty()).collect(Collectors.toList())).setLicenses(pom.getLicenses() == null ? new ArrayList<NDescriptorLicense>() : Arrays.stream(pom.getLicenses()).map(x -> new DefaultNDescriptorLicense(x.getName(), x.getName(), x.getUrl(), x.getDistribution(), x.getComments(), null, new LinkedHashMap<String, String>())).collect(Collectors.toList())).setContributors(pom.getContributors() == null ? new ArrayList<NDescriptorContributor>() : Arrays.stream(pom.getContributors()).map(x -> new DefaultNDescriptorContributor(x.getEmail(), x.getName(), x.getUrl(), x.getEmail(), new ArrayList<String>(), x.getTimeZone(), new ArrayList<String>(), new DefaultNDescriptorOrganization(x.getOrganization(), x.getOrganization(), x.getOrganizationUrl(), null, new LinkedHashMap<String, String>()), x.getProperties() == null ? new LinkedHashMap<String, String>() : new LinkedHashMap<String, String>(x.getProperties()), null)).collect(Collectors.toList())).setDevelopers(pom.getDevelopers() == null ? new ArrayList<NDescriptorContributor>() : Arrays.stream(pom.getDevelopers()).map(x -> new DefaultNDescriptorContributor(x.getEmail(), x.getName(), x.getUrl(), x.getEmail(), new ArrayList<String>(), x.getTimeZone(), new ArrayList<String>(), new DefaultNDescriptorOrganization(x.getOrganization(), x.getOrganization(), x.getOrganizationUrl(), null, new LinkedHashMap<String, String>()), x.getProperties() == null ? new LinkedHashMap<String, String>() : new LinkedHashMap<String, String>(x.getProperties()), null)).collect(Collectors.toList())).setGenericName(genericName).setProperties(props).build();
        }
        catch (Exception e) {
            long time = System.currentTimeMillis() - startTime;
            this.LOG().log(NMsg.ofJ("caching pom file {0}", urlDesc).withLevel(Level.FINEST).withIntent(NMsgIntent.FAIL).withDurationMillis(time));
            throw new NParseException(NMsg.ofC("error parsing %s", urlDesc), (Throwable)e);
        }
    }

    private NIdLocation parseLocation(Map<String, String> properties, String propName, Set<String> toRemoveProps) {
        String url = properties.get(propName + ".url");
        String region = properties.get(propName + ".region");
        String classifier = properties.get(propName + ".classifier");
        if (!NBlankable.isBlank(url)) {
            toRemoveProps.add(propName + ".url");
            toRemoveProps.add(propName + ".region");
            toRemoveProps.add(propName + ".classifier");
            return new NIdLocation(NStringUtils.trimToNull(url), NStringUtils.trimToNull(region), NStringUtils.trimToNull(classifier));
        }
        return null;
    }

    public String toNutsVersion(String version) {
        return version == null ? null : version.replace("(", "]").replace(")", "[");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NDescriptor parsePomXmlAndResolveParents(NPath path, NFetchMode fetchMode, NRepository repository) {
        try {
            NSession session = NSession.of();
            session.getTerminal().printProgress(NMsg.ofC("%-8s %s", "parse", NCoreLogUtils.forProgress(path)));
            try (InputStream is = path.getInputStream();){
                NDescriptor nutsDescriptor = this.parsePomXmlAndResolveParents(is, fetchMode, path.toString(), repository);
                if (nutsDescriptor.getId().getArtifactId() == null) {
                    if (this.LOG().isLoggable(Level.FINE)) {
                        this.LOG().log(NMsg.ofJ("unable to fetch valid descriptor artifactId from {0} : resolved id was {1}", path, nutsDescriptor.getId()).asFineFail());
                    }
                    NDescriptor nDescriptor2 = null;
                    return nDescriptor2;
                }
                NDescriptor nDescriptor = nutsDescriptor;
                return nDescriptor;
            }
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NDescriptor parsePomXmlAndResolveParents(InputStream stream, NFetchMode fetchMode, String urlDesc, NRepository repository) {
        NDescriptor nutsDescriptor = null;
        try {
            try {
                NDescriptorProperty nutsPackaging;
                NId thisId;
                nutsDescriptor = this.parsePomXml(stream, fetchMode, urlDesc, repository);
                HashMap<String, String> properties = new HashMap<String, String>();
                NId parentId = null;
                Iterator<NId> iterator = nutsDescriptor.getParents().iterator();
                while (iterator.hasNext()) {
                    NId nutsId;
                    parentId = nutsId = iterator.next();
                }
                NDescriptor parentDescriptor = null;
                if (parentId != null && !CoreNUtils.isEffectiveId(parentId)) {
                    try {
                        parentDescriptor = NFetchCmd.of(parentId).setTransitive(true).setFetchStrategy(fetchMode == NFetchMode.REMOTE ? NFetchStrategy.ONLINE : NFetchStrategy.OFFLINE).setDependencyFilter(NDependencyFilters.of().byRunnable()).getResultDescriptor();
                    }
                    catch (NException ex) {
                        throw ex;
                    }
                    catch (Exception ex) {
                        throw new NArtifactNotFoundException(nutsDescriptor.getId(), NMsg.ofC("unable to resolve %s parent %s", nutsDescriptor.getId(), parentId, ex));
                    }
                    parentId = parentDescriptor.getId();
                }
                if (parentId != null) {
                    properties.put("parent.groupId", parentId.getGroupId());
                    properties.put("parent.artifactId", parentId.getArtifactId());
                    properties.put("parent.version", parentId.getVersion().getValue());
                    properties.put("project.parent.groupId", parentId.getGroupId());
                    properties.put("project.parent.artifactId", parentId.getArtifactId());
                    properties.put("project.parent.version", parentId.getVersion().getValue());
                    nutsDescriptor = NDescriptorUtils.applyProperties(nutsDescriptor.builder(), properties).build();
                }
                if (!CoreNUtils.isEffectiveId(thisId = nutsDescriptor.getId())) {
                    if (parentId != null) {
                        if (NBlankable.isBlank(thisId.getGroupId())) {
                            thisId = thisId.builder().setGroupId(parentId.getGroupId()).build();
                        }
                        if (NBlankable.isBlank(thisId.getVersion().getValue())) {
                            thisId = thisId.builder().setVersion(parentId.getVersion().getValue()).build();
                        }
                    }
                    HashMap<NId, NDescriptor> cache = new HashMap<NId, NDescriptor>();
                    HashSet<String> done = new HashSet<String>();
                    Stack<NId> todo = new Stack<NId>();
                    todo.push(nutsDescriptor.getId());
                    cache.put(nutsDescriptor.getId(), nutsDescriptor);
                    while (todo.isEmpty()) {
                        NId pid = (NId)todo.pop();
                        NDescriptor d = (NDescriptor)cache.get(pid);
                        if (d == null) {
                            try {
                                d = NFetchCmd.of(pid).setDependencyFilter(NDependencyFilters.of().byRunnable()).getResultDescriptor();
                            }
                            catch (NException ex) {
                                throw ex;
                            }
                            catch (Exception ex) {
                                throw new NArtifactNotFoundException(nutsDescriptor.getId(), NMsg.ofC("unable to resolve %s parent %s", nutsDescriptor.getId(), pid, ex));
                            }
                        }
                        done.add(pid.getShortName());
                        if (!CoreNUtils.containsVars(thisId)) break;
                        thisId = NDescriptorUtils.applyProperties(thisId.builder(), new MapToFunction<String, String>(NDescriptorUtils.getPropertiesMap(d.getProperties()))).build();
                        for (NId nutsId : d.getParents()) {
                            if (done.contains(nutsId.getShortName())) continue;
                            todo.push(nutsId);
                        }
                    }
                    if (CoreNUtils.containsVars(thisId)) {
                        throw new NArtifactNotFoundException(nutsDescriptor.getId(), NMsg.ofC("unable to resolve %s parent %s", nutsDescriptor.getId(), parentId));
                    }
                    nutsDescriptor = nutsDescriptor.builder().setId(thisId).build();
                }
                if ((nutsPackaging = nutsDescriptor.getProperty("nuts-packaging").orNull()) != null && !NBlankable.isBlank(nutsPackaging.getValue())) {
                    nutsDescriptor = nutsDescriptor.builder().setPackaging((String)nutsDescriptor.getPropertyValue("nuts-packaging").flatMap(NLiteral::asString).get()).build();
                }
                properties.put("pom.groupId", thisId.getGroupId());
                properties.put("pom.version", thisId.getVersion().getValue());
                properties.put("pom.artifactId", thisId.getArtifactId());
                properties.put("project.groupId", thisId.getGroupId());
                properties.put("project.artifactId", thisId.getArtifactId());
                properties.put("project.version", thisId.getVersion().getValue());
                properties.put("version", thisId.getVersion().getValue());
                nutsDescriptor = NDescriptorUtils.applyProperties(nutsDescriptor.builder(), properties).build();
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
        catch (Exception ex) {
            throw new NParseException(NMsg.ofC("error Parsing %s", urlDesc), (Throwable)ex);
        }
        return nutsDescriptor;
    }

    public MavenMetadata parseMavenMetaData(InputStream metadataStream) {
        MavenMetadata s = new MavenMetadataParser().parseMavenMetaData(metadataStream);
        if (s == null) {
            return s;
        }
        Iterator<String> iterator = s.getVersions().iterator();
        while (iterator.hasNext()) {
            String version = iterator.next();
            if (s.getLatest().isEmpty() || NVersionComparator.ofMaven().compare(NVersion.of(version), NVersion.of(s.getLatest())) <= 0) continue;
            iterator.remove();
        }
        return s;
    }

    public NArtifactCall parseCall(String callString, String scriptName, String scriptContent) {
        if (callString == null) {
            return null;
        }
        NCmdLine cl = NCmdLine.of(callString, NShellFamily.BASH).setExpandSimpleOptions(false);
        NId callId = null;
        LinkedHashMap<String, String> callProps = new LinkedHashMap<String, String>();
        ArrayList<String> callPropsAsArgs = new ArrayList<String>();
        while (cl.hasNext() && cl.isNextOption()) {
            NArg a = cl.next().get();
            callPropsAsArgs.add(a.toString());
            if (a.isKeyValue()) {
                callProps.put(a.getStringKey().get(), a.getStringValue().get());
                continue;
            }
            callProps.put(a.toString(), null);
        }
        if (cl.hasNext()) {
            String callIdString = cl.next().get().toString();
            callId = NId.get(callIdString).orNull();
        }
        List<String> callArgs = cl.toStringList();
        if (callId != null) {
            return new DefaultNArtifactCall(callId, callArgs, scriptName, scriptContent);
        }
        if (!callPropsAsArgs.isEmpty()) {
            return new DefaultNArtifactCall(null, callPropsAsArgs, scriptName, scriptContent);
        }
        return null;
    }

    public static boolean isMavenSettingsRepository(NAddRepositoryOptions options) {
        if (!"maven".equals(options.getName())) {
            return false;
        }
        if (options.getRepositoryModel() != null) {
            return false;
        }
        if (options.getConfig() != null) {
            String n;
            if (!NBlankable.isBlank(options.getConfig().getName()) && !"maven".equals(options.getConfig().getName())) {
                return false;
            }
            if (!(NBlankable.isBlank(options.getConfig().getLocation()) || NBlankable.isBlank(n = options.getConfig().getLocation().toString()) || "maven".equals(n) || "maven@maven".equals(n))) {
                return false;
            }
        }
        return true;
    }
}

