/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.runtime.standalone.io.urlpart.URLPart;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.NPomXmlParser;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.api.NPomId;
import net.thevpc.nuts.runtime.standalone.util.jclass.JavaClassUtils;
import net.thevpc.nuts.runtime.standalone.xtra.web.DefaultNWebCli;
import net.thevpc.nuts.text.NMsg;

public class NPomIdResolver {
    public NPomId[] resolvePomIds(NPath baseUrl) {
        return this.resolvePomIds(baseUrl, null);
    }

    private NPomId[] resolvePomIdsFromTargetClasses(URLPart aa, String referenceResourcePath) {
        String basePath = aa.getPath().substring(0, aa.getPath().length() - (referenceResourcePath == null ? 0 : referenceResourcePath.length()));
        if (!basePath.endsWith("/") && !basePath.endsWith("\\")) {
            basePath = basePath + "/";
        }
        ArrayList<NPomId> all = new ArrayList<NPomId>();
        if (basePath.matches(".*[/\\\\]target[/\\\\]classes[/\\\\]")) {
            String s2 = basePath.substring(0, basePath.length() - "/target/classes".length()) + "pom.xml";
            try {
                all.add(new NPomXmlParser().parse(NPath.of(s2).toURL().get()).getPomId());
            }
            catch (Exception ex) {
                NLog.of(NPomXmlParser.class).log(NMsg.ofC("failed to parse pom file %s : %s", s2, ex).withIntent(NMsgIntent.ALERT).withLevel(Level.FINEST));
            }
        } else if (basePath.matches(".*[/\\\\]target[/\\\\]test-classes[/\\\\]")) {
            String s2 = basePath.substring(0, basePath.length() - "/target/test-classes".length()) + "pom.xml";
            try {
                all.add(new NPomXmlParser().parse(NPath.of(s2).toURL().get()).getPomId());
            }
            catch (Exception ex) {
                NLog.of(NPomXmlParser.class).log(NMsg.ofC("failed to parse pom file %s : %s", s2, ex).withIntent(NMsgIntent.ALERT).withLevel(Level.FINEST));
            }
        }
        return all.toArray(new NPomId[0]);
    }

    private NPomId[] resolvePomIdsFromMetaInfMavenByRef(URLPart aa, String referenceResourcePath) {
        String basePath = aa.getPath().substring(0, aa.getPath().length() - (referenceResourcePath == null ? 0 : referenceResourcePath.length()));
        if (!basePath.endsWith("/") && !basePath.endsWith("\\")) {
            basePath = basePath + "/";
        }
        URLPart p = aa.rootSibling(basePath + "META-INF/maven");
        return this.resolvePomIdsFromMetaInfMaven0(p);
    }

    private NPomId[] resolvePomIdsFromMetaInfMaven0(URLPart p) {
        URLPart[] children;
        ArrayList<NPomId> all = new ArrayList<NPomId>();
        for (URLPart url : children = p.getChildren(false, true, new MvnPomPropsURLFilter())) {
            if (url == null) continue;
            Properties prop = new Properties();
            try (InputStream is2 = url.getInputStream();){
                prop.load(is2);
            }
            catch (IOException is2) {
                // empty catch block
            }
            String version = prop.getProperty("version");
            String groupId = prop.getProperty("groupId");
            String artifactId = prop.getProperty("artifactId");
            if (version == null || version.trim().length() == 0) continue;
            all.add(new NPomId(groupId, artifactId, version));
        }
        return all.toArray(new NPomId[0]);
    }

    private NPomId[] resolvePomIdsFromMetaInfMavenAsRoot(URLPart aa) {
        URLPart p = aa.rootSibling("/META-INF/maven");
        return this.resolvePomIdsFromMetaInfMaven0(p);
    }

    public NPomId[] resolvePomIds(NPath baseUrl, String referenceResourcePath) {
        URLPart aa = URLPart.of(baseUrl.toURL().get());
        NPomId[] result = this.resolvePomIdsFromMetaInfMavenByRef(aa, referenceResourcePath);
        if (result.length > 0) {
            return result;
        }
        result = this.resolvePomIdsFromMetaInfMavenAsRoot(aa);
        if (result.length > 0) {
            return result;
        }
        result = this.resolvePomIdsFromTargetClasses(aa, referenceResourcePath);
        if (result.length > 0) {
            return result;
        }
        return result;
    }

    public NPomId[] resolvePomIds(Class clazz) {
        Class s;
        ArrayList<NPomId> all = new ArrayList<NPomId>();
        try {
            String n = clazz.getName().replace('.', '/').concat(".class");
            Enumeration<URL> r = clazz.getClassLoader().getResources(n);
            ArrayList<URL> list = Collections.list(r);
            for (URL url : list) {
                all.addAll(Arrays.asList(this.resolvePomIds(NPath.of(url), n)));
            }
        }
        catch (IOException ex) {
            NLog.of(NPomXmlParser.class).log(NMsg.ofC("failed to parse class %s : %s", clazz.getName(), ex).withIntent(NMsgIntent.ALERT).withLevel(Level.FINEST));
        }
        if (all.isEmpty() && JavaClassUtils.isCGLib(clazz) && (s = JavaClassUtils.unwrapCGLib(clazz)) != null) {
            return this.resolvePomIds(s);
        }
        return all.toArray(new NPomId[0]);
    }

    public NPomId resolvePomId(Class clazz) {
        return this.resolvePomId(clazz, new NPomId("dev", "dev", "dev"));
    }

    public NPomId resolvePomId(Class clazz, NPomId defaultValue) {
        NPomId[] nPomIdArray;
        int n;
        int n2;
        NPomId[] pomIds = this.resolvePomIds(clazz);
        if (pomIds.length > 1) {
            NLog.of(NPomXmlParser.class).log(NMsg.ofC("multiple ids found : %s for class %s and id %s", Arrays.asList(pomIds), clazz, defaultValue).withIntent(NMsgIntent.ALERT).withLevel(Level.FINEST));
        }
        if ((n2 = 0) < (n = (nPomIdArray = pomIds).length)) {
            NPomId v = nPomIdArray[n2];
            return v;
        }
        return defaultValue;
    }

    public NPomId resolvePomId(Class clazz, String groupId, String artifactId, String defaultValue) {
        String ver = this.resolvePomVersion(clazz, groupId, artifactId, defaultValue);
        return new NPomId(groupId, artifactId, ver);
    }

    public String resolvePomVersion(String groupId, String artifactId, String defaultValue) {
        URL url = Thread.currentThread().getContextClassLoader().getResource("META-INF/maven/" + groupId + "/" + artifactId + "/pom.properties");
        if (url != null) {
            Properties p = new Properties();
            try {
                p.load(DefaultNWebCli.prepareGlobalOpenStream(url));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String version = p.getProperty("version");
            if (version != null && version.trim().length() != 0) {
                return version;
            }
        }
        return defaultValue;
    }

    public String resolvePomVersion(Class clazz, String groupId, String artifactId, String defaultValue) {
        URL url = clazz.getClassLoader().getResource("META-INF/maven/" + groupId + "/" + artifactId + "/pom.properties");
        if (url != null) {
            Properties p = new Properties();
            try {
                p.load(DefaultNWebCli.prepareGlobalOpenStream(url));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String version = p.getProperty("version");
            if (version != null && version.trim().length() != 0) {
                return version;
            }
        }
        return defaultValue;
    }

    public NPomId resolvePropertiesPomId(InputStream stream) {
        Properties prop = new Properties();
        try {
            prop.load(stream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String version = prop.getProperty("version");
        String groupId = prop.getProperty("groupId");
        String artifactId = prop.getProperty("artifactId");
        if (version != null && version.trim().length() != 0) {
            return new NPomId(groupId, artifactId, version);
        }
        return null;
    }

    public NPomId[] resolveJarPomIds(InputStream jarStream) throws IOException {
        final ArrayList list = new ArrayList();
        this.visitZipStream(jarStream, new InputStreamVisitor(){

            @Override
            public boolean visit(String path, InputStream inputStream) {
                NPomId id;
                if (path.startsWith("META-INF/") && path.endsWith("/pom.properties") && (id = NPomIdResolver.this.resolvePropertiesPomId(inputStream)) != null) {
                    list.add(new NPomId(id.getGroupId(), id.getArtifactId(), id.getVersion()));
                }
                return true;
            }
        });
        return list.toArray(new NPomId[0]);
    }

    public NPomId resolveJarPomId(InputStream jarStream) throws IOException {
        NPomId[] v = this.resolveJarPomIds(jarStream);
        if (v.length == 0) {
            return null;
        }
        if (v.length >= 2) {
            throw new IllegalArgumentException("too many Ids");
        }
        return v[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean visitZipStream(InputStream zipFile, InputStreamVisitor visitor) throws IOException {
        try (ZipInputStream zis = null;){
            zis = new ZipInputStream(zipFile);
            ZipEntry ze = zis.getNextEntry();
            final ZipInputStream finalZis = zis;
            InputStream entryInputStream = new InputStream(){

                @Override
                public int read() throws IOException {
                    return finalZis.read();
                }

                @Override
                public int read(byte[] b) throws IOException {
                    return finalZis.read(b);
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    return finalZis.read(b, off, len);
                }

                @Override
                public void close() throws IOException {
                    finalZis.closeEntry();
                }
            };
            while (ze != null) {
                String fileName = ze.getName();
                if (!fileName.endsWith("/") && !visitor.visit(fileName, entryInputStream)) {
                    break;
                }
                ze = zis.getNextEntry();
            }
        }
        return false;
    }

    private static class MvnPomPropsURLFilter
    implements Predicate<URLPart> {
        @Override
        public boolean test(URLPart path) {
            String name = path.getName();
            return name.equals("pom.properties");
        }
    }

    private static interface InputStreamVisitor {
        public boolean visit(String var1, InputStream var2) throws IOException;
    }
}

