/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl.maven;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.thevpc.nuts.internal.NApiUtilsRPI;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.NMavenSettings;
import net.thevpc.nuts.spi.NRepositoryLocation;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NOptional;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NMavenSettingsLoader {
    private NLog log;
    private String settingsFilePath;

    public NMavenSettingsLoader(NLog log) {
        this.log = log;
    }

    public NLog getLog() {
        return this.log;
    }

    public NMavenSettingsLoader setLog(NLog log) {
        this.log = log;
        return this;
    }

    public String getSettingsFilePath() {
        return this.settingsFilePath;
    }

    public NMavenSettingsLoader setSettingsFilePath(String settingsFilePath) {
        this.settingsFilePath = settingsFilePath;
        return this;
    }

    private static Boolean elementBoolean(Node c, boolean def) {
        String t = NMavenSettingsLoader.elementText(c);
        if (t.isEmpty()) {
            return def;
        }
        return Boolean.parseBoolean(t);
    }

    private static String elementText(Node c) {
        String e;
        String string = e = c == null ? null : c.getTextContent();
        if (e == null) {
            e = "";
        }
        e = e.trim();
        return e;
    }

    private static List<Element> elementsByName(Node c, String name) {
        return NMavenSettingsLoader.elements(c, x -> NMavenSettingsLoader.nodeHasName(c, name));
    }

    private static List<Element> elements(Node c) {
        return NMavenSettingsLoader.elements(c, null);
    }

    private static List<Element> elements(Node c, Predicate<Element> cond) {
        return NMavenSettingsLoader.nodes(c, x -> x instanceof Element && (cond == null || cond.test((Element)x)));
    }

    private static List<Node> nodes(Node c, Predicate<Node> cond) {
        ArrayList<Node> li = new ArrayList<Node>();
        NodeList a = c.getChildNodes();
        for (int i = 0; i < a.getLength(); ++i) {
            Node e = a.item(i);
            if (cond != null && !cond.test(e)) continue;
            li.add(e);
        }
        return li;
    }

    private static boolean nodeHasName(Node e, String name) {
        return Objects.equals(e.getNodeName(), name);
    }

    public NMavenSettings loadSettingsRepos() {
        Path path;
        String settingsFilePath = this.settingsFilePath;
        ArrayList<NRepositoryLocation> list = new ArrayList<NRepositoryLocation>();
        NMavenSettings settings = new NMavenSettings();
        if (NBlankable.isBlank(settingsFilePath)) {
            settingsFilePath = System.getProperty("user.home") + NApiUtilsRPI.getNativePath("/.m2/settings.xml");
        }
        if (Files.isRegularFile(path = Paths.get(settingsFilePath, new String[0]), new LinkOption[0]) && Files.isReadable(path)) {
            try (InputStream xml = Files.newInputStream(path, new OpenOption[0]);){
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = null;
                doc = builder.parse(xml);
                Element c = doc.getDocumentElement();
                block17: for (Element e : NMavenSettingsLoader.elements(c)) {
                    switch (e.getNodeName()) {
                        case "localRepository": {
                            String url0 = NMavenSettingsLoader.elementText(e);
                            if (!NBlankable.isBlank(url0)) {
                                settings.setLocalRepository(url0.trim());
                            }
                        }
                        case "mirrors": {
                            for (Element mirror : NMavenSettingsLoader.elements(e, x -> x.getNodeName().equals("mirror"))) {
                                String id = NMavenSettingsLoader.elementText(NOptional.ofSingleton(NMavenSettingsLoader.elements(mirror, x -> x.getNodeName().equals("id"))).orNull());
                                String url0 = NMavenSettingsLoader.elementText(NOptional.ofSingleton(NMavenSettingsLoader.elements(mirror, x -> x.getNodeName().equals("url"))).orNull());
                                if (!NBlankable.isBlank(id) && NBlankable.isBlank(url0)) continue;
                            }
                            continue block17;
                        }
                        case "profiles": {
                            for (Element profile : NMavenSettingsLoader.elements(e, x -> x.getNodeName().equals("profile"))) {
                                boolean active = true;
                                for (Element activation : NMavenSettingsLoader.elements(profile, x -> x.getNodeName().equals("activation"))) {
                                    for (Element activeByDefault : NMavenSettingsLoader.elements(activation, x -> x.getNodeName().equals("activeByDefault"))) {
                                        active = NMavenSettingsLoader.elementBoolean(activeByDefault, active);
                                    }
                                }
                                if (!active) continue;
                                for (Element repositories : NMavenSettingsLoader.elements(profile, x -> x.getNodeName().equals("repositories"))) {
                                    for (Element repository : NMavenSettingsLoader.elements(repositories, x -> x.getNodeName().equals("repository"))) {
                                        String id = NMavenSettingsLoader.elementText(NOptional.ofSingleton(NMavenSettingsLoader.elements(repository, x -> x.getNodeName().equals("id"))).orNull());
                                        String url0 = NMavenSettingsLoader.elementText(NOptional.ofSingleton(NMavenSettingsLoader.elements(repository, x -> x.getNodeName().equals("url"))).orNull());
                                        boolean enabled0 = true;
                                        for (Element releases : NMavenSettingsLoader.elements(profile, x -> x.getNodeName().equals("releases"))) {
                                            for (Element enabled : NMavenSettingsLoader.elements(releases, x -> x.getNodeName().equals("enabled"))) {
                                                enabled0 = NMavenSettingsLoader.elementBoolean(enabled, enabled0);
                                            }
                                        }
                                        if (!enabled0 || NBlankable.isBlank(id) || NBlankable.isBlank(url0)) continue;
                                        list.add(new NRepositoryLocation(id.trim(), "maven", url0.trim()));
                                    }
                                }
                            }
                            break;
                        }
                    }
                }
            }
            catch (Exception ex) {
                this.log.log(NMsg.ofC("unable to load maven settings.xml %s", settingsFilePath).asFineFail(ex));
            }
        }
        if (NBlankable.isBlank(settings.getLocalRepository())) {
            settings.setLocalRepository(System.getProperty("user.home") + NApiUtilsRPI.getNativePath("/.m2/repository"));
        }
        if (NBlankable.isBlank(settings.getRemoteRepository())) {
            settings.setRemoteRepository("https://repo.maven.apache.org/maven2");
        }
        settings.setActiveRepositories(list);
        return settings;
    }
}

