/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl.maven;

import java.util.Arrays;
import java.util.List;
import net.thevpc.nuts.core.NAddRepositoryOptions;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NRepositoryConfig;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementParser;
import net.thevpc.nuts.elem.NObjectElement;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.runtime.standalone.repository.NRepositorySelectorHelper;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.MavenFolderRepository;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.MavenRemoteXmlRepository;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.MavenSettingsRepository;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.util.MavenUtils;
import net.thevpc.nuts.runtime.standalone.repository.util.NRepositoryUtils;
import net.thevpc.nuts.spi.NComponentScope;
import net.thevpc.nuts.spi.NRepositoryDB;
import net.thevpc.nuts.spi.NRepositoryFactoryComponent;
import net.thevpc.nuts.spi.NRepositoryLocation;
import net.thevpc.nuts.spi.NScopeType;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NStringUtils;

@NComponentScope(value=NScopeType.WORKSPACE)
public class MavenRepositoryFactoryComponent
implements NRepositoryFactoryComponent {
    @Override
    public List<NAddRepositoryOptions> getDefaultRepositories() {
        return Arrays.asList(NRepositorySelectorHelper.createRepositoryOptions(NRepositoryLocation.of("maven", NRepositoryDB.of()).get(), true));
    }

    @Override
    public NRepository create(NAddRepositoryOptions options, NRepository parentRepository) {
        String pr;
        if (MavenUtils.isMavenSettingsRepository(options)) {
            return new MavenSettingsRepository(options, parentRepository);
        }
        NRepositoryConfig config = options.getConfig();
        String type = NRepositoryUtils.getRepoType(config);
        if (NBlankable.isBlank(type)) {
            return null;
        }
        NPath p = NPath.of(config.getLocation().getPath());
        switch (pr = NStringUtils.trim(p.getProtocol())) {
            case "http": 
            case "https": {
                NPath nr = p.resolve(".nuts-repository");
                if (nr.exists()) {
                    NElement e = null;
                    String repositoryType = null;
                    String repositoryName = null;
                    String repositoryLayout = null;
                    try {
                        e = NElementParser.ofJson().parse(nr);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (e != null && e.isAnyObject()) {
                        NObjectElement o = e.asObject().get();
                        repositoryType = o.getStringValue("repositoryType").orNull();
                        repositoryName = o.getStringValue("repositoryName").orNull();
                        repositoryLayout = o.getStringValue("repositoryLayout").orNull();
                    }
                    if (!NBlankable.isBlank(repositoryLayout)) {
                        config.setLocation(config.getLocation().setPath(NStringUtils.trim(repositoryLayout) + "+" + config.getLocation().getPath()));
                    }
                    return new MavenFolderRepository(options, parentRepository);
                }
                return new MavenRemoteXmlRepository(options, parentRepository);
            }
        }
        return new MavenFolderRepository(options, parentRepository);
    }

    @Override
    public int getScore(NScorableContext criteria) {
        if (criteria == null) {
            return -1;
        }
        NRepositoryConfig r = criteria.getCriteria(NRepositoryConfig.class);
        if (r != null) {
            String type = NRepositoryUtils.getRepoType(r);
            if (NBlankable.isBlank(type)) {
                return -1;
            }
            if ("maven".equals(type)) {
                return 20;
            }
            if (NBlankable.isBlank(type)) {
                return 15;
            }
        }
        return -1;
    }
}

