/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl.maven;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Map;
import net.thevpc.nuts.artifact.NArtifactNotFoundException;
import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.command.NFetchMode;
import net.thevpc.nuts.command.NFetchModeNotSupportedException;
import net.thevpc.nuts.core.NAddRepositoryOptions;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NIOUtils;
import net.thevpc.nuts.io.NInputSource;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.repository.impl.folder.NFolderRepositoryBase;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.MavenRepoIter;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.util.MavenUtils;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.util.MvnClient;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceUtils;
import net.thevpc.nuts.spi.NRepositorySPI;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NIterator;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NStringUtils;
import net.thevpc.nuts.util.NUnsupportedArgumentException;

public class MavenFolderRepository
extends NFolderRepositoryBase {
    private MvnClient wrapper;
    private boolean disableMe;

    public MavenFolderRepository(NAddRepositoryOptions options, NRepository parentRepository) {
        super(options, parentRepository, null, false, "maven", false);
        NLiteral enableM2;
        this.repoIter = new MavenRepoIter(this);
        if ("maven-local".equals(options.getName()) && (enableM2 = this.getWorkspace().getCustomBootOption("---m2").orNull()) != null) {
            this.disableMe = !enableM2.isNull() && enableM2.asBoolean().orElse(true) == false;
        }
    }

    @Override
    protected NLog _LOG() {
        return NLog.of(MavenFolderRepository.class);
    }

    @Override
    public NIterator<NId> searchCore(NDefinitionFilter filter, NPath[] basePaths, NId[] baseIds, NFetchMode fetchMode) {
        if (this.disableMe) {
            return NIterator.ofEmpty();
        }
        if (!this.acceptedFetchNoCache(fetchMode)) {
            return null;
        }
        return super.searchCore(filter, basePaths, baseIds, fetchMode);
    }

    @Override
    public NPath fetchContentCoreUsingRepoHelper(NId id, NDescriptor descriptor, NFetchMode fetchMode) {
        NPath cc = this.fetchContentCoreUsingWrapper(id, descriptor, fetchMode);
        if (cc != null) {
            return cc;
        }
        return super.fetchContentCoreUsingRepoHelper(id, descriptor, fetchMode);
    }

    @Override
    public NIterator<NId> findNonSingleVersionImpl(NId id, NDefinitionFilter idFilter, NFetchMode fetchMode) {
        if (this.disableMe) {
            return NIterator.ofEmpty();
        }
        return super.findNonSingleVersionImpl(id, idFilter, fetchMode);
    }

    private NRepository getLocalMavenRepo() {
        for (NRepository nRepository : this.workspace.getRepositories()) {
            if (!nRepository.getRepositoryType().equals("maven") || nRepository.config().getLocationPath() == null || !nRepository.config().getLocationPath().toString().equals(Paths.get(NPath.of("~/.m2").toAbsolute(NWorkspace.of().getWorkspaceLocation()).toString(), new String[0]).toString())) continue;
            return nRepository;
        }
        return null;
    }

    protected NPath getMavenLocalFolderContent(NId id) {
        NPath p = this.getIdRelativePath(id);
        if (p != null) {
            return NPath.ofUserHome().resolve(".m2").resolve(p);
        }
        return null;
    }

    private MvnClient getWrapper() {
        return null;
    }

    public NPath fetchContentCoreUsingWrapper(NId id, NDescriptor descriptor, NFetchMode fetchMode) {
        if (this.disableMe) {
            return null;
        }
        if (this.wrapper == null) {
            this.wrapper = this.getWrapper();
        }
        if (this.wrapper != null && this.wrapper.get(id, this.config().getLocationPath().toString())) {
            NRepository repo = this.getLocalMavenRepo();
            if (repo != null) {
                NRepositorySPI repoSPI = NWorkspaceUtils.of(this.workspace).toRepositorySPI(repo);
                return repoSPI.fetchContent().setId(id).setDescriptor(descriptor).setFetchMode(NFetchMode.LOCAL).run().getResult();
            }
            NPath content = this.getMavenLocalFolderContent(id);
            if (content != null && content.exists()) {
                return content.setUserCache(true).setUserTemporary(false);
            }
        }
        return null;
    }

    @Override
    public String getIdExtension(NId id) {
        String f;
        Map<String, String> q = id.getProperties();
        switch (f = NStringUtils.trim(q.get("face"))) {
            case "descriptor": {
                return ".pom";
            }
            case "descriptor-hash": {
                return ".pom.sha1";
            }
            case "catalog": {
                return ".catalog";
            }
            case "content-hash": {
                return this.getIdExtension(id.builder().setFaceContent().build()) + ".sha1";
            }
            case "content": {
                String packaging = q.get("packaging");
                return NWorkspace.of().getDefaultIdContentExtension(packaging);
            }
        }
        throw new NUnsupportedArgumentException(NMsg.ofC("unsupported fact %s", f));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NDescriptor fetchDescriptorCore(NId id, NFetchMode fetchMode) {
        if (this.disableMe) {
            throw new NArtifactNotFoundException(id, (Throwable)new NFetchModeNotSupportedException(this, fetchMode, id.toString(), null));
        }
        if (!this.acceptedFetchNoCache(fetchMode)) {
            throw new NArtifactNotFoundException(id, (Throwable)new NFetchModeNotSupportedException(this, fetchMode, id.toString(), null));
        }
        InputStream stream = null;
        try {
            NDescriptor nutsDescriptor = null;
            byte[] bytes = null;
            String name = null;
            NId idDesc = id.builder().setFaceDescriptor().build();
            try {
                stream = this.getStream(idDesc, "artifact descriptor", "retrieve");
                name = NInputSource.of(stream).getMetaData().getName().orElse("no-name");
                bytes = NIOUtils.loadByteArray(stream, true);
                nutsDescriptor = MavenUtils.of().parsePomXmlAndResolveParents(CoreIOUtils.createBytesStream(bytes, name == null ? null : NMsg.ofNtf(name), "text/xml", StandardCharsets.UTF_8.name(), "pom.xml"), fetchMode, this.getIdRemotePath(id).toString(), this);
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
            this.checkSHA1Hash(id.builder().setFace("descriptor-hash").build(), CoreIOUtils.createBytesStream(bytes, name == null ? null : NMsg.ofNtf(name), "text/xml", StandardCharsets.UTF_8.name(), "pom.xml"), "artifact descriptor");
            return nutsDescriptor;
        }
        catch (IOException | UncheckedIOException | NIOException ex) {
            throw new NArtifactNotFoundException(id, (Throwable)ex);
        }
    }
}

