/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl.main;

import java.io.UncheckedIOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.artifact.NDefinitionFilters;
import net.thevpc.nuts.artifact.NDependencyScope;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NIdBuilder;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.artifact.NVersionFilter;
import net.thevpc.nuts.command.NFetchMode;
import net.thevpc.nuts.command.NInstallException;
import net.thevpc.nuts.command.NInstallInformation;
import net.thevpc.nuts.command.NInstallStatus;
import net.thevpc.nuts.command.NNotInstallableException;
import net.thevpc.nuts.command.NNotInstalledException;
import net.thevpc.nuts.core.NBootOptions;
import net.thevpc.nuts.core.NConfirmationMode;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NRepositorySecurityManager;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementDescribables;
import net.thevpc.nuts.elem.NElementParser;
import net.thevpc.nuts.elem.NElementWriter;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPathOption;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.platform.NStoreType;
import net.thevpc.nuts.runtime.standalone.definition.DefaultNInstallInfo;
import net.thevpc.nuts.runtime.standalone.definition.NDefinitionFilterUtils;
import net.thevpc.nuts.runtime.standalone.definition.NDefinitionHelper;
import net.thevpc.nuts.runtime.standalone.repository.cmd.deploy.AbstractNDeployRepositoryCmd;
import net.thevpc.nuts.runtime.standalone.repository.cmd.fetch.AbstractNFetchContentRepositoryCmd;
import net.thevpc.nuts.runtime.standalone.repository.cmd.fetch.AbstractNFetchDescriptorRepositoryCmd;
import net.thevpc.nuts.runtime.standalone.repository.cmd.push.AbstractNPushRepositoryCmd;
import net.thevpc.nuts.runtime.standalone.repository.cmd.search.AbstractNSearchRepositoryCmd;
import net.thevpc.nuts.runtime.standalone.repository.cmd.search.AbstractNSearchVersionsRepositoryCmd;
import net.thevpc.nuts.runtime.standalone.repository.cmd.undeploy.AbstractNRepositoryUndeployCmd;
import net.thevpc.nuts.runtime.standalone.repository.cmd.updatestats.AbstractNUpdateRepositoryStatsCmd;
import net.thevpc.nuts.runtime.standalone.repository.impl.AbstractNRepository;
import net.thevpc.nuts.runtime.standalone.repository.impl.NRepositoryExt0;
import net.thevpc.nuts.runtime.standalone.repository.impl.NRepositoryFolderHelper;
import net.thevpc.nuts.runtime.standalone.repository.impl.main.InstallDepConfig;
import net.thevpc.nuts.runtime.standalone.repository.impl.main.InstallInfoConfig;
import net.thevpc.nuts.runtime.standalone.repository.impl.main.InstallLogItemTable;
import net.thevpc.nuts.runtime.standalone.repository.impl.main.InstalledRepositoryConfigModel;
import net.thevpc.nuts.runtime.standalone.repository.impl.main.NInstallLogAction;
import net.thevpc.nuts.runtime.standalone.repository.impl.main.NInstallLogRecord;
import net.thevpc.nuts.runtime.standalone.repository.impl.main.NInstalledRepository;
import net.thevpc.nuts.runtime.standalone.store.NWorkspaceStore;
import net.thevpc.nuts.runtime.standalone.workspace.DefaultNWorkspace;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.xtra.expr.StringTokenizerUtils;
import net.thevpc.nuts.security.NWorkspaceSecurityManager;
import net.thevpc.nuts.spi.NDeployRepositoryCmd;
import net.thevpc.nuts.spi.NFetchContentRepositoryCmd;
import net.thevpc.nuts.spi.NFetchDescriptorRepositoryCmd;
import net.thevpc.nuts.spi.NPushRepositoryCmd;
import net.thevpc.nuts.spi.NRepositoryUndeployCmd;
import net.thevpc.nuts.spi.NSearchRepositoryCmd;
import net.thevpc.nuts.spi.NSearchVersionsRepositoryCmd;
import net.thevpc.nuts.spi.NUpdateRepositoryStatsCmd;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NCollections;
import net.thevpc.nuts.util.NFunction;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NIterator;
import net.thevpc.nuts.util.NIteratorBuilder;
import net.thevpc.nuts.util.NLRUMap;
import net.thevpc.nuts.util.NStream;
import net.thevpc.nuts.util.NStringUtils;

public class DefaultNInstalledRepository
extends AbstractNRepository
implements NInstalledRepository,
NRepositoryExt0 {
    public static final String INSTALLED_REPO_UUID = "<main>";
    public static final String NUTS_INSTALL_FILE = "nuts-install.json";
    private final NRepositoryFolderHelper deployments;
    private final Map<NId, String> cachedDefaultVersions = new NLRUMap<NId, String>(200);

    public DefaultNInstalledRepository(NBootOptions bOptions) {
        this.deployments = new NRepositoryFolderHelper(this, NPath.of(bOptions.getStoreType(NStoreType.LIB).get()).resolve("id"), false, "lib", NElement.ofObjectBuilder().set("repoKind", "lib").build());
        this.configModel = new InstalledRepositoryConfigModel(this.workspace, this);
    }

    protected NLog _LOG() {
        return NLog.of(DefaultNInstalledRepository.class);
    }

    @Override
    public boolean isDefaultVersion(NId id) {
        String v = this.getDefaultVersion(id);
        return v.equals(id.getVersion().toString());
    }

    @Override
    public String getBootConnectionString() {
        return null;
    }

    @Override
    public boolean isTemporary() {
        return false;
    }

    @Override
    public NIterator<NInstallInformation> searchInstallInformation() {
        return NStream.ofIterator(this._wstore().searchInstalledVersions()).map(x -> {
            try {
                if (x != null) {
                    return this.getInstallInformation((InstallInfoConfig)x);
                }
            }
            catch (Exception ex) {
                this._LOG().log(NMsg.ofJ("unable to parse {0}", x).asError(ex));
            }
            return null;
        }).filter(Objects::nonNull).iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDefaultVersion(NId id) {
        NId baseVersion = id.getShortId();
        Map<NId, String> map = this.cachedDefaultVersions;
        synchronized (map) {
            String p = this.cachedDefaultVersions.get(baseVersion);
            if (p != null) {
                return p;
            }
        }
        String defaultVersion = NStringUtils.trim(this._wstore().loadInstalledDefaultVersion(id));
        Map<NId, String> map2 = this.cachedDefaultVersions;
        synchronized (map2) {
            this.cachedDefaultVersions.put(baseVersion, defaultVersion);
        }
        return defaultVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultVersion(NId id) {
        NId baseVersion = id.getShortId();
        this._wstore().saveInstalledDefaultVersion(id);
        String version = id.getVersion().getValue();
        Map<NId, String> map = this.cachedDefaultVersions;
        synchronized (map) {
            this.cachedDefaultVersions.put(baseVersion, version);
        }
    }

    @Override
    public NInstallInformation getInstallInformation(NId id) {
        InstallInfoConfig c = this._wstore().loadInstallInfoConfig(id);
        return c != null ? this.getInstallInformation(c) : DefaultNInstallInfo.notInstalled(id);
    }

    @Override
    public NInstallStatus getInstallStatus(NId id) {
        NInstallInformation ii = this.getInstallInformation(id);
        if (ii == null) {
            return NInstallStatus.NONE;
        }
        return ii.getInstallStatus();
    }

    @Override
    public void install(NId id, NId forId) {
        boolean succeeded = false;
        NWorkspaceUtils.of(this.workspace).checkReadOnly();
        InstallInfoConfig ii = this._wstore().loadInstallInfoConfig(id);
        try {
            DefaultNInstalledRepository.invalidateInstallationDigest();
            String repository = id.getRepository();
            NRepository r = this.workspace.findRepository(repository).orNull();
            if (ii == null) {
                ii = new InstallInfoConfig();
                ii.setId(id);
                ii.setInstalled(forId == null);
                if (r != null) {
                    ii.setSourceRepoName(r.getName());
                    ii.setSourceRepoUUID(r.getUuid());
                }
                this.saveCreate(ii);
            } else {
                InstallInfoConfig ii0 = ii.copy();
                ii.setId(id);
                ii.setInstalled(forId == null);
                if (r != null) {
                    ii.setSourceRepoName(r.getName());
                    ii.setSourceRepoUUID(r.getUuid());
                }
                this.saveUpdate(ii, ii0);
            }
            succeeded = true;
        }
        catch (UncheckedIOException | NIOException ex) {
            throw new NNotInstallableException(id, NMsg.ofC("failed to install %s : %s", id, ex), ex);
        }
        finally {
            this.addLog(NInstallLogAction.INSTALL, id, forId, null, succeeded);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NInstallInformation install(NDefinition def) {
        boolean succeeded = false;
        try {
            NInstallInformation a = this.updateInstallInformation(def.getId(), def, null, true, null);
            succeeded = true;
            NInstallInformation nInstallInformation = a;
            return nInstallInformation;
        }
        finally {
            this.addLog(NInstallLogAction.INSTALL, def.getId(), null, null, succeeded);
        }
    }

    @Override
    public void uninstall(NDefinition def) {
        boolean succeeded = false;
        NWorkspaceUtils.of(this.workspace).checkReadOnly();
        NId id = def.getId();
        NInstallStatus installStatus = this.getInstallStatus(id);
        if (!installStatus.isInstalled()) {
            throw new NNotInstalledException(id);
        }
        try {
            String pck = def.getDescriptor().getPackaging();
            this.undeploy().setId(id.builder().setPackaging(NBlankable.isBlank(pck) ? "jar" : pck).build()).run();
            this._wstore().deleteInstallInfoConfig(id);
            String v = this.getDefaultVersion(id);
            if (v != null && v.equals(id.getVersion().getValue())) {
                NIterator<NId> versions = this.searchVersions().setId(id).setFilter(NDefinitionFilters.of().byInstalled(true)).setFetchMode(NFetchMode.LOCAL).getResult();
                List nutsIds = NCollections.list(versions == null ? Collections.emptyIterator() : versions);
                nutsIds.sort(null);
                if (!nutsIds.isEmpty()) {
                    this.setDefaultVersion((NId)nutsIds.get(0));
                } else {
                    this.setDefaultVersion(id.builder().setVersion("").build());
                }
            }
            succeeded = true;
        }
        catch (Exception ex) {
            throw new NNotInstalledException(id);
        }
        finally {
            this.addLog(NInstallLogAction.UNINSTALL, id, null, null, succeeded);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NInstallInformation require(NDefinition def, NId[] forIds, NDependencyScope scope) {
        boolean succeeded = false;
        NId requiredId = def.getId();
        NInstallInformation nInstallInformation = this.updateInstallInformation(def.getId(), def, null, null, true);
        if (forIds != null) {
            for (NId requestorId : forIds) {
                if (requestorId == null) continue;
                succeeded = false;
                try {
                    InstallInfoConfig ti0;
                    if (scope == null) {
                        scope = NDependencyScope.API;
                    }
                    requiredId = requiredId.builder().setRepository(null).build();
                    InstallInfoConfig fi = this._wstore().loadInstallInfoConfig(requiredId);
                    if (fi == null) {
                        throw new NInstallException(requiredId);
                    }
                    InstallInfoConfig fi0 = fi.copy();
                    InstallInfoConfig ti = this._wstore().loadInstallInfoConfig(requestorId);
                    InstallInfoConfig installInfoConfig = ti0 = ti == null ? null : ti.copy();
                    if (!fi.isRequired()) {
                        fi.setRequired(true);
                        fi.setRequiredBy(this.addDistinct(fi.getRequiredBy(), new InstallDepConfig(requestorId, scope)));
                        this.saveUpdate(fi, fi0);
                    }
                    this.saveUpdate(fi, fi0);
                    if (ti == null) {
                        ti = new InstallInfoConfig();
                        ti.setId(requestorId);
                        ti.setRequires(this.addDistinct(ti.getRequires(), new InstallDepConfig(requiredId, scope)));
                        this.saveCreate(ti);
                    } else {
                        ti.setRequires(this.addDistinct(ti.getRequires(), new InstallDepConfig(requiredId, scope)));
                        this.saveUpdate(ti, ti0);
                    }
                    succeeded = true;
                }
                finally {
                    this.addLog(NInstallLogAction.REQUIRE, requiredId, requestorId, null, succeeded);
                }
            }
        }
        return nInstallInformation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unrequire(NId requiredId, NId requestorId, NDependencyScope scope) {
        Instant now = Instant.now();
        String user = NWorkspaceSecurityManager.of().getCurrentUsername();
        boolean succeeded = false;
        try {
            InstallInfoConfig fi;
            if (scope == null) {
                scope = NDependencyScope.API;
            }
            if ((fi = this._wstore().loadInstallInfoConfig(requiredId)) == null) {
                throw new NInstallException(requiredId);
            }
            InstallInfoConfig ti = this._wstore().loadInstallInfoConfig(requestorId);
            if (ti == null) {
                throw new NInstallException(requestorId);
            }
            InstallInfoConfig fi0 = fi.copy();
            InstallInfoConfig ti0 = ti.copy();
            fi.setRequiredBy(this.removeDistinct(fi.getRequiredBy(), new InstallDepConfig(requestorId, scope)));
            ti.setRequires(this.removeDistinct(ti.getRequires(), new InstallDepConfig(requiredId, scope)));
            if (fi.isRequired() != fi.getRequiredBy().size() > 0) {
                fi.setRequired(fi.getRequiredBy().size() > 0);
            }
            this.saveUpdate(fi, fi0);
            this.saveUpdate(ti, ti0);
            succeeded = true;
        }
        finally {
            this.addLog(NInstallLogAction.UNREQUIRE, requiredId, requestorId, null, succeeded);
        }
    }

    @Override
    public NStream<NInstallLogRecord> findLog() {
        return InstallLogItemTable.of(this.workspace).stream();
    }

    public NId pathToId(NPath path) {
        NPath rootFolder = NPath.ofWorkspaceStore(NStoreType.CONF).resolve("id");
        String p = path.toString().substring(rootFolder.toString().length());
        List<String> split = StringTokenizerUtils.split(p, "/\\");
        if (split.size() >= 4) {
            return NIdBuilder.of().setGroupId(String.join((CharSequence)".", split.subList(0, split.size() - 3))).setArtifactId(split.get(split.size() - 3)).setVersion(split.get(split.size() - 2)).build();
        }
        return null;
    }

    private <A> List<A> addDistinct(List<A> old, A v) {
        LinkedHashSet<A> s = new LinkedHashSet<A>();
        if (old != null) {
            s.addAll(old);
        }
        if (v != null) {
            s.add(v);
        }
        return new ArrayList(s);
    }

    private <A> List<A> removeDistinct(List<A> old, A v) {
        LinkedHashSet<A> s = new LinkedHashSet<A>();
        if (old != null) {
            s.addAll(old);
        }
        if (v != null) {
            s.remove(v);
        }
        return new ArrayList(s);
    }

    public NIterator<InstallInfoConfig> searchInstallConfig() {
        return NIterator.of(this._wstore().searchInstalledVersions());
    }

    private NWorkspaceStore _wstore() {
        return ((NWorkspaceExt)((Object)this.workspace)).store();
    }

    public NInstallInformation getInstallInformation(InstallInfoConfig ii) {
        Instant expireTime;
        NSession session = this.workspace.currentSession();
        boolean obsolete = false;
        boolean defaultVersion = false;
        if (ii.isInstalled()) {
            defaultVersion = this.isDefaultVersion(ii.getId());
        }
        if ((expireTime = session.getExpireTime().orNull()) != null && (ii.isInstalled() || ii.isRequired() || ii.isDeployed())) {
            Instant lastModifiedDate = ii.getLastModificationDate();
            if (lastModifiedDate == null) {
                lastModifiedDate = ii.getCreationDate();
            }
            if (lastModifiedDate == null || lastModifiedDate.isBefore(expireTime)) {
                obsolete = true;
            }
        }
        NInstallStatus s = NInstallStatus.of(ii.isDeployed(), ii.isInstalled(), ii.isRequired(), obsolete, defaultVersion);
        return new DefaultNInstallInfo(ii.getId(), s, NPath.ofIdStore(ii.getId(), NStoreType.BIN), ii.getCreationDate(), ii.getLastModificationDate(), ii.getCreationUser(), ii.getSourceRepoName(), ii.getSourceRepoUUID(), false, false);
    }

    @Override
    public NInstallInformation deploy(NDefinition def) {
        this.deploy().setId(def.getId()).setContent(def.getContent().orNull()).setDescriptor(def.getDescriptor()).run();
        return this.getInstallInformation(def.getId());
    }

    private NInstallInformation updateInstallInformation(NId id1, NDefinition def, Boolean deployed, Boolean install, Boolean require) {
        DefaultNInstalledRepository.invalidateInstallationDigest();
        InstallInfoConfig ii = this._wstore().loadInstallInfoConfig(id1);
        boolean wasInstalled = false;
        boolean wasRequired = false;
        boolean wasDeployed = false;
        if (ii == null) {
            NId id = id1;
            NWorkspaceUtils.of(this.workspace).checkReadOnly();
            try {
                boolean _require;
                boolean _install;
                boolean _deploy;
                if (install == null && require == null && deployed == null) {
                    _deploy = false;
                    _install = false;
                    _require = false;
                } else if (install != null) {
                    _deploy = deployed == null || deployed != false;
                    _install = install;
                    _require = require != null && require != false;
                } else if (require != null) {
                    _deploy = deployed == null || require != false;
                    _install = install != null && install != false;
                    _require = require;
                } else if (deployed != null) {
                    _deploy = deployed;
                    _install = install != null && install != false;
                    _require = require != null && require != false;
                } else {
                    _deploy = deployed != null && deployed != false;
                    _install = install != null && install != false;
                    _require = require != null && require != false;
                }
                ii = new InstallInfoConfig();
                ii.setConfigVersion(DefaultNWorkspace.VERSION_INSTALL_INFO_CONFIG);
                ii.setId(id);
                ii.setDeployed(_deploy);
                ii.setInstalled(_install);
                ii.setRequired(_require);
                this.saveCreate(ii);
            }
            catch (UncheckedIOException | NIOException ex) {
                throw new NNotInstallableException(id, NMsg.ofC("failed to install %s : %s", id, ex), ex);
            }
            DefaultNInstallInfo uu = (DefaultNInstallInfo)this.getInstallInformation(ii);
            uu.setWasInstalled(false);
            uu.setWasRequired(false);
            uu.setJustInstalled(install != null && install != false);
            uu.setJustRequired(require != null && require != false);
            return uu;
        }
        InstallInfoConfig ii0 = ii.copy();
        wasDeployed = ii.isDeployed();
        wasInstalled = ii.isInstalled();
        wasRequired = ii.isRequired();
        boolean _deploy = wasDeployed;
        boolean _install = wasInstalled;
        boolean _require = wasRequired;
        if (deployed != null) {
            _deploy = deployed;
        }
        if (install != null) {
            _install = install;
        }
        if (require != null) {
            _require = require;
        }
        ii.setDeployed(_deploy);
        ii.setInstalled(_install);
        ii.setRequired(_require);
        this.saveUpdate(ii, ii0);
        DefaultNInstallInfo uu = (DefaultNInstallInfo)this.getInstallInformation(ii);
        uu.setWasInstalled(wasInstalled);
        uu.setWasRequired(wasRequired);
        uu.setJustInstalled(install != null && install != false);
        uu.setJustRequired(require != null && require != false);
        return uu;
    }

    private void saveCreate(InstallInfoConfig ii) {
        Instant now = Instant.now();
        String user = NWorkspaceSecurityManager.of().getCurrentUsername();
        if (ii.getCreationUser() == null) {
            ii.setCreationUser(user);
        }
        if (ii.getCreationDate() == null) {
            ii.setCreationDate(now);
        }
        ii.setConfigVersion(DefaultNWorkspace.VERSION_INSTALL_INFO_CONFIG);
        this._wstore().saveInstallInfoConfig(ii);
    }

    private void saveUpdate(InstallInfoConfig ii, InstallInfoConfig ii0) {
        Instant now = Instant.now();
        String user = NWorkspaceSecurityManager.of().getCurrentUsername();
        if (ii.getCreationUser() == null) {
            ii.setCreationUser(user);
        }
        if (ii.getCreationDate() == null) {
            ii.setCreationDate(now);
        }
        if (!ii.equals(ii0)) {
            ii.setLastModificationDate(now);
            ii.setLastModificationUser(user);
            ii.setConfigVersion(DefaultNWorkspace.VERSION_INSTALL_INFO_CONFIG);
            this._wstore().saveInstallInfoConfig(ii);
        }
    }

    public void addString(NId id, String name, String value) {
        this.getPath(id, name).writeString(value, new NPathOption[0]);
    }

    public <T> T readJson(NId id, String name, Class<T> clazz) {
        return NElementParser.ofJson().parse(this.getPath(id, name), clazz);
    }

    public void printJson(NId id, String name, InstallInfoConfig value) {
        value.setConfigVersion(this.workspace.getApiVersion());
        NElementWriter.ofJson().write((Object)value, this.getPath(id, name));
    }

    public void remove(NId id, String name) {
        NPath path = this.getPath(id, name);
        path.delete();
    }

    public boolean contains(NId id, String name) {
        return this.getPath(id, name).isRegularFile();
    }

    public NPath getPath(NId id, String name) {
        return NPath.ofIdStore(id, NStoreType.CONF).resolve(name);
    }

    @Override
    public NRepositorySecurityManager security() {
        throw new IllegalArgumentException("unsupported security() for " + this.getName() + " repository");
    }

    @Override
    public NDeployRepositoryCmd deploy() {
        return new AbstractNDeployRepositoryCmd(this){

            @Override
            public NDeployRepositoryCmd run() {
                DefaultNInstalledRepository.invalidateInstallationDigest();
                boolean succeeded = false;
                try {
                    NDescriptor rep = DefaultNInstalledRepository.this.deployments.deploy(this, NConfirmationMode.YES);
                    this.setDescriptor(rep);
                    this.setId(rep.getId());
                    DefaultNInstalledRepository.this.updateInstallInformation(this.getId(), null, true, null, null);
                    succeeded = true;
                }
                finally {
                    DefaultNInstalledRepository.this.addLog(NInstallLogAction.DEPLOY, this.getId(), null, null, succeeded);
                }
                return this;
            }
        };
    }

    @Override
    public NRepositoryUndeployCmd undeploy() {
        return new AbstractNRepositoryUndeployCmd(this){

            @Override
            public NRepositoryUndeployCmd run() {
                DefaultNInstalledRepository.invalidateInstallationDigest();
                boolean succeeded = false;
                try {
                    DefaultNInstalledRepository.this.deployments.undeploy(this);
                    DefaultNInstalledRepository.this.updateInstallInformation(this.getId(), null, false, null, null);
                    succeeded = true;
                }
                finally {
                    DefaultNInstalledRepository.this.addLog(NInstallLogAction.UNDEPLOY, this.getId(), null, null, succeeded);
                }
                return this;
            }
        };
    }

    private static void invalidateInstallationDigest() {
        String uuid = UUID.randomUUID().toString();
        NWorkspaceExt.of().setInstallationDigest(uuid);
    }

    @Override
    public NPushRepositoryCmd push() {
        return new AbstractNPushRepositoryCmd(this){

            @Override
            public NPushRepositoryCmd run() {
                throw new NIllegalArgumentException(NMsg.ofC("unsupported push() for %s repository", DefaultNInstalledRepository.this.getName()));
            }
        };
    }

    @Override
    public NFetchDescriptorRepositoryCmd fetchDescriptor() {
        return new AbstractNFetchDescriptorRepositoryCmd(this){

            @Override
            public NFetchDescriptorRepositoryCmd run() {
                this.result = DefaultNInstalledRepository.this.deployments.fetchDescriptorImpl(this.getId());
                return this;
            }
        };
    }

    @Override
    public NFetchContentRepositoryCmd fetchContent() {
        return new AbstractNFetchContentRepositoryCmd(this){

            @Override
            public NFetchContentRepositoryCmd run() {
                this.result = DefaultNInstalledRepository.this.deployments.fetchContentImpl(this.getId());
                return this;
            }
        };
    }

    @Override
    public NSearchRepositoryCmd search() {
        return new AbstractNSearchRepositoryCmd(this){

            @Override
            public NSearchRepositoryCmd run() {
                NIterator<InstallInfoConfig> installIter = DefaultNInstalledRepository.this.searchInstallConfig();
                NIterator<Object> idIter = NIteratorBuilder.of(installIter).map(NFunction.of(InstallInfoConfig::getId).redescribe((Supplier)NElementDescribables.ofDesc("NutsInstallInformation->Id"))).build();
                NDefinitionFilter ff = this.getFilter();
                if (ff != null) {
                    idIter = NIteratorBuilder.of(idIter).filter(NDefinitionFilterUtils.toIdPredicate(ff)).build();
                }
                this.result = idIter;
                if (this.result == null) {
                    this.result = NIteratorBuilder.emptyIterator();
                }
                return this;
            }
        };
    }

    @Override
    public NSearchVersionsRepositoryCmd searchVersions() {
        return new AbstractNSearchVersionsRepositoryCmd(this){

            @Override
            public NSearchVersionsRepositoryCmd run() {
                NVersionFilter filter0 = this.getId().getVersion().filter();
                this.result = ((NStream)NStream.ofIterator(DefaultNInstalledRepository.this._wstore().searchInstalledVersions(this.getId())).map(vv -> {
                    NId newId = this.getId().builder().setVersion((NVersion)vv).build();
                    if (filter0.acceptVersion((NVersion)vv) && (this.filter == null || this.filter.acceptDefinition(NDefinitionHelper.ofIdOnlyFromRepo(newId, this.repo, "DefaultNInstalledRepository")))) {
                        return newId;
                    }
                    return null;
                }).nonNull().redescribe(NElementDescribables.ofDesc("FileToVersion"))).iterator();
                return this;
            }
        };
    }

    @Override
    public NUpdateRepositoryStatsCmd updateStatistics() {
        return new AbstractNUpdateRepositoryStatsCmd(this){

            @Override
            public NUpdateRepositoryStatsCmd run() {
                DefaultNInstalledRepository.invalidateInstallationDigest();
                DefaultNInstalledRepository.this.deployments.reindexFolder();
                return this;
            }
        };
    }

    @Override
    public boolean isAcceptFetchMode(NFetchMode mode) {
        return mode == NFetchMode.LOCAL;
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    public void addLog(NInstallLogAction action, NId id, NId requestor, String message, boolean succeeded) {
        InstallLogItemTable.of(this.workspace).add(new NInstallLogRecord(Instant.now(), NWorkspaceSecurityManager.of().getCurrentUsername(), action, id, requestor, message, succeeded));
    }
}

