/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl.folder;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import net.thevpc.nuts.artifact.NArtifactNotFoundException;
import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.artifact.NDefinitionFilters;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NIdBuilder;
import net.thevpc.nuts.command.NFetchMode;
import net.thevpc.nuts.command.NFetchModeNotSupportedException;
import net.thevpc.nuts.core.NAddRepositoryOptions;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NSpeedQualifier;
import net.thevpc.nuts.core.NStoreStrategy;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementDescribables;
import net.thevpc.nuts.io.NCp;
import net.thevpc.nuts.io.NCpValidator;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NInputStreamMonitor;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPathOption;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.runtime.standalone.definition.NDefinitionHelper;
import net.thevpc.nuts.runtime.standalone.repository.NIdPathIterator;
import net.thevpc.nuts.runtime.standalone.repository.NIdPathIteratorBase;
import net.thevpc.nuts.runtime.standalone.repository.impl.NCachedRepository;
import net.thevpc.nuts.runtime.standalone.repository.util.NIdLocationUtils;
import net.thevpc.nuts.runtime.standalone.util.NCoreLogUtils;
import net.thevpc.nuts.runtime.standalone.xtra.digest.NDigestUtils;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NTreeVisitResult;
import net.thevpc.nuts.text.NTreeVisitor;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NIterator;
import net.thevpc.nuts.util.NIteratorBuilder;
import net.thevpc.nuts.util.NIteratorUtils;
import net.thevpc.nuts.util.NNameFormat;
import net.thevpc.nuts.util.NStream;
import net.thevpc.nuts.util.NStringUtils;

public abstract class NFolderRepositoryBase
extends NCachedRepository {
    protected NIdPathIteratorBase repoIter;

    public NFolderRepositoryBase(NAddRepositoryOptions options, NRepository parent, NSpeedQualifier speed, boolean supportedMirroring, String repositoryType, boolean supportsDeploy) {
        super(options, parent, speed == null ? (NPath.of(options.getConfig().getLocation().getPath()).isRemote() ? NSpeedQualifier.SLOW : NSpeedQualifier.FASTER) : speed, supportedMirroring, repositoryType, supportsDeploy);
        if (!this.isRemote() && options.getConfig().getStoreStrategy() != NStoreStrategy.STANDALONE) {
            this.cache.setWriteEnabled(false);
            this.cache.setReadEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isAccessibleImpl() {
        boolean bl;
        long now = System.currentTimeMillis();
        NPath loc = this.config().getLocationPath();
        try {
            bl = loc.exists();
        }
        catch (Throwable throwable) {
            try {
                this._LOG().log(NMsg.ofC("check available %s : success", this.getName()).withLevel(Level.FINEST).withIntent(NMsgIntent.SUCCESS).withDurationMillis(System.currentTimeMillis() - now));
                throw throwable;
            }
            catch (Exception e) {
                this._LOG().log(NMsg.ofC("check available %s : failed", this.getName()).withLevel(Level.FINEST).withIntent(NMsgIntent.FAIL).withDurationMillis(System.currentTimeMillis() - now));
                return false;
            }
        }
        this._LOG().log(NMsg.ofC("check available %s : success", this.getName()).withLevel(Level.FINEST).withIntent(NMsgIntent.SUCCESS).withDurationMillis(System.currentTimeMillis() - now));
        return bl;
    }

    @Override
    public NIterator<NId> searchVersionsCore(NId id, NDefinitionFilter idFilter, NFetchMode fetchMode) {
        if (!this.acceptedFetchNoCache(fetchMode)) {
            return null;
        }
        NDefinitionFilter filter2 = ((NDefinitionFilter)NDefinitionFilters.of().nonnull(idFilter)).and(NDefinitionFilters.of().byName(id.getShortName()));
        if (id.getVersion().isSingleValue()) {
            return this.findSingleVersionImpl(id, filter2, fetchMode);
        }
        return this.findNonSingleVersionImpl(id, filter2, fetchMode);
    }

    @Override
    public NPath fetchContentCore(NId id, NDescriptor descriptor, NFetchMode fetchMode) {
        if (!this.acceptedFetchNoCache(fetchMode)) {
            throw new NArtifactNotFoundException(id, (Throwable)new NFetchModeNotSupportedException(this, fetchMode, id.toString(), null));
        }
        NPath fetch = NIdLocationUtils.fetch(id, descriptor.getLocations(), this);
        if (fetch != null) {
            return fetch;
        }
        return this.fetchContentCoreUsingRepoHelper(id, descriptor, fetchMode);
    }

    @Override
    public boolean isRemote() {
        return this.config().getLocationPath().isRemote();
    }

    @Override
    public NIterator<NId> searchCore(NDefinitionFilter filter, NPath[] basePaths, NId[] baseIds, NFetchMode fetchMode) {
        if (!this.acceptedFetchNoCache(fetchMode)) {
            return null;
        }
        NPath repoRoot = this.config().getLocationPath();
        ArrayList list = new ArrayList();
        NSession session = this.getWorkspace().currentSession();
        for (NPath basePath : basePaths) {
            list.add(NIteratorBuilder.ofRunnable(() -> session.getTerminal().printProgress(NMsg.ofC("%-14s %-8s %s", this.getName(), "browse", NCoreLogUtils.forProgress(basePath == null ? repoRoot : repoRoot.resolve(basePath)))), "Log").build());
            if (basePath.getName().equals("*")) {
                list.add(new NIdPathIterator(this, repoRoot, basePath.getParent(), filter, this.repoIter, Integer.MAX_VALUE, "core", null, true));
                continue;
            }
            list.add(new NIdPathIterator(this, repoRoot, basePath, filter, this.repoIter, 2, "core", null, true));
        }
        return NIteratorUtils.concat(list);
    }

    @Override
    public void updateStatisticsImpl() {
        this.config().getLocationPath().walkDfs(new NTreeVisitor<NPath>(){

            @Override
            public NTreeVisitResult preVisitDirectory(NPath dir) {
                return NTreeVisitResult.CONTINUE;
            }

            @Override
            public NTreeVisitResult visitFile(NPath file) {
                throw new NIOException(NMsg.ofPlain("updateStatistics Not supported."));
            }

            @Override
            public NTreeVisitResult visitFileFailed(NPath file, Exception exc) {
                throw new NIOException(NMsg.ofPlain("updateStatistics Not supported."));
            }

            @Override
            public NTreeVisitResult postVisitDirectory(NPath dir, Exception exc) {
                throw new NIOException(NMsg.ofPlain("updateStatistics Not supported."));
            }
        }, new NPathOption[0]);
    }

    @Override
    public boolean isAcceptFetchMode(NFetchMode mode) {
        return this.isRemote() || mode == NFetchMode.LOCAL;
    }

    public NPath fetchContentCoreUsingRepoHelper(final NId id, NDescriptor descriptor, NFetchMode fetchMode) {
        NPath p = this.getIdRemotePath(id);
        if (p.isLocal()) {
            if (p.exists()) {
                return p.copy();
            }
            throw new NArtifactNotFoundException(id);
        }
        String tempFile = NPath.ofTempRepositoryFile(p.getName(), this).toString();
        try {
            NCp.of().from(this.getStream(id, "artifact binaries", "retrieve")).to(NPath.of(tempFile)).setValidator(new NCpValidator(){

                @Override
                public void validate(InputStream in) throws IOException {
                    NFolderRepositoryBase.this.checkSHA1Hash(id.builder().setFace("content-hash").build(), in, "artifact binaries");
                }
            }).run();
        }
        catch (UncheckedIOException | NIOException ex) {
            throw new NArtifactNotFoundException(id, null, ex);
        }
        return NPath.of(tempFile).setUserTemporary(true).setUserCache(true);
    }

    public NIterator<NId> findNonSingleVersionImpl(NId id, NDefinitionFilter idFilter, NFetchMode fetchMode) {
        String groupId = id.getGroupId();
        String artifactId = id.getArtifactId();
        NPath foldersFileUrl = this.config().getLocationPath().resolve(groupId.replace('.', '/') + "/" + artifactId + "/");
        return NIteratorBuilder.ofSupplier(() -> {
            NSession.of().getTerminal().printProgress(NMsg.ofC("looking for versions of %s at %s", id, NCoreLogUtils.forProgress(foldersFileUrl)));
            try {
                return (Iterator)NIterator.of(((NStream)foldersFileUrl.stream().filter(NPath::isDirectory).redescribe(NElementDescribables.ofDesc("isDirectory"))).map(versionFolder -> {
                    String versionName = versionFolder.getName();
                    NId expectedId = NIdBuilder.of(groupId, artifactId).setVersion(versionName).build();
                    if (this.isValidArtifactVersionFolder(expectedId, (NPath)versionFolder)) {
                        NId nutsId = id.builder().setVersion(versionFolder.getName()).build();
                        if (idFilter == null || idFilter.acceptDefinition(NDefinitionHelper.ofIdAndLazyDescriptor(nutsId, () -> this.fetchDescriptor().setId(nutsId).getResult(), "NFolderRepositoryBase::findNonSingleVersionImpl"))) {
                            return expectedId;
                        }
                    }
                    return null;
                }).filterNonNull().iterator()).redescribe(NElementDescribables.ofDesc("findNonSingleVersion"));
            }
            catch (UncheckedIOException | NIOException ex) {
                return NIterator.ofEmpty();
            }
        }, () -> NElement.ofObjectBuilder().name("NonSingleVersion").set("path", foldersFileUrl.toString()).build()).build();
    }

    private boolean isValidArtifactVersionFolder(NId expectedId, NPath versionFolder) {
        String expectedFileName = this.getIdFilename(expectedId.builder().setFaceDescriptor().build());
        return versionFolder.resolve(expectedFileName).isRegularFile();
    }

    public NIterator<NId> findSingleVersionImpl(NId id, NDefinitionFilter idFilter, NFetchMode fetchMode) {
        String singleVersion = id.getVersion().asSingleValue().orNull();
        NSession session = this.getWorkspace().currentSession();
        if (singleVersion != null) {
            String groupId = id.getGroupId();
            String artifactId = id.getArtifactId();
            NPath metadataURL = this.config().getLocationPath().resolve(groupId.replace('.', '/') + "/" + artifactId + "/" + singleVersion + "/" + this.getIdFilename(id.builder().setFaceDescriptor().build()));
            return NIteratorBuilder.ofSupplier(() -> {
                ArrayList<NId> ret = new ArrayList<NId>();
                if (metadataURL.isRegularFile()) {
                    session.getTerminal().printProgress(NMsg.ofC("%-14s %-8s %s %s", this.getName(), "found", id.getLongId(), NCoreLogUtils.forProgress(NCoreLogUtils.forProgress(metadataURL))));
                    ret.add(id);
                } else {
                    session.getTerminal().printProgress(NMsg.ofC("%-14s %-8s %s %s", this.getName(), "missing", id.getLongId(), NCoreLogUtils.forProgress(NCoreLogUtils.forProgress(metadataURL))));
                }
                return ret.iterator();
            }, () -> NElement.ofObjectBuilder().name("SingleVersionAt").add("path", metadataURL.toString()).build()).build();
        }
        throw new NIllegalArgumentException(NMsg.ofC("expected single version in %s", id));
    }

    protected boolean acceptedFetchNoCache(NFetchMode fetchMode) {
        return fetchMode == NFetchMode.REMOTE == this.isRemote();
    }

    public InputStream getStream(NId id, String typeName, String action) {
        NPath url = this.getIdRemotePath(id);
        return this.openStream(id, url, id, typeName, action == null ? NMsg.ofC("retrieve %s", id.getLongId()) : NMsg.ofC("%s %s", action, id.getLongId()));
    }

    public String getStreamAsString(NId id, String typeName, String action) {
        byte[] barr = NCp.of().addOptions(NPathOption.LOG, NPathOption.TRACE, NPathOption.SAFE).from(this.getIdRemotePath(id)).setSourceOrigin(id).setActionMessage(action == null ? NMsg.ofC("copy %s", id.getLongId()) : NMsg.ofC("%s %s", action, id.getLongId())).setSourceTypeName(action).getByteArrayResult();
        return new String(barr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSHA1Hash(NId id, InputStream stream, String typeName) throws IOException {
        if (!this.isRemote()) {
            stream.close();
            return;
        }
        switch (NStringUtils.trim(id.getFace())) {
            case "content-hash": 
            case "descriptor-hash": {
                break;
            }
            default: {
                this._LOG().log(NMsg.ofC("[BUG] unsupported Hash Type %s", id.getFace()).asError(new NIllegalArgumentException(NMsg.ofC("unsupported Hash Type %s", id.getFace()))));
                throw new IOException("unsupported hash type " + id.getFace());
            }
        }
        try {
            String rhash = null;
            try {
                rhash = this.getStreamSHA1(id, typeName);
            }
            catch (UncheckedIOException | NIOException ex) {
                stream.close();
                return;
            }
            String lhash = NDigestUtils.evalSHA1Hex(stream, true);
            if (!rhash.equalsIgnoreCase(lhash)) {
                throw new IOException("invalid file hash " + id);
            }
        }
        finally {
            stream.close();
        }
    }

    protected String getStreamSHA1(NId id, String typeName) {
        String hash = this.getStreamAsString(id, typeName + " SHA1", "verify").toUpperCase();
        for (String s : hash.split("[ \n\r]")) {
            if (s.isEmpty()) continue;
            return s;
        }
        return hash.split("[ \n\r]")[0];
    }

    public InputStream openStream(NId id, NPath path, Object source, String typeName, NMsg action) {
        NSession session = this.getWorkspace().currentSession();
        session.getTerminal().printProgress(NMsg.ofC("%-14s %-8s %s %s", this.getName(), action, NNameFormat.LOWER_KEBAB_CASE.format(typeName), NCoreLogUtils.forProgress(path)));
        return NInputStreamMonitor.of().setSource(path).setOrigin(source).setSourceTypeName(typeName).create();
    }
}

