/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl;

import java.util.ArrayList;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NArtifactNotFoundException;
import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.command.NFetchMode;
import net.thevpc.nuts.command.NPushException;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NRepositoryConfigManager;
import net.thevpc.nuts.core.NRepositoryNotFoundException;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NSpeedQualifier;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.runtime.standalone.definition.NDefinitionHelper;
import net.thevpc.nuts.runtime.standalone.event.DefaultNContentEvent;
import net.thevpc.nuts.runtime.standalone.id.util.CoreNIdUtils;
import net.thevpc.nuts.runtime.standalone.repository.NRepositoryHelper;
import net.thevpc.nuts.runtime.standalone.repository.cmd.NRepositorySupportedAction;
import net.thevpc.nuts.runtime.standalone.repository.impl.NRepositoryExt;
import net.thevpc.nuts.runtime.standalone.repository.impl.NRepositoryFolderHelper;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceUtils;
import net.thevpc.nuts.spi.NDeployRepositoryCmd;
import net.thevpc.nuts.spi.NPushRepositoryCmd;
import net.thevpc.nuts.spi.NRepositorySPI;
import net.thevpc.nuts.text.NDescriptorFormat;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NIterator;
import net.thevpc.nuts.util.NIteratorBuilder;
import net.thevpc.nuts.util.NIteratorUtils;

public class NRepositoryMirroringHelper {
    private final NRepository repo;
    protected NRepositoryFolderHelper cache;

    public NRepositoryMirroringHelper(NRepository repo, NRepositoryFolderHelper cache) {
        this.repo = repo;
        this.cache = cache;
    }

    protected NIterator<NId> searchVersionsImpl_appendMirrors(NIterator<NId> namedNutIdIterator, NId id, NDefinitionFilter idFilter, NFetchMode fetchMode) {
        NSession session = this.repo.getWorkspace().currentSession();
        if (!session.isTransitive()) {
            return namedNutIdIterator;
        }
        ArrayList list = new ArrayList();
        list.add(namedNutIdIterator);
        if (this.repo.config().isSupportedMirroring()) {
            for (NRepository repo : this.repo.config().getMirrors()) {
                NSpeedQualifier sup = NSpeedQualifier.UNAVAILABLE;
                try {
                    sup = NRepositoryHelper.getSupportSpeedLevel(repo, NRepositorySupportedAction.SEARCH, id, fetchMode, session.isTransitive());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (sup == NSpeedQualifier.UNAVAILABLE) continue;
                NRepositorySPI repoSPI = NWorkspaceUtils.of().toRepositorySPI(repo);
                list.add(NIteratorBuilder.of(repoSPI.searchVersions().setId(id).setFilter(idFilter).setFetchMode(fetchMode).getResult()).named(NElement.ofUplet("searchInMirror", NElement.ofString(repo.getName()))).safeIgnore().build());
            }
        }
        return NIteratorUtils.concat(list);
    }

    protected NPath fetchContent(NId id, NDescriptor descriptor, NFetchMode fetchMode) {
        NPath cacheContent = this.cache.getLongIdLocalFile(id);
        NRepositoryConfigManager rconfig = this.repo.config();
        NWorkspace workspace = this.repo.getWorkspace();
        NSession session = workspace.currentSession();
        if (session.isTransitive() && rconfig.isSupportedMirroring()) {
            for (NRepository mirror : rconfig.getMirrors()) {
                try {
                    NRepositorySPI repoSPI = NWorkspaceUtils.of(workspace).toRepositorySPI(mirror);
                    NPath c = repoSPI.fetchContent().setId(id).setDescriptor(descriptor).setFetchMode(fetchMode).getResult();
                    if (c == null) continue;
                    return c;
                }
                catch (NArtifactNotFoundException nArtifactNotFoundException) {
                }
            }
        }
        return null;
    }

    public NWorkspace getWorkspace() {
        return this.repo.getWorkspace();
    }

    protected String getIdFilename(NId id) {
        return NRepositoryExt.of(this.repo).getIdFilename(id);
    }

    protected NDescriptor fetchDescriptorImplInMirrors(NId id, NFetchMode fetchMode) {
        String idFilename = this.getIdFilename(id);
        NWorkspace workspace = this.repo.getWorkspace();
        NSession session = workspace.currentSession();
        NPath versionFolder = this.cache.getLongIdLocalFolder(id);
        NRepositoryConfigManager rconf = this.repo.config();
        if (session.isTransitive() && rconf.isSupportedMirroring()) {
            for (NRepository remote : rconf.getMirrors()) {
                NDescriptor nutsDescriptor = null;
                try {
                    NRepositorySPI repoSPI = NWorkspaceUtils.of(workspace).toRepositorySPI(remote);
                    nutsDescriptor = repoSPI.fetchDescriptor().setId(id).setFetchMode(fetchMode).getResult();
                }
                catch (Exception repoSPI) {
                    // empty catch block
                }
                if (nutsDescriptor == null) continue;
                NPath goodFile = null;
                goodFile = versionFolder.resolve(idFilename);
                NDescriptorFormat.of(nutsDescriptor).print(goodFile);
                return nutsDescriptor;
            }
        }
        return null;
    }

    public NIterator<NId> search(NIterator<NId> li, NDefinitionFilter filter, NFetchMode fetchMode) {
        NRepositoryConfigManager rconfig = this.repo.config();
        NSession session = this.repo.getWorkspace().currentSession();
        if (!session.isTransitive() || !rconfig.isSupportedMirroring()) {
            return li;
        }
        ArrayList all = new ArrayList();
        all.add(li);
        for (NRepository remote : rconfig.getMirrors()) {
            NRepositorySPI repoSPI = NWorkspaceUtils.of().toRepositorySPI(remote);
            all.add(NIteratorUtils.safeIgnore(repoSPI.search().setFilter(filter).setFetchMode(fetchMode).getResult()));
        }
        return NIteratorUtils.concat(all);
    }

    public void push(NPushRepositoryCmd cmd) {
        NId id = cmd.getId();
        String repository = cmd.getRepository();
        NSession session = this.getWorkspace().currentSession();
        NSession nonTransitiveSession = session.copy().setTransitive(false);
        NDescriptor desc = nonTransitiveSession.callWith(() -> NWorkspaceUtils.of().toRepositorySPI(this.repo).fetchDescriptor().setId(id).setFetchMode(NFetchMode.LOCAL).getResult());
        NPath local = nonTransitiveSession.callWith(() -> NWorkspaceUtils.of().toRepositorySPI(this.repo).fetchContent().setId(id).setFetchMode(NFetchMode.LOCAL).getResult());
        if (local == null) {
            throw new NArtifactNotFoundException(id.getLongId());
        }
        if (!this.repo.config().isSupportedMirroring()) {
            throw new NPushException(id, NMsg.ofC("unable to push %s. no repository found.", id == null ? "<null>" : id));
        }
        NRepository repo = this.repo;
        if (NBlankable.isBlank(repository)) {
            ArrayList<NRepository> all = new ArrayList<NRepository>();
            for (NRepository remote : repo.config().getMirrors()) {
                NSpeedQualifier lvl = NRepositoryHelper.getSupportSpeedLevel(remote, NRepositorySupportedAction.DEPLOY, id, NFetchMode.LOCAL, false);
                if (lvl == NSpeedQualifier.UNAVAILABLE) continue;
                all.add(remote);
            }
            if (all.isEmpty()) {
                throw new NPushException(id, NMsg.ofC("unable to push %s. no repository found.", id == null ? "<null>" : id));
            }
            if (all.size() > 1) {
                throw new NPushException(id, NMsg.ofC("unable to perform push for %s. at least two Repositories (%s) provides the same nuts %s", id, all.stream().map(NRepository::getName).collect(Collectors.joining(",")), id));
            }
            repo = (NRepository)all.get(0);
        } else {
            repo = nonTransitiveSession.callWith(() -> this.repo.config().getMirror(repository));
        }
        if (repo == null) {
            throw new NRepositoryNotFoundException(repository);
        }
        NId effId = CoreNIdUtils.createContentFaceId(id.builder().setPropertiesQuery("").build(), desc);
        NDeployRepositoryCmd dep = NWorkspaceUtils.of().toRepositorySPI(repo).deploy().setId(effId).setContent(local).setDescriptor(desc).run();
        NRepositoryHelper.of(repo).events().fireOnPush(new DefaultNContentEvent(local, dep, session, repo));
    }

    public NId searchLatestVersion(NId bestId, NId id, NDefinitionFilter filter, NFetchMode fetchMode) {
        NRepositoryConfigManager rconfig = this.repo.config();
        NSession session = this.repo.getWorkspace().currentSession();
        if (session.isTransitive() && rconfig.isSupportedMirroring()) {
            for (NRepository remote : rconfig.getMirrors()) {
                NDescriptor nutsDescriptor = null;
                try {
                    NRepositorySPI repoSPI = NWorkspaceUtils.of().toRepositorySPI(remote);
                    nutsDescriptor = repoSPI.fetchDescriptor().setId(id).setFetchMode(fetchMode).getResult();
                }
                catch (Exception repoSPI) {
                    // empty catch block
                }
                if (nutsDescriptor == null || filter != null && !filter.acceptDefinition(NDefinitionHelper.ofDescriptorOnly(nutsDescriptor))) continue;
                NWorkspaceExt dws = NWorkspaceExt.of();
                NId id2 = dws.resolveEffectiveId(nutsDescriptor).builder().setFaceDescriptor().build();
                NPath localNutFile = this.cache.getLongIdLocalFile(id2);
                NDescriptorFormat.of(nutsDescriptor).print(localNutFile);
                if (bestId != null && id2.getVersion().compareTo(bestId.getVersion()) <= 0) continue;
                bestId = id2;
            }
        }
        return bestId;
    }
}

