/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl;

import java.util.ArrayList;
import net.thevpc.nuts.artifact.NArtifactNotFoundException;
import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.command.NFetchMode;
import net.thevpc.nuts.core.NAddRepositoryOptions;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NSpeedQualifier;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.runtime.standalone.repository.impl.NCachedRepository;
import net.thevpc.nuts.runtime.standalone.repository.impl.NRepositoryExt;
import net.thevpc.nuts.spi.NRepositorySPI;
import net.thevpc.nuts.util.NIterator;
import net.thevpc.nuts.util.NIteratorBuilder;
import net.thevpc.nuts.util.NIteratorUtils;

public class NRepositoryList
extends NCachedRepository {
    protected NRepository[] repoItems;

    public NRepositoryList(NAddRepositoryOptions options, NRepository[] repoItems, NRepository parentRepository, NSpeedQualifier speed, boolean supportedMirroring, String repositoryType, boolean supportsDeploy) {
        super(options, parentRepository, speed, supportedMirroring, repositoryType, supportsDeploy);
        this.repoItems = repoItems;
    }

    @Override
    public boolean isRemote() {
        for (NRepository repoItem : this.repoItems) {
            if (!repoItem.isRemote()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAcceptFetchMode(NFetchMode mode) {
        for (NRepository repoItem : this.repoItems) {
            if (!((NRepositorySPI)((Object)repoItem)).isAcceptFetchMode(mode)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean isAccessibleImpl() {
        for (NRepository repoItem : this.repoItems) {
            if (!repoItem.isAccessible()) continue;
            return true;
        }
        return false;
    }

    @Override
    public NIterator<NId> searchVersionsCore(NId id, NDefinitionFilter idFilter, NFetchMode fetchMode) {
        ArrayList all = new ArrayList();
        for (NRepository repoItem : this.repoItems) {
            all.add(((NRepositorySPI)((Object)repoItem)).searchVersions().setId(id).setFilter(idFilter).setFetchMode(fetchMode).getResult());
        }
        return NIteratorBuilder.ofCoalesce(all).build();
    }

    @Override
    public NPath fetchContentCore(NId id, NDescriptor descriptor, NFetchMode fetchMode) {
        for (NRepository repoItem : this.repoItems) {
            try {
                NPath result = ((NRepositorySPI)((Object)repoItem)).fetchContent().setId(id).setDescriptor(descriptor).setFetchMode(fetchMode).getResult();
                if (result == null) continue;
                return result;
            }
            catch (NArtifactNotFoundException nArtifactNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public NIterator<NId> searchCore(NDefinitionFilter filter, NPath[] basePaths, NId[] baseIds, NFetchMode fetchMode) {
        ArrayList list = new ArrayList();
        for (NRepository repoItem : this.repoItems) {
            list.add(((NRepositorySPI)((Object)repoItem)).search().setFilter(filter).setFetchMode(fetchMode).getResult());
        }
        return NIteratorUtils.concat(list);
    }

    @Override
    public void updateStatisticsImpl() {
        for (NRepository repoItem : this.repoItems) {
            ((NRepositorySPI)((Object)repoItem)).updateStatistics().run();
        }
    }

    @Override
    public NDescriptor fetchDescriptorCore(NId id, NFetchMode fetchMode) {
        for (NRepository repoItem : this.repoItems) {
            try {
                NDescriptor result = ((NRepositorySPI)((Object)repoItem)).fetchDescriptor().setId(id).setFetchMode(fetchMode).getResult();
                if (result == null) continue;
                return result;
            }
            catch (NArtifactNotFoundException nArtifactNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public NId searchLatestVersionCore(NId id, NDefinitionFilter filter, NFetchMode fetchMode) {
        for (NRepository repoItem : this.repoItems) {
            try {
                NId nId = ((NRepositoryExt)((Object)repoItem)).searchLatestVersion(id, filter, fetchMode);
                if (nId == null) continue;
                return nId;
            }
            catch (NArtifactNotFoundException nArtifactNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }
}

