/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import net.thevpc.nuts.artifact.NArtifactNotFoundException;
import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.command.NFetchMode;
import net.thevpc.nuts.command.NFetchModeNotSupportedException;
import net.thevpc.nuts.concurrent.NLock;
import net.thevpc.nuts.core.NAddRepositoryOptions;
import net.thevpc.nuts.core.NConfirmationMode;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NSpeedQualifier;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementDescribables;
import net.thevpc.nuts.io.NCp;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.platform.NStoreType;
import net.thevpc.nuts.runtime.standalone.repository.cmd.NRepositorySupportedAction;
import net.thevpc.nuts.runtime.standalone.repository.cmd.updatestats.AbstractNUpdateRepositoryStatsCmd;
import net.thevpc.nuts.runtime.standalone.repository.impl.AbstractNRepositoryBase;
import net.thevpc.nuts.runtime.standalone.repository.impl.NRepositoryFolderHelper;
import net.thevpc.nuts.runtime.standalone.repository.impl.NRepositoryMirroringHelper;
import net.thevpc.nuts.runtime.standalone.repository.impl.util.CommonRootsByIdHelper;
import net.thevpc.nuts.runtime.standalone.repository.impl.util.CommonRootsByPathHelper;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.xtra.glob.GlobUtils;
import net.thevpc.nuts.spi.NDeployRepositoryCmd;
import net.thevpc.nuts.spi.NPushRepositoryCmd;
import net.thevpc.nuts.spi.NRepositoryUndeployCmd;
import net.thevpc.nuts.spi.NUpdateRepositoryStatsCmd;
import net.thevpc.nuts.text.NI18n;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NFunction;
import net.thevpc.nuts.util.NIterator;
import net.thevpc.nuts.util.NIteratorBuilder;
import net.thevpc.nuts.util.NOptional;

public class NCachedRepository
extends AbstractNRepositoryBase {
    protected final NRepositoryFolderHelper lib;
    protected final NRepositoryFolderHelper cache = new NRepositoryFolderHelper(this, this.config().getStoreLocation(NStoreType.CACHE).resolve("id"), true, "cache", NElement.ofObjectBuilder().set("repoKind", "cache").build());
    private final NRepositoryMirroringHelper mirroring;
    private boolean lockEnabled = true;

    public NCachedRepository(NAddRepositoryOptions options, NRepository parent, NSpeedQualifier speed, boolean supportedMirroring, String repositoryType, boolean supportsDeploy) {
        super(options, parent, speed, supportedMirroring, repositoryType, supportsDeploy);
        this.lib = new NRepositoryFolderHelper(this, this.config().getStoreLocation(NStoreType.LIB).resolve("id"), false, "lib", NElement.ofObjectBuilder().set("repoKind", "lib").build());
        this.mirroring = new NRepositoryMirroringHelper(this, this.cache);
    }

    public boolean isLockEnabled() {
        return this.lockEnabled;
    }

    public NCachedRepository setLockEnabled(boolean lockEnabled) {
        this.lockEnabled = lockEnabled;
        return this;
    }

    public NRepositoryFolderHelper getLib() {
        return this.lib;
    }

    public NRepositoryFolderHelper getCache() {
        return this.cache;
    }

    protected NLog _LOG() {
        return NLog.of(NCachedRepository.class);
    }

    @Override
    public void pushImpl(NPushRepositoryCmd command) {
        this.mirroring.push(command);
    }

    @Override
    public NDescriptor deployImpl(NDeployRepositoryCmd command) {
        return this.lib.deploy(command, this.getWorkspace().currentSession().getConfirm().orDefault());
    }

    @Override
    public final void undeployImpl(NRepositoryUndeployCmd options) {
        this.lib.undeploy(options);
    }

    @Override
    public NDescriptor fetchDescriptorImpl(NId id, NFetchMode fetchMode) {
        NSession session = this.getWorkspace().currentSession();
        if (fetchMode != NFetchMode.REMOTE) {
            NDescriptor cacheDesc;
            NDescriptor libDesc;
            if (this.lib.isReadEnabled() && (libDesc = this.lib.fetchDescriptorImpl(id)) != null) {
                return libDesc;
            }
            if (this.cache.isReadEnabled() && session.isCached() && (cacheDesc = this.cache.fetchDescriptorImpl(id)) != null) {
                return cacheDesc;
            }
        }
        RuntimeException mirrorsEx = null;
        Callable<NOptional> nOptionalCallable = () -> {
            try {
                NDescriptor success = this.fetchDescriptorCore(id, fetchMode);
                if (success != null) {
                    if (this.cache.isWriteEnabled()) {
                        NId id0 = NWorkspaceExt.of().resolveEffectiveId(success);
                        if (!id0.getLongName().equals(success.getId().getLongName())) {
                            success = success.builder().setId(id0).build();
                        }
                        this.cache.deployDescriptor(success.getId(), success, NConfirmationMode.YES);
                    }
                    return NOptional.of(success);
                }
                return NOptional.ofError(() -> NMsg.ofC(NI18n.of("nuts descriptor not found %s"), id.getLongId()), (Throwable)new NArtifactNotFoundException(id.getLongId()));
            }
            catch (RuntimeException ex) {
                return NOptional.ofError(() -> NMsg.ofC(NI18n.of("nuts descriptor not found %s"), id), (Throwable)ex);
            }
        };
        NOptional res = null;
        try {
            boolean lockEnabled = this.isLockEnabled();
            res = lockEnabled ? NLock.ofId(id.builder().setFaceDescriptor().build()).callWith(nOptionalCallable) : nOptionalCallable.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (res.isPresent()) {
            return (NDescriptor)res.get();
        }
        NDescriptor m = null;
        try {
            m = this.mirroring.fetchDescriptorImplInMirrors(id, fetchMode);
        }
        catch (RuntimeException ex) {
            mirrorsEx = ex;
        }
        if (m != null) {
            return m;
        }
        if (res.getError() != null) {
            throw (RuntimeException)res.getError();
        }
        if (mirrorsEx != null) {
            throw mirrorsEx;
        }
        return m;
    }

    @Override
    public final NIterator<NId> searchVersionsImpl(NId id, NDefinitionFilter idFilter, NFetchMode fetchMode) {
        ArrayList all = new ArrayList();
        if (fetchMode != NFetchMode.REMOTE && this.lib.isReadEnabled()) {
            all.add(NIteratorBuilder.of(this.lib.searchVersions(id, idFilter, true)).named(NElement.ofUplet("searchVersionInLib", NElement.ofString(this.getName()))).build());
        }
        if (fetchMode != NFetchMode.REMOTE) {
            try {
                if (this.cache.isReadEnabled()) {
                    all.add(NIteratorBuilder.of(this.cache.searchVersions(id, idFilter, true)).named(NElement.ofUplet("searchVersionInCache", NElement.ofString(this.getName()))).build());
                }
            }
            catch (NArtifactNotFoundException nArtifactNotFoundException) {
                // empty catch block
            }
        }
        try {
            NIterator<NId> p = null;
            p = this.searchVersionsCore(id, idFilter, fetchMode);
            if (p != null) {
                all.add(NIteratorBuilder.of(p).named(NElement.ofUplet("searchVersionInCore", NElement.ofString(this.getName()))).build());
            }
        }
        catch (NArtifactNotFoundException p) {
        }
        catch (Exception ex) {
            this._LOG().log(NMsg.ofC(NI18n.of("search versions error : %s"), ex).asFinestFail(ex));
        }
        NIterator<Object> namedNutIdIterator = NIteratorBuilder.ofConcat(all).distinct(NFunction.of(NId::getLongName).redescribe((Supplier)NElementDescribables.ofDesc("getLongName"))).build();
        if (namedNutIdIterator == null) {
            namedNutIdIterator = NIteratorBuilder.emptyIterator();
        }
        return NIteratorBuilder.of(this.mirroring.searchVersionsImpl_appendMirrors(namedNutIdIterator, id, idFilter, fetchMode)).named(NElement.ofUplet("searchVersion", NElement.ofString(this.getName()))).build();
    }

    @Override
    public final NPath fetchContentImpl(NId id, NDescriptor descriptor, NFetchMode fetchMode) {
        NPath c;
        NPath c2;
        if (fetchMode != NFetchMode.REMOTE && (c2 = this.lib.fetchContentImpl(id)) != null) {
            return c2;
        }
        NSession session = this.getWorkspace().currentSession();
        if (this.cache.isReadEnabled() && session.isCached() && (c = this.cache.fetchContentImpl(id)) != null) {
            return c;
        }
        RuntimeException mirrorsEx = null;
        NPath c3 = null;
        Callable<NOptional> nOptionalCallable = () -> {
            if (this.cache.isWriteEnabled()) {
                NPath c2 = null;
                RuntimeException impl2Ex = null;
                NPath cachePath = this.cache.getLongIdLocalFile(id);
                try {
                    c2 = this.fetchContentCore(id, descriptor, fetchMode);
                }
                catch (RuntimeException ex) {
                    impl2Ex = ex;
                }
                if (c2 != null) {
                    NCp.of().from(c2).to(cachePath).run();
                    return NOptional.of(cachePath.setUserCache(true).setUserTemporary(false));
                }
                if (impl2Ex instanceof NArtifactNotFoundException) {
                    return NOptional.ofNamedEmpty(id.toString());
                }
                if (impl2Ex != null) {
                    return NOptional.ofError(() -> NMsg.ofC("nuts content not found %s", id), (Throwable)impl2Ex);
                }
                return NOptional.ofError(() -> NMsg.ofC("nuts content not found %s", id), (Throwable)new NArtifactNotFoundException(id.getLongId()));
            }
            NPath c2 = null;
            RuntimeException impl2Ex = null;
            try {
                c2 = this.fetchContentCore(id, descriptor, fetchMode);
            }
            catch (RuntimeException ex) {
                impl2Ex = ex;
            }
            if (c2 != null) {
                return NOptional.of(c2);
            }
            if (impl2Ex instanceof NArtifactNotFoundException) {
                return NOptional.ofNamedEmpty(id.toString());
            }
            if (impl2Ex != null) {
                return NOptional.ofError(() -> NMsg.ofC("nuts content not found %s", id), (Throwable)impl2Ex);
            }
            return NOptional.ofError(() -> NMsg.ofC("nuts content not found %s", id), (Throwable)new NArtifactNotFoundException(id.getLongId()));
        };
        NOptional res = null;
        try {
            boolean lockEnabled = this.isLockEnabled();
            res = lockEnabled ? NLock.ofId(id.builder().setFaceContent().build()).callWith(nOptionalCallable) : nOptionalCallable.call();
        }
        catch (Exception e) {
            res = NOptional.ofError(() -> NMsg.ofC("nuts content not found %s", id), (Throwable)e);
        }
        if (res.isPresent()) {
            return (NPath)res.get();
        }
        try {
            c3 = this.mirroring.fetchContent(id, descriptor, fetchMode);
        }
        catch (RuntimeException ex) {
            mirrorsEx = ex;
        }
        if (c3 != null) {
            return c3;
        }
        if (res.getError() != null) {
            if (res.getError() instanceof NArtifactNotFoundException) {
                throw (RuntimeException)res.getError();
            }
            throw new NArtifactNotFoundException(id, res.getError());
        }
        if (mirrorsEx != null) {
            if (mirrorsEx instanceof NArtifactNotFoundException) {
                throw mirrorsEx;
            }
            throw new NArtifactNotFoundException(id, (Throwable)mirrorsEx);
        }
        throw new NArtifactNotFoundException(id);
    }

    @Override
    public final NIterator<NId> searchImpl(NDefinitionFilter filter, NFetchMode fetchMode) {
        NSession session = this.getWorkspace().currentSession();
        List<NPath> basePaths = CommonRootsByPathHelper.resolveRootPaths(filter);
        List<NId> baseIds = CommonRootsByIdHelper.resolveRootPaths(filter);
        ArrayList li = new ArrayList();
        for (NPath basePath : basePaths) {
            if (fetchMode != NFetchMode.REMOTE) {
                if (basePath.getName().equals("*")) {
                    li.add(this.lib.findInFolder(basePath.getParent(), filter, Integer.MAX_VALUE));
                } else {
                    li.add(this.lib.findInFolder(basePath, filter, 2));
                }
            }
            if (!this.cache.isReadEnabled() || !session.isCached()) continue;
            if (basePath.getName().equals("*")) {
                li.add(this.cache.findInFolder(basePath.getParent(), filter, Integer.MAX_VALUE));
                continue;
            }
            li.add(this.cache.findInFolder(basePath, filter, 2));
        }
        NIterator<NId> p = null;
        try {
            p = this.searchCore(filter, basePaths.toArray(new NPath[0]), baseIds.toArray(new NId[0]), fetchMode);
        }
        catch (NArtifactNotFoundException basePath) {
        }
        catch (Exception ex) {
            this._LOG().log(NMsg.ofJ("search latest versions error : {0}", ex).asError(ex));
        }
        if (p != null) {
            li.add(p);
        }
        return this.mirroring.search(NIteratorBuilder.ofConcat(li).distinct(NFunction.of(NId::getLongName).redescribe((Supplier)NElementDescribables.ofDesc("getLongName"))).build(), filter, fetchMode);
    }

    protected boolean isAllowedOverrideArtifact(NId id) {
        return true;
    }

    public NIterator<NId> searchVersionsCore(NId id, NDefinitionFilter idFilter, NFetchMode fetchMode) {
        return null;
    }

    public NId searchLatestVersionCore(NId id, NDefinitionFilter filter, NFetchMode fetchMode) {
        return null;
    }

    public NDescriptor fetchDescriptorCore(NId id, NFetchMode fetchMode) {
        return null;
    }

    public NPath fetchContentCore(NId id, NDescriptor descriptor, NFetchMode fetchMode) {
        return null;
    }

    public NIterator<NId> searchCore(NDefinitionFilter filter, NPath[] basePaths, NId[] baseIds, NFetchMode fetchMode) {
        return null;
    }

    @Override
    public String getBootConnectionString() {
        if (this.options.getConfig() != null && this.options.getConfig().getLocation() != null) {
            return this.getName() + "=" + this.options.getConfig().getLocation().toString();
        }
        return null;
    }

    public void updateStatisticsImpl() {
    }

    @Override
    public boolean acceptAction(NId id, NRepositorySupportedAction supportedAction, NFetchMode mode) {
        String groups = this.config().getGroups();
        if (NBlankable.isBlank(groups)) {
            return true;
        }
        return GlobUtils.ofExact(groups).matcher(id.getGroupId()).matches();
    }

    @Override
    public final NId searchLatestVersion(NId id, NDefinitionFilter filter, NFetchMode fetchMode) {
        if (id.getVersion().isBlank() && filter == null) {
            NId bestId = this.lib.searchLatestVersion(id, filter);
            NId c1 = null;
            if (this.cache.isReadEnabled()) {
                c1 = this.cache.searchLatestVersion(id, filter);
                if (bestId == null || c1 != null && c1.getVersion().compareTo(bestId.getVersion()) > 0) {
                    bestId = c1;
                }
            }
            try {
                c1 = this.searchLatestVersionCore(id, filter, fetchMode);
                if (bestId == null || c1 != null && c1.getVersion().compareTo(bestId.getVersion()) > 0) {
                    bestId = c1;
                }
            }
            catch (NArtifactNotFoundException | NFetchModeNotSupportedException nException) {
            }
            catch (Exception ex) {
                this._LOG().log(NMsg.ofJ("search latest versions error : {0}", ex).asFinestFail(ex));
            }
            return this.mirroring.searchLatestVersion(bestId, id, filter, fetchMode);
        }
        return super.searchLatestVersion(id, filter, fetchMode);
    }

    @Override
    public final NUpdateRepositoryStatsCmd updateStatistics() {
        return new AbstractNUpdateRepositoryStatsCmd(this){

            @Override
            public NUpdateRepositoryStatsCmd run() {
                NCachedRepository.this.lib.reindexFolder();
                if (NCachedRepository.this.cache.isWriteEnabled()) {
                    NCachedRepository.this.cache.reindexFolder();
                }
                NCachedRepository.this.updateStatisticsImpl();
                return this;
            }
        };
    }

    @Override
    public boolean isAcceptFetchMode(NFetchMode mode) {
        return true;
    }

    @Override
    public boolean isRemote() {
        return true;
    }
}

