/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl;

import java.util.LinkedHashMap;
import java.util.logging.Level;
import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.command.NFetchMode;
import net.thevpc.nuts.core.NAddRepositoryOptions;
import net.thevpc.nuts.core.NIndexStore;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NSpeedQualifier;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.runtime.standalone.log.NLogUtils;
import net.thevpc.nuts.runtime.standalone.repository.cmd.NRepositorySupportedAction;
import net.thevpc.nuts.runtime.standalone.repository.cmd.deploy.DefaultNDeployRepositoryCmd;
import net.thevpc.nuts.runtime.standalone.repository.cmd.fetch.DefaultNFetchContentRepositoryCmd;
import net.thevpc.nuts.runtime.standalone.repository.cmd.fetch.DefaultNFetchDescriptorRepositoryCmd;
import net.thevpc.nuts.runtime.standalone.repository.cmd.push.DefaultNPushRepositoryCmd;
import net.thevpc.nuts.runtime.standalone.repository.cmd.search.DefaultNSearchRepositoryCmd;
import net.thevpc.nuts.runtime.standalone.repository.cmd.search.DefaultNSearchVersionsRepositoryCmd;
import net.thevpc.nuts.runtime.standalone.repository.cmd.undeploy.DefaultNRepositoryUndeployCmd;
import net.thevpc.nuts.runtime.standalone.repository.cmd.updatestats.AbstractNUpdateRepositoryStatsCmd;
import net.thevpc.nuts.runtime.standalone.repository.config.DefaultNRepositoryConfigModel;
import net.thevpc.nuts.runtime.standalone.repository.impl.AbstractNRepository;
import net.thevpc.nuts.runtime.standalone.repository.impl.NRepositoryExt;
import net.thevpc.nuts.runtime.standalone.workspace.config.NRepositoryConfigManagerExt;
import net.thevpc.nuts.runtime.standalone.xtra.glob.GlobUtils;
import net.thevpc.nuts.spi.NDeployRepositoryCmd;
import net.thevpc.nuts.spi.NFetchContentRepositoryCmd;
import net.thevpc.nuts.spi.NFetchDescriptorRepositoryCmd;
import net.thevpc.nuts.spi.NPushRepositoryCmd;
import net.thevpc.nuts.spi.NRepositoryLocation;
import net.thevpc.nuts.spi.NRepositoryUndeployCmd;
import net.thevpc.nuts.spi.NSearchRepositoryCmd;
import net.thevpc.nuts.spi.NSearchVersionsRepositoryCmd;
import net.thevpc.nuts.spi.NUpdateRepositoryStatsCmd;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NIterator;

public abstract class AbstractNRepositoryBase
extends AbstractNRepository
implements NRepositoryExt {
    private static final long serialVersionUID = 1L;
    protected NIndexStore nIndexStore;

    public AbstractNRepositoryBase(NAddRepositoryOptions options, NRepository parentRepository, NSpeedQualifier speed, boolean supportedMirroring, String repositoryType, boolean supportsDeploy) {
        this.supportsDeploy = supportsDeploy;
        this.init(options, parentRepository, speed, supportedMirroring, repositoryType);
    }

    @Override
    public NIndexStore getIndexStore() {
        return this.nIndexStore;
    }

    protected void init(NAddRepositoryOptions options, NRepository parent, NSpeedQualifier speed, boolean supportedMirroring, String repositoryType) {
        this.options = options.copy();
        this.parentRepository = parent;
        this.configModel = new DefaultNRepositoryConfigModel(this, options, this.workspace, speed, supportedMirroring, repositoryType);
        this.nIndexStore = NWorkspace.of().getIndexStoreClientFactory().createIndexStore(this);
    }

    @Override
    public boolean acceptAction(NId id, NRepositorySupportedAction supportedAction, NFetchMode mode) {
        String groups = this.config().getGroups();
        if (NBlankable.isBlank(groups)) {
            return true;
        }
        return GlobUtils.ofExact(groups).matcher(id.getGroupId()).matches();
    }

    @Override
    public String toString() {
        NRepositoryConfigManagerExt c = NRepositoryConfigManagerExt.of(this.config());
        String name = this.getName();
        String storePath = null;
        NRepositoryLocation loc = c.getModel().getLocation();
        String impl = this.getClass().getSimpleName();
        if (c != null) {
            storePath = c.getModel().getStoreLocation().toAbsolute().toString();
        }
        LinkedHashMap<String, String> a = new LinkedHashMap<String, String>();
        if (name != null) {
            a.put("name", name);
        }
        a.put("impl", impl);
        if (storePath != null) {
            a.put("store", storePath);
        }
        if (loc != null) {
            a.put("location", loc.toString());
        }
        return a.toString();
    }

    @Override
    public void checkAllowedFetch(NId id) {
    }

    @Override
    public NFetchDescriptorRepositoryCmd fetchDescriptor() {
        return new DefaultNFetchDescriptorRepositoryCmd(this);
    }

    @Override
    public NId searchLatestVersion(NId id, NDefinitionFilter filter, NFetchMode fetchMode) {
        NIterator<NId> allVersions = this.searchVersions().setId(id).setFilter(filter).setFetchMode(fetchMode).getResult();
        NId a = null;
        while (allVersions.hasNext()) {
            NId next = (NId)allVersions.next();
            if (a != null && next.getVersion().compareTo(a.getVersion()) <= 0) continue;
            a = next;
        }
        return a;
    }

    protected void traceMessage(NFetchMode fetchMode, Level lvl, NId id, NMsgIntent tracePhase, String title, long startTime, NMsg extraMessage) {
        NLogUtils.traceMessage(NLog.of(AbstractNRepositoryBase.class), lvl, this.getName(), fetchMode, id, tracePhase, title, startTime, extraMessage);
    }

    @Override
    public NDeployRepositoryCmd deploy() {
        return new DefaultNDeployRepositoryCmd(this);
    }

    @Override
    public NPushRepositoryCmd push() {
        return new DefaultNPushRepositoryCmd(this);
    }

    @Override
    public NSearchRepositoryCmd search() {
        return new DefaultNSearchRepositoryCmd(this);
    }

    @Override
    public NFetchContentRepositoryCmd fetchContent() {
        return new DefaultNFetchContentRepositoryCmd(this);
    }

    @Override
    public NSearchVersionsRepositoryCmd searchVersions() {
        return new DefaultNSearchVersionsRepositoryCmd(this);
    }

    @Override
    public NRepositoryUndeployCmd undeploy() {
        return new DefaultNRepositoryUndeployCmd(this);
    }

    protected String getIdComponentExtension(String packaging) {
        return NWorkspace.of().getDefaultIdContentExtension(packaging);
    }

    @Override
    protected String getIdExtension(NId id) {
        return NWorkspace.of().getDefaultIdExtension(id);
    }

    @Override
    public NPath getIdBasedir(NId id) {
        return NWorkspace.of().getDefaultIdBasedir(id);
    }

    public NPath getIdRemotePath(NId id) {
        return this.config().getLocationPath().resolve(this.getIdRelativePath(id));
    }

    protected NPath getIdRelativePath(NId id) {
        return this.getIdBasedir(id).resolve(this.getIdFilename(id));
    }

    @Override
    public NUpdateRepositoryStatsCmd updateStatistics() {
        return new AbstractNUpdateRepositoryStatsCmd(this){

            @Override
            public NUpdateRepositoryStatsCmd run() {
                return this;
            }
        };
    }
}

