/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.concurrent.NCachedValue;
import net.thevpc.nuts.core.NAddRepositoryOptions;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NRepositoryConfigManager;
import net.thevpc.nuts.core.NRepositoryListener;
import net.thevpc.nuts.core.NRepositorySecurityManager;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.runtime.standalone.repository.config.DefaultNRepoConfigManager;
import net.thevpc.nuts.runtime.standalone.repository.config.NRepositoryConfigModel;
import net.thevpc.nuts.runtime.standalone.security.DefaultNRepositorySecurityManager;
import net.thevpc.nuts.runtime.standalone.security.DefaultNRepositorySecurityModel;
import net.thevpc.nuts.runtime.standalone.workspace.config.NRepositoryConfigManagerExt;
import net.thevpc.nuts.spi.NRepositoryLocation;
import net.thevpc.nuts.spi.NRepositorySPI;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NDefaultObservableMap;
import net.thevpc.nuts.util.NObservableMap;
import net.thevpc.nuts.util.NObservableMapListener;
import net.thevpc.nuts.util.NStringUtils;

public abstract class AbstractNRepository
implements NRepository,
NRepositorySPI {
    private static final long serialVersionUID = 1L;
    private final List<NRepositoryListener> repositoryListeners = new ArrayList<NRepositoryListener>();
    protected Map<String, String> extensions = new HashMap<String, String>();
    protected NRepository parentRepository;
    protected NWorkspace workspace = NWorkspace.of();
    protected DefaultNRepositorySecurityModel securityModel;
    protected NRepositoryConfigModel configModel;
    protected NObservableMap<String, Object> userProperties = new NDefaultObservableMap<String, Object>();
    protected NCachedValue<Boolean> available;
    protected boolean supportsDeploy;
    protected boolean enabled = true;
    protected NAddRepositoryOptions options;

    public AbstractNRepository() {
        this.securityModel = new DefaultNRepositorySecurityModel(this);
        this.available = NCachedValue.of(() -> this.isAccessibleImpl());
    }

    @Override
    public boolean isTemporary() {
        return this.options != null && this.options.isTemporary();
    }

    @Override
    public boolean isPreview() {
        return this.configModel.containsTag("preview");
    }

    @Override
    public boolean containsTags(String tag) {
        return this.configModel.containsTag(NStringUtils.trim(tag));
    }

    @Override
    public Set<String> getTags() {
        return this.configModel.getTags();
    }

    @Override
    public NRepository addTag(String tag) {
        this.configModel.addTag(NStringUtils.trim(tag));
        return this;
    }

    @Override
    public NRepository removeTag(String tag) {
        this.configModel.removeTag(tag);
        return this;
    }

    @Override
    public boolean isAccessible() {
        return this.isAccessible(false);
    }

    @Override
    public boolean isAccessible(boolean force) {
        if (force) {
            return this.available.invalidate().get();
        }
        return this.available.get();
    }

    @Override
    public boolean isSupportedDeploy() {
        return this.isSupportedDeploy(false);
    }

    @Override
    public boolean isSupportedDeploy(boolean force) {
        return this.supportsDeploy;
    }

    protected boolean isAccessibleImpl() {
        return true;
    }

    @Override
    public String getRepositoryType() {
        return this.config().getType();
    }

    @Override
    public String getUuid() {
        return this.configModel.getUuid();
    }

    @Override
    public String getName() {
        return this.configModel.getName();
    }

    @Override
    public NWorkspace getWorkspace() {
        return this.workspace;
    }

    @Override
    public NRepository getParentRepository() {
        return this.parentRepository;
    }

    @Override
    public NRepositoryConfigManager config() {
        return new DefaultNRepoConfigManager(this.configModel);
    }

    @Override
    public NRepositorySecurityManager security() {
        return new DefaultNRepositorySecurityManager(this.securityModel);
    }

    @Override
    public NRepository removeRepositoryListener(NRepositoryListener listener) {
        this.repositoryListeners.add(listener);
        return this;
    }

    @Override
    public NRepository addRepositoryListener(NRepositoryListener listener) {
        if (listener != null) {
            this.repositoryListeners.add(listener);
        }
        return this;
    }

    @Override
    public List<NRepositoryListener> getRepositoryListeners() {
        return this.repositoryListeners;
    }

    @Override
    public Map<String, Object> getUserProperties() {
        return this.userProperties;
    }

    @Override
    public NRepository addUserPropertyListener(NObservableMapListener<String, Object> listener) {
        this.userProperties.addMapListener(listener);
        return this;
    }

    @Override
    public NRepository removeUserPropertyListener(NObservableMapListener<String, Object> listener) {
        this.userProperties.removeMapListener(listener);
        return this;
    }

    @Override
    public List<NObservableMapListener<String, Object>> getUserPropertyListeners() {
        return this.userProperties.getMapListeners();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled && this.config().isEnabled();
    }

    @Override
    public NRepository setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String toString() {
        NRepositoryConfigManagerExt cc = NRepositoryConfigManagerExt.of(this.config());
        NRepositoryConfigManager c = this.config();
        String name = this.getName();
        String storePath = null;
        NRepositoryLocation loc = cc.getModel().getLocation();
        String impl = this.getClass().getSimpleName();
        if (c != null) {
            NPath storeLocation = cc.getModel().getStoreLocation();
            storePath = storeLocation == null ? null : storeLocation.toAbsolute().toString();
        }
        LinkedHashMap<String, String> a = new LinkedHashMap<String, String>();
        if (name != null) {
            a.put("name", name);
        }
        if (impl != null) {
            a.put("impl", impl);
        }
        if (storePath != null) {
            a.put("store", storePath);
        }
        if (loc != null) {
            a.put("location", loc.toString());
        }
        return a.toString();
    }

    protected String getIdExtension(NId id) {
        return NWorkspace.of().getDefaultIdExtension(id);
    }

    public NPath getIdBasedir(NId id) {
        return NWorkspace.of().getDefaultIdBasedir(id);
    }

    public String getIdFilename(NId id) {
        return this.getIdFilename(id, this.getIdExtension(id));
    }

    public String getIdFilename(NId id, String ext) {
        String c;
        String classifier = "";
        if (!(ext.equals(".nuts") || ext.equals(".pom") || NBlankable.isBlank(c = id.getClassifier()))) {
            classifier = "-" + c;
        }
        return id.getArtifactId() + "-" + id.getVersion().getValue() + classifier + ext;
    }
}

