/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NRepositoryFilter;
import net.thevpc.nuts.core.NRepositoryFilters;
import net.thevpc.nuts.runtime.standalone.repository.filter.AbstractRepositoryFilter;
import net.thevpc.nuts.util.NFilterOp;
import net.thevpc.nuts.util.NStringUtils;

public class DefaultNRepositoryUuidFilter
extends AbstractRepositoryFilter {
    private final Set<String> exactRepos;

    public DefaultNRepositoryUuidFilter(Collection<String> exactRepos) {
        super(NFilterOp.CUSTOM);
        this.exactRepos = new HashSet<String>(exactRepos == null ? new ArrayList() : (Collection)exactRepos.stream().map(x -> NStringUtils.trimToNull(x)).filter(x -> x != null).collect(Collectors.toList()));
    }

    @Override
    public boolean acceptRepository(NRepository repository) {
        return this.exactRepos.contains(repository.getUuid());
    }

    @Override
    public NRepositoryFilter simplify() {
        if (this.exactRepos.isEmpty()) {
            return (NRepositoryFilter)NRepositoryFilters.of().always();
        }
        return this;
    }

    public String toString() {
        return "DefaultNRepositoryUuidFilter{repos=" + this.exactRepos + '}';
    }

    public int hashCode() {
        int hash = this.getClass().getName().hashCode();
        hash = 41 * hash + Objects.hashCode(this.exactRepos);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultNRepositoryUuidFilter other = (DefaultNRepositoryUuidFilter)obj;
        return Objects.equals(this.exactRepos, other.exactRepos);
    }
}

