/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.cmd.undeploy;

import java.util.logging.Level;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.runtime.standalone.repository.cmd.undeploy.AbstractNRepositoryUndeployCmd;
import net.thevpc.nuts.runtime.standalone.repository.impl.NRepositoryExt;
import net.thevpc.nuts.spi.NRepositoryUndeployCmd;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NPositionType;
import net.thevpc.nuts.util.NException;
import net.thevpc.nuts.util.NStringUtils;

public class DefaultNRepositoryUndeployCmd
extends AbstractNRepositoryUndeployCmd {
    public DefaultNRepositoryUndeployCmd(NRepository repo) {
        super(repo);
    }

    public DefaultNRepositoryUndeployCmd() {
        super(null);
    }

    protected NLog _LOG() {
        return NLog.of(DefaultNRepositoryUndeployCmd.class);
    }

    @Override
    public NRepositoryUndeployCmd run() {
        NSession session = this.getRepo().getWorkspace().currentSession();
        this.getRepo().security().checkAllowed("undeploy", "undeploy");
        try {
            NRepositoryExt xrepo = NRepositoryExt.of(this.getRepo());
            xrepo.undeployImpl(this);
            if (session.isIndexed() && xrepo.getIndexStore() != null && xrepo.getIndexStore().isEnabled()) {
                try {
                    xrepo.getIndexStore().invalidate(this.getId());
                }
                catch (NException ex) {
                    this._LOG().log(NMsg.ofC("error invalidating Indexer for %s : %s", this.getRepo().getName(), ex).withLevel(Level.FINEST).withIntent(NMsgIntent.FAIL));
                }
            }
            this._LOG().log(NMsg.ofC("%s undeploy %s", NStringUtils.formatAlign(this.getRepo().getName(), 20, NPositionType.FIRST), this.getId()).withLevel(Level.FINEST).withIntent(NMsgIntent.SUCCESS));
        }
        catch (RuntimeException ex) {
            this._LOG().log(NMsg.ofC("%s undeploy %s", NStringUtils.formatAlign(this.getRepo().getName(), 20, NPositionType.FIRST), this.getId()).withLevel(Level.FINEST).withIntent(NMsgIntent.FAIL));
        }
        return this;
    }
}

