/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.cmd.push;

import java.util.logging.Level;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.runtime.standalone.repository.cmd.push.AbstractNPushRepositoryCmd;
import net.thevpc.nuts.runtime.standalone.repository.impl.NRepositoryExt;
import net.thevpc.nuts.spi.NPushRepositoryCmd;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NPositionType;
import net.thevpc.nuts.util.NStringUtils;

public class DefaultNPushRepositoryCmd
extends AbstractNPushRepositoryCmd {
    public DefaultNPushRepositoryCmd(NRepository repo) {
        super(repo);
    }

    protected NLog _LOG() {
        return NLog.of(DefaultNPushRepositoryCmd.class);
    }

    @Override
    public NPushRepositoryCmd run() {
        block2: {
            this.getRepo().security().checkAllowed("push", "push");
            try {
                NRepositoryExt.of(this.getRepo()).pushImpl(this);
                this._LOG().log(NMsg.ofC("%s push %s", NStringUtils.formatAlign(this.getRepo().getName(), 20, NPositionType.FIRST), this.getId()).withLevel(Level.FINEST).withIntent(NMsgIntent.SUCCESS));
            }
            catch (RuntimeException ex) {
                if (!this._LOG().isLoggable(Level.FINEST)) break block2;
                this._LOG().log(NMsg.ofC("%s push %s", NStringUtils.formatAlign(this.getRepo().getName(), 20, NPositionType.FIRST), this.getId()).withLevel(Level.FINEST).withIntent(NMsgIntent.FAIL));
            }
        }
        return this;
    }
}

