/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.cmd.fetch;

import java.util.Map;
import java.util.logging.Level;
import net.thevpc.nuts.artifact.NArtifactNotFoundException;
import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.artifact.NDefinitionFilters;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.runtime.standalone.id.util.CoreNIdUtils;
import net.thevpc.nuts.runtime.standalone.log.NLogUtils;
import net.thevpc.nuts.runtime.standalone.repository.cmd.fetch.AbstractNFetchDescriptorRepositoryCmd;
import net.thevpc.nuts.runtime.standalone.repository.impl.NRepositoryExt;
import net.thevpc.nuts.runtime.standalone.util.CoreNUtils;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.spi.NFetchDescriptorRepositoryCmd;

public class DefaultNFetchDescriptorRepositoryCmd
extends AbstractNFetchDescriptorRepositoryCmd {
    public DefaultNFetchDescriptorRepositoryCmd(NRepository repo) {
        super(repo);
    }

    protected NLog _LOG() {
        return NLog.of(DefaultNFetchDescriptorRepositoryCmd.class);
    }

    @Override
    public boolean configureFirst(NCmdLine cmdLine) {
        return super.configureFirst(cmdLine);
    }

    @Override
    public NFetchDescriptorRepositoryCmd run() {
        CoreNIdUtils.checkLongId(this.id);
        this.getRepo().security().checkAllowed("fetch-desc", "fetch-descriptor");
        Map<String, String> queryMap = this.id.getProperties();
        queryMap.remove("optional");
        queryMap.remove("scope");
        queryMap.put("face", "descriptor");
        this.id = this.id.builder().setProperties(queryMap).build();
        NRepositoryExt xrepo = NRepositoryExt.of(this.getRepo());
        xrepo.checkAllowedFetch(this.id);
        long startTime = System.currentTimeMillis();
        try {
            String versionString = this.id.getVersion().getValue();
            NDescriptor d = null;
            NVersion nutsVersion = NVersion.get(versionString).orElse(NVersion.BLANK);
            if (nutsVersion.isBlank() || nutsVersion.isReleaseVersion() || nutsVersion.isLatestVersion()) {
                NId a = xrepo.searchLatestVersion(this.id.builder().setVersion("").build(), null, this.getFetchMode());
                if (a == null) {
                    throw new NArtifactNotFoundException(this.id.getLongId());
                }
                a = a.builder().setFaceDescriptor().build();
                d = xrepo.fetchDescriptorImpl(a, this.getFetchMode());
            } else if (nutsVersion.isSingleValue()) {
                this.id = this.id.builder().setFaceDescriptor().build();
                d = xrepo.fetchDescriptorImpl(this.id, this.getFetchMode());
            } else {
                NDefinitionFilters dd = NDefinitionFilters.of();
                NDefinitionFilter filter = dd.byEnv(this.id.getProperties()).and(dd.byName(this.id.getFullName()));
                NId a = xrepo.searchLatestVersion(this.id.builder().setVersion("").build(), filter, this.getFetchMode());
                if (a == null) {
                    throw new NArtifactNotFoundException(this.id.getLongId());
                }
                a = a.builder().setFaceDescriptor().build();
                d = xrepo.fetchDescriptorImpl(a, this.getFetchMode());
            }
            if (d == null) {
                throw new NArtifactNotFoundException(this.id.getLongId());
            }
            NLogUtils.traceMessage(this._LOG(), Level.FINER, this.getRepo().getName(), this.getFetchMode(), this.id.getLongId(), NMsgIntent.SUCCESS, "fetch descriptor", startTime, null);
            this.result = d;
        }
        catch (Exception ex) {
            if (!CoreNUtils.isUnsupportedFetchModeException(ex)) {
                NLogUtils.traceMessage(this._LOG(), Level.FINEST, this.getRepo().getName(), this.getFetchMode(), this.id.getLongId(), NMsgIntent.FAIL, "fetch descriptor", startTime, CoreStringUtils.exceptionToMessage(ex));
            }
            throw ex;
        }
        return this;
    }

    @Override
    public NDescriptor getResult() {
        if (this.result == null) {
            this.run();
        }
        return this.result;
    }
}

