/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.cmd.fetch;

import java.util.logging.Level;
import net.thevpc.nuts.artifact.NArtifactNotFoundException;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.runtime.standalone.log.NLogUtils;
import net.thevpc.nuts.runtime.standalone.repository.cmd.fetch.AbstractNFetchContentRepositoryCmd;
import net.thevpc.nuts.runtime.standalone.repository.impl.NRepositoryExt;
import net.thevpc.nuts.runtime.standalone.util.CoreNUtils;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceUtils;
import net.thevpc.nuts.spi.NFetchContentRepositoryCmd;
import net.thevpc.nuts.spi.NRepositorySPI;

public class DefaultNFetchContentRepositoryCmd
extends AbstractNFetchContentRepositoryCmd {
    public DefaultNFetchContentRepositoryCmd(NRepository repo) {
        super(repo);
    }

    protected NLog _LOG() {
        return NLog.of(DefaultNFetchContentRepositoryCmd.class);
    }

    @Override
    public NFetchContentRepositoryCmd run() {
        NRepository repo = this.getRepo();
        NDescriptor descriptor0 = this.descriptor;
        if (descriptor0 == null) {
            NRepositorySPI repoSPI = NWorkspaceUtils.of(this.getRepo().getWorkspace()).toRepositorySPI(repo);
            descriptor0 = repoSPI.fetchDescriptor().setId(this.id).setFetchMode(this.getFetchMode()).getResult();
        }
        this.id = this.id.builder().setFaceContent().build();
        repo.security().checkAllowed("fetch-content", "fetch-content");
        NRepositoryExt xrepo = NRepositoryExt.of(repo);
        xrepo.checkAllowedFetch(this.id);
        long startTime = System.currentTimeMillis();
        try {
            NPath f = xrepo.fetchContentImpl(this.id, descriptor0, this.getFetchMode());
            if (f == null) {
                throw new NArtifactNotFoundException(this.id.getLongId());
            }
            NLogUtils.traceMessage(this._LOG(), Level.FINER, repo.getName(), this.getFetchMode(), this.id.getLongId(), NMsgIntent.SUCCESS, "fetch content", startTime, null);
            this.result = f;
        }
        catch (RuntimeException ex) {
            if (!CoreNUtils.isUnsupportedFetchModeException(ex)) {
                NLogUtils.traceMessage(this._LOG(), Level.FINEST, repo.getName(), this.getFetchMode(), this.id.getLongId(), NMsgIntent.FAIL, "fetch content", startTime, CoreStringUtils.exceptionToMessage(ex));
            }
            throw ex;
        }
        return this;
    }

    @Override
    public NFetchContentRepositoryCmd setId(NId id) {
        this.id = id;
        return this;
    }

    @Override
    public NId getId() {
        return this.id;
    }
}

