/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.cmd.deploy;

import java.util.logging.Level;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.runtime.standalone.repository.cmd.deploy.AbstractNDeployRepositoryCmd;
import net.thevpc.nuts.runtime.standalone.repository.impl.NRepositoryExt;
import net.thevpc.nuts.spi.NDeployRepositoryCmd;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NPositionType;
import net.thevpc.nuts.util.NException;
import net.thevpc.nuts.util.NStringUtils;

public class DefaultNDeployRepositoryCmd
extends AbstractNDeployRepositoryCmd {
    public DefaultNDeployRepositoryCmd(NRepository repo) {
        super(repo);
    }

    protected NLog _LOG() {
        return NLog.of(DefaultNDeployRepositoryCmd.class);
    }

    @Override
    public NDeployRepositoryCmd run() {
        NSession session = this.repo.getWorkspace().currentSession();
        this.getRepo().security().checkAllowed("deploy", "deploy");
        this.checkParameters();
        try {
            NRepositoryExt xrepo = NRepositoryExt.of(this.repo);
            NDescriptor rep = xrepo.deployImpl(this);
            this.setDescriptor(rep);
            this.setId(rep.getId());
            if (session.isIndexed() && xrepo.getIndexStore() != null && xrepo.getIndexStore().isEnabled()) {
                try {
                    xrepo.getIndexStore().revalidate(this.getId());
                }
                catch (NException ex) {
                    this._LOG().log(NMsg.ofJ("error revalidating Indexer for {0} : {1}", this.getRepo().getName(), ex).withLevel(Level.FINEST).withIntent(NMsgIntent.FAIL));
                }
            }
            this._LOG().log(NMsg.ofJ("{0} deploy {1}", NStringUtils.formatAlign(this.getRepo().getName(), 20, NPositionType.FIRST), this.getId()).withLevel(Level.FINEST).withIntent(NMsgIntent.SUCCESS));
        }
        catch (RuntimeException ex) {
            this._LOG().log(NMsg.ofJ("{0} deploy {1}", NStringUtils.formatAlign(this.getRepo().getName(), 20, NPositionType.FIRST), this.getId()).withLevel(Level.FINEST).withIntent(NMsgIntent.FAIL));
            throw ex;
        }
        return this;
    }
}

