/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.cmd.deploy;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.io.NInputSource;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.runtime.standalone.id.util.CoreNIdUtils;
import net.thevpc.nuts.runtime.standalone.repository.cmd.NRepositoryCmdBase;
import net.thevpc.nuts.spi.NDeployRepositoryCmd;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NIllegalArgumentException;

public abstract class AbstractNDeployRepositoryCmd
extends NRepositoryCmdBase<NDeployRepositoryCmd>
implements NDeployRepositoryCmd {
    private NId id;
    private NInputSource content;
    private NDescriptor descriptor;

    public AbstractNDeployRepositoryCmd(NRepository repo) {
        super(repo, "deploy");
    }

    @Override
    public boolean configureFirst(NCmdLine cmdLine) {
        return super.configureFirst(cmdLine);
    }

    @Override
    public NInputSource getContent() {
        return this.content;
    }

    @Override
    public NDeployRepositoryCmd setContent(NInputSource content) {
        this.content = content;
        return this;
    }

    @Override
    public NDeployRepositoryCmd setContent(NPath content) {
        this.content = content;
        return this;
    }

    @Override
    public NDeployRepositoryCmd setContent(Path content) {
        this.content = content == null ? null : NPath.of(content);
        return this;
    }

    @Override
    public NDeployRepositoryCmd setContent(URL content) {
        this.content = content == null ? null : NPath.of(content);
        return this;
    }

    @Override
    public NDeployRepositoryCmd setContent(File content) {
        this.content = content == null ? null : NPath.of(content);
        return this;
    }

    @Override
    public NDeployRepositoryCmd setContent(InputStream content) {
        this.content = content == null ? null : NInputSource.of(content);
        return this;
    }

    @Override
    public NDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public NDeployRepositoryCmd setDescriptor(NDescriptor descriptor) {
        this.descriptor = descriptor;
        return this;
    }

    @Override
    public NId getId() {
        return this.id;
    }

    @Override
    public NDeployRepositoryCmd setId(NId id) {
        this.id = id;
        return this;
    }

    protected void checkParameters() {
        this.getRepo().security().checkAllowed("deploy", "deploy");
        CoreNIdUtils.checkLongId(this.getId());
        NAssert.requireNonNull(this.getContent(), "content");
        NAssert.requireNonNull(this.getDescriptor(), "descriptor");
        if (this.getId().getVersion().isReleaseVersion() || this.getId().getVersion().isLatestVersion()) {
            throw new NIllegalArgumentException(NMsg.ofC("invalid version %s", this.getId().getVersion()));
        }
    }
}

