/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository;

import java.util.Set;
import net.thevpc.nuts.core.NAddRepositoryOptions;
import net.thevpc.nuts.core.NRepositoryConfig;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.platform.NPlatformHome;
import net.thevpc.nuts.platform.NStoreType;
import net.thevpc.nuts.runtime.standalone.util.NMapWithAlias;
import net.thevpc.nuts.spi.NRepositoryDB;
import net.thevpc.nuts.spi.NRepositoryLocation;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NMaps;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NScorableContext;

public class DefaultNRepositoryDB
implements NRepositoryDB {
    private final NMapWithAlias<String, NAddRepositoryOptions> optionByName = new NMapWithAlias();
    private final NMapWithAlias<String, NAddRepositoryOptions> optionByLocation = new NMapWithAlias();

    private DefaultNRepositoryDB() {
        this.reg(new NAddRepositoryOptions().setDeployWeight(100).setName("system").setFailSafe(true).setCreate(true).setOrder(2000).setConfig(new NRepositoryConfig().setLocation(NRepositoryLocation.of("nuts@" + NPath.of(NPlatformHome.SYSTEM.getWorkspaceLocation(NStoreType.LIB, NWorkspace.of().getStoredConfig().getHomeLocations(), "default-workspace")).resolve("id").toString()))), new String[0]);
        this.reg(new NAddRepositoryOptions().setName("maven").setFailSafe(false).setCreate(true).setOrder(10000).setConfig(new NRepositoryConfig().setLocation(NRepositoryLocation.of("maven@maven")).setEnv(NMaps.of("maven.solrsearch.url", "https://search.maven.org/solrsearch/select", "maven.solrsearch.enable", "true"))), "mvn");
        this.reg(new NAddRepositoryOptions().setName("maven-central").setFailSafe(false).setCreate(true).setOrder(10000).setConfig(new NRepositoryConfig().setLocation(NRepositoryLocation.of("maven@htmlfs+https://repo.maven.apache.org/maven2")).setEnv(NMaps.of("maven.solrsearch.url", "https://search.maven.org/solrsearch/select", "maven.solrsearch.enable", "true"))), "central");
        this.reg(new NAddRepositoryOptions().setName("jcenter").setFailSafe(false).setCreate(true).setOrder(10000).setConfig(new NRepositoryConfig().setLocation(NRepositoryLocation.of("maven@https://jcenter.bintray.com"))), new String[0]);
        this.reg(new NAddRepositoryOptions().setName("jboss").setFailSafe(false).setCreate(true).setOrder(10000).setConfig(new NRepositoryConfig().setLocation(NRepositoryLocation.of("maven@https://repository.jboss.org/nexus/content/repositories/releases"))), new String[0]);
        this.reg(new NAddRepositoryOptions().setName("clojars").setFailSafe(false).setCreate(true).setOrder(10000).setConfig(new NRepositoryConfig().setLocation(NRepositoryLocation.of("maven@https://repo.clojars.org"))), new String[0]);
        this.reg(new NAddRepositoryOptions().setName("atlassian").setFailSafe(false).setCreate(true).setOrder(10000).setConfig(new NRepositoryConfig().setLocation(NRepositoryLocation.of("maven@htmlfs+https://packages.atlassian.com/maven/public"))), new String[0]);
        this.reg(new NAddRepositoryOptions().setName("atlassian-atlassian").setFailSafe(false).setCreate(true).setOrder(10000).setConfig(new NRepositoryConfig().setLocation(NRepositoryLocation.of("maven@https://packages.atlassian.com/maven/public-snapshot"))), new String[0]);
        this.reg(new NAddRepositoryOptions().setName("oracle").setFailSafe(false).setCreate(true).setOrder(10000).setConfig(new NRepositoryConfig().setLocation(NRepositoryLocation.of("maven@https://maven.oracle.com"))), new String[0]);
        this.reg(new NAddRepositoryOptions().setName("google").setFailSafe(false).setCreate(true).setOrder(10000).setConfig(new NRepositoryConfig().setLocation(NRepositoryLocation.of("maven@https://maven.google.com"))), new String[0]);
        this.reg(new NAddRepositoryOptions().setName("spring").setFailSafe(false).setCreate(true).setOrder(10000).setConfig(new NRepositoryConfig().setLocation(NRepositoryLocation.of("maven@https://repo.spring.io/release"))), "spring-framework");
        this.reg(new NAddRepositoryOptions().setName("vpc-public-maven").setFailSafe(false).setCreate(true).setOrder(10000).setConfig(new NRepositoryConfig().setLocation(NRepositoryLocation.of("maven@dotfilefs+https://raw.githubusercontent.com/thevpc/vpc-public-maven/master"))), "maven-thevpc-git");
        this.reg(new NAddRepositoryOptions().setName("nuts-public").setFailSafe(false).setCreate(true).setOrder(10000).setConfig(new NRepositoryConfig().setLocation(NRepositoryLocation.of("nuts@dotfilefs+https://raw.githubusercontent.com/thevpc/nuts-public/master"))), "vpc-public-nuts", "nuts-thevpc-git");
        this.reg(new NAddRepositoryOptions().setName("nuts-preview").setFailSafe(false).setCreate(true).setOrder(10000).setConfig(new NRepositoryConfig().setLocation(NRepositoryLocation.of("nuts@dotfilefs+https://raw.githubusercontent.com/thevpc/nuts-preview/master")).setTags(new String[]{"preview"})), "preview");
        this.reg(new NAddRepositoryOptions().setName("thevpc").setFailSafe(false).setCreate(true).setOrder(10000).setConfig(new NRepositoryConfig().setLocation(NRepositoryLocation.of("maven@htmlfs+https://maven.thevpc.net")).setTags(new String[]{"preview"})), "dev");
        this.reg(new NAddRepositoryOptions().setName("thevpc-goodies").setFailSafe(false).setCreate(true).setOrder(10000).setConfig(new NRepositoryConfig().setLocation(NRepositoryLocation.of("maven@htmlfs+https://maven-goodies.thevpc.net"))), "thevpc-goodies", "goodies");
        this.reg(new NAddRepositoryOptions().setName("local").setDeployWeight(10).setFailSafe(false).setCreate(true).setConfig(new NRepositoryConfig().setLocation(NRepositoryLocation.of("nuts@local"))), new String[0]);
        this.reg(new NAddRepositoryOptions().setName("maven-local").setFailSafe(false).setCreate(true).setOrder(1000).setConfig(new NRepositoryConfig().setLocation(NRepositoryLocation.of("maven@" + NPath.ofUserHome().resolve(".m2/repository").toString()))), ".m2", "m2");
    }

    @Override
    public Set<String> findAllNamesByName(String name) {
        return this.optionByName.keySetWithAlias(name);
    }

    @Override
    public NOptional<NAddRepositoryOptions> getRepositoryOptionsByName(String name) {
        return NOptional.of(this.optionByName.get(name), () -> NMsg.ofC("repository %s", name)).map(NAddRepositoryOptions::copy);
    }

    @Override
    public NOptional<NAddRepositoryOptions> getRepositoryOptionsByLocation(String name) {
        return NOptional.of(this.optionByLocation.get(name), () -> NMsg.ofC("repository %s", name)).map(NAddRepositoryOptions::copy);
    }

    private void reg(NAddRepositoryOptions options, String ... aliases) {
        String name = options.getName();
        String location = options.getConfig().getLocation().toString();
        this.optionByName.put(name, options);
        for (String alias : aliases) {
            this.optionByName.alias(alias, name);
        }
        this.optionByLocation.put(location, options);
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }
}

