/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.thevpc.nuts.core.NAddRepositoryOptions;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NRepositoryConfig;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.runtime.standalone.repository.NRepositorySelectorHelper;
import net.thevpc.nuts.runtime.standalone.repository.impl.nuts.NFolderRepository;
import net.thevpc.nuts.runtime.standalone.repository.impl.nuts.NHttpSrvRepository;
import net.thevpc.nuts.runtime.standalone.repository.util.NRepositoryUtils;
import net.thevpc.nuts.spi.NComponentScope;
import net.thevpc.nuts.spi.NRepositoryDB;
import net.thevpc.nuts.spi.NRepositoryFactoryComponent;
import net.thevpc.nuts.spi.NRepositoryLocation;
import net.thevpc.nuts.spi.NScopeType;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NScorableContext;

@NComponentScope(value=NScopeType.WORKSPACE)
public class DefaultNRepoFactoryComponent
implements NRepositoryFactoryComponent {
    @Override
    public int getScore(NScorableContext criteria) {
        if (criteria == null) {
            return -1;
        }
        NRepositoryConfig r = criteria.getCriteria(NRepositoryConfig.class);
        if (r != null) {
            String type = NRepositoryUtils.getRepoType(r);
            if ("nuts".equals(type)) {
                return 20;
            }
            if (NBlankable.isBlank(type)) {
                NPath rp = NPath.of(r.getLocation().getPath()).resolve("nuts-repository.json");
                if (rp.exists()) {
                    r.setLocation(r.getLocation().setLocationType("nuts"));
                    return 20;
                }
                return 12;
            }
        }
        return -1;
    }

    @Override
    public List<NAddRepositoryOptions> getDefaultRepositories() {
        ArrayList<NAddRepositoryOptions> all = new ArrayList<NAddRepositoryOptions>();
        NSession session = NSession.of();
        if (!NWorkspace.of().isSystemWorkspace()) {
            all.add(NRepositorySelectorHelper.createRepositoryOptions(NRepositoryLocation.of("system", NRepositoryDB.of()).get(), true));
        }
        all.add(NRepositorySelectorHelper.createRepositoryOptions(NRepositoryLocation.of("nuts-public", NRepositoryDB.of()).get(), true));
        if (session.isPreviewRepo()) {
            all.add(NRepositorySelectorHelper.createRepositoryOptions(NRepositoryLocation.of("preview", NRepositoryDB.of()).get(), true));
            all.add(NRepositorySelectorHelper.createRepositoryOptions(NRepositoryLocation.of("dev", NRepositoryDB.of()).get(), true));
        }
        return all;
    }

    @Override
    public NRepository create(NAddRepositoryOptions options, NRepository parentRepository) {
        NRepositoryConfig config = options.getConfig();
        String type = NRepositoryUtils.getRepoType(config);
        if (NBlankable.isBlank(type)) {
            return null;
        }
        if ("nuts".equals(type)) {
            if (NBlankable.isBlank(config.getLocation()) || NPath.of(config.getLocation().getPath()).isLocal()) {
                return new NFolderRepository(options, parentRepository);
            }
            if (NPath.of(config.getLocation().getPath()).isURL()) {
                Map<String, String> e = config.getEnv();
                if (e != null && NLiteral.of(e.get("nuts-api-server")).asBoolean().orElse(false).booleanValue()) {
                    return new NHttpSrvRepository(options, parentRepository);
                }
                return new NFolderRepository(options, parentRepository);
            }
        }
        return null;
    }
}

