/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.reflect.mapper;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.thevpc.nuts.reflect.NReflectMapperContext;
import net.thevpc.nuts.reflect.NReflectType;
import net.thevpc.nuts.reflect.NReflectTypeMapper;
import net.thevpc.nuts.runtime.standalone.reflect.mapper.TypeHelper;
import net.thevpc.nuts.util.NRef;

class DataObjectTypeMapper
implements NReflectTypeMapper {
    private final Class from;
    private final Type to;
    private final List<FieldToFieldMapper> fieldMappers = new ArrayList<FieldToFieldMapper>();

    public DataObjectTypeMapper(Class from, Type to) {
        this.from = from;
        this.to = to;
        LinkedHashMap<String, TypeHelper.GenericField> fromFields = new LinkedHashMap<String, TypeHelper.GenericField>();
        LinkedHashMap<String, TypeHelper.GenericField> toFields = new LinkedHashMap<String, TypeHelper.GenericField>();
        this.resolveFields(from, fromFields);
        this.resolveFields(to, toFields);
        for (Map.Entry ff : fromFields.entrySet()) {
            TypeHelper.GenericField n = (TypeHelper.GenericField)toFields.get(ff.getKey());
            if (n == null) continue;
            this.fieldMappers.add(new FieldToFieldMapper(((TypeHelper.GenericField)ff.getValue()).getField(), n));
        }
    }

    @Override
    public boolean copy(Object o, Object o2, NReflectMapperContext context) {
        boolean changed = false;
        for (FieldToFieldMapper fieldMapper : this.fieldMappers) {
            boolean map;
            try {
                map = fieldMapper.map(o, o2, context);
            }
            catch (RuntimeException ex) {
                throw new IllegalArgumentException("invalid mapping :  " + fieldMapper.from + " to " + fieldMapper.to, ex);
            }
            if (!map) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public Object mapToType(Object o, NReflectType fromType, NReflectType toType, NReflectMapperContext context) {
        Object c = context.repository().getType(this.to).newInstance();
        this.copy(o, c, context);
        return c;
    }

    private void resolveFields(Type c, Map<String, TypeHelper.GenericField> all) {
        if (c != null) {
            for (TypeHelper.GenericField genericField : TypeHelper.getDeclaredFields(c)) {
                int m = genericField.getModifiers();
                String fieldName = genericField.getName();
                if (Modifier.isStatic(m) || Modifier.isFinal(m) || all.containsKey(fieldName)) continue;
                all.put(fieldName, genericField);
            }
            Type s = TypeHelper.getGenericSuperclass(c);
            if (s != null) {
                this.resolveFields(s, all);
            }
        }
    }

    private static class FieldToFieldMapper {
        private final Field from;
        private final TypeHelper.GenericField to;
        private final Type toType;

        public FieldToFieldMapper(Field from, TypeHelper.GenericField to) {
            this.from = from;
            this.to = to;
            from.setAccessible(true);
            to.getField().setAccessible(true);
            this.toType = to.getType();
        }

        public boolean map(Object a, Object b, NReflectMapperContext context) {
            try {
                Object nv2;
                NRef<Object> srcVal = null;
                NRef<Object> targetVal = null;
                switch (context.mapStrategy().source()) {
                    case NULL: {
                        srcVal = NRef.of(this.from.get(a));
                        if (srcVal.isNull()) break;
                        return false;
                    }
                    case NON_NULL: {
                        srcVal = NRef.of(this.from.get(a));
                        if (!srcVal.isNull()) break;
                        return false;
                    }
                    case BLANK: {
                        srcVal = NRef.of(this.from.get(a));
                        if (srcVal.isBlank()) break;
                        return false;
                    }
                    case NON_BLANK: {
                        srcVal = NRef.of(this.from.get(a));
                        if (!srcVal.isBlank()) break;
                        return false;
                    }
                }
                switch (context.mapStrategy().target()) {
                    case NULL: {
                        targetVal = NRef.of(this.to.getField().get(b));
                        if (targetVal.isNull()) break;
                        return false;
                    }
                    case NON_NULL: {
                        targetVal = NRef.of(this.to.getField().get(b));
                        if (!targetVal.isNull()) break;
                        return false;
                    }
                    case BLANK: {
                        targetVal = NRef.of(this.to.getField().get(b));
                        if (targetVal.isBlank()) break;
                        return false;
                    }
                    case NON_BLANK: {
                        targetVal = NRef.of(this.to.getField().get(b));
                        if (!targetVal.isBlank()) break;
                        return false;
                    }
                }
                Object v = srcVal == null ? this.from.get(a) : srcVal.get();
                Object v2 = context.mapToType(v, context.repository().getType(this.toType));
                Object object = nv2 = targetVal == null ? this.to.getField().get(b) : targetVal.get();
                if (!context.equalizer().equals(nv2, v2)) {
                    if (v2 == null) {
                        switch (this.to.getType().getTypeName()) {
                            case "boolean": {
                                v2 = false;
                            }
                        }
                    }
                    this.to.getField().set(b, v2);
                    return true;
                }
                return false;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

