/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.reflect.mapper;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.thevpc.nuts.reflect.NReflectMapperContext;
import net.thevpc.nuts.reflect.NReflectType;
import net.thevpc.nuts.reflect.NReflectTypeMapper;
import net.thevpc.nuts.runtime.standalone.reflect.mapper.TypeHelper;

class ArrayToCollectionTypeMapper
implements NReflectTypeMapper {
    private final Type to;
    private final Type componentType;

    public ArrayToCollectionTypeMapper(Type to) {
        this.to = to;
        this.componentType = TypeHelper.asTypeArgs(to, Collection.class).get()[0];
    }

    @Override
    public boolean copy(Object fromObj, Object toObj, NReflectMapperContext context) {
        Collection toColl = (Collection)toObj;
        ArrayList<Object> ll = new ArrayList<Object>();
        int len = Array.getLength(fromObj);
        for (int i = 0; i < len; ++i) {
            ll.add(Array.get(fromObj, i));
        }
        return ArrayToCollectionTypeMapper.copyCollection(ll, toColl, context, this.componentType);
    }

    public static boolean copyCollection(List<Object> fromObj, Collection<Object> toObj, NReflectMapperContext context, Type componentType) {
        Collection<Object> toColl = toObj;
        List toList = toColl instanceof List ? (List)toColl : new ArrayList();
        int len = fromObj.size();
        boolean changed = false;
        for (int i = 0; i < len; ++i) {
            Object nv = context.mapToType(fromObj.get(i), context.repository().getType(componentType));
            boolean checkEq = true;
            while (i >= toList.size()) {
                toList.add(null);
                changed = true;
                checkEq = false;
            }
            if (checkEq) {
                Object tv = toList.get(i);
                if (context.equalizer().equals(tv, nv)) continue;
                toList.set(i, nv);
                changed = true;
                continue;
            }
            toList.set(i, nv);
        }
        if (toList != toColl) {
            toColl.clear();
            toColl.addAll(toList);
        }
        return changed;
    }

    @Override
    public Object mapToType(Object o, NReflectType fromType, NReflectType toType, NReflectMapperContext context) {
        Collection c = (Collection)context.repository().getType(this.to).newInstance();
        this.copy(o, c, context);
        return c;
    }
}

