/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.reflect.mapper;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import net.thevpc.nuts.reflect.NReflectMapperContext;
import net.thevpc.nuts.reflect.NReflectType;
import net.thevpc.nuts.reflect.NReflectTypeMapper;
import net.thevpc.nuts.runtime.standalone.reflect.mapper.TypeHelper;

class ArrayToArrayTypeMapper
implements NReflectTypeMapper {
    private final Type to;
    private final Type componentType;
    private final Class componentTypeRaw;

    public ArrayToArrayTypeMapper(Type to) {
        this.to = to;
        if (to instanceof GenericArrayType) {
            this.componentType = ((GenericArrayType)to).getGenericComponentType();
        } else if (to instanceof Class) {
            this.componentType = ((Class)to).getComponentType();
        } else {
            throw new IllegalArgumentException("Unsupported");
        }
        this.componentTypeRaw = TypeHelper.rawClass(this.componentType).get();
    }

    @Override
    public boolean copy(Object o, Object o2, NReflectMapperContext context) {
        int len = Array.getLength(o);
        boolean changed = false;
        for (int i = 0; i < len; ++i) {
            Object ov = Array.get(o2, i);
            Object nv = context.mapToType(Array.get(o, i), context.repository().getType(this.componentType));
            if (context.equalizer().equals(ov, nv)) continue;
            Array.set(o2, i, nv);
            changed = true;
        }
        return changed;
    }

    @Override
    public Object mapToType(Object o, NReflectType fromType, NReflectType toType, NReflectMapperContext context) {
        int len = Array.getLength(o);
        Object o2 = Array.newInstance(this.componentTypeRaw, len);
        this.copy(o, o2, context);
        return o2;
    }
}

