/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.reflect;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import net.thevpc.nuts.reflect.NReflectMapper;
import net.thevpc.nuts.reflect.NReflectMapperContext;
import net.thevpc.nuts.reflect.NReflectRepository;
import net.thevpc.nuts.reflect.NReflectType;
import net.thevpc.nuts.runtime.standalone.reflect.mapper.NReflectMapperContextImpl;
import net.thevpc.nuts.runtime.standalone.reflect.mapper.TypeMapperRepositoryDef;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NStringUtils;

public class NReflectMapperImpl
implements NReflectMapper {
    public static final NReflectMapper.Converter IDENTITY_CONVERTER = new NReflectMapper.Converter(){

        @Override
        public Object convert(Object value, String path, NReflectType fromType, NReflectType toType, NReflectMapperContext context) {
            return value;
        }
    };
    private NReflectRepository reflectRepository;
    public static final TypeMapperRepositoryDef globalMapperRepositoryDef = new TypeMapperRepositoryDef(null);

    @Override
    public NReflectRepository getReflectRepository() {
        return this.reflectRepository;
    }

    @Override
    public NReflectMapper setReflectRepository(NReflectRepository reflectRepository) {
        this.reflectRepository = reflectRepository;
        return this;
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }

    public <A, B> B mapToType(A a, Class<B> b) {
        return (B)this.createContext().mapToType(a, this.reflectRepository.getType(b));
    }

    public NReflectMapperContext createContext() {
        return new NReflectMapperContextImpl(this, this.reflectRepository, new TypeMapperRepositoryDef(globalMapperRepositoryDef));
    }

    @Override
    public Object mapToType(Object from, Type to) {
        return this.mapToType(from, this.reflectRepository.getType(to));
    }

    @Override
    public Object mapToType(Object from, NReflectType to) {
        if (from == null) {
            return to.getDefaultValue();
        }
        NReflectMapperContext ctx = this.createContext();
        return ctx.mapToType(from, to);
    }

    @Override
    public boolean copy(Object from, Object to) {
        if (from == null || to == null) {
            return false;
        }
        NReflectMapperContext ctx = this.createContext();
        return ctx.copy(from, to);
    }

    public static class SPath {
        public String[] elems;

        public static SPath parse(String elem) {
            return new SPath(NStringUtils.split(elem, ".", true, true).toArray(new String[0]));
        }

        public SPath(String[] elems) {
            this.elems = elems;
            if (elems.length < 1) {
                throw new IllegalArgumentException("empty array");
            }
        }

        public SPath parent() {
            if (this.elems.length == 1) {
                return null;
            }
            return new SPath(Arrays.copyOfRange(this.elems, 0, this.elems.length - 1));
        }

        public SPath resolve(String other) {
            String[] a = new String[this.elems.length + 1];
            System.arraycopy(a, 0, a, 0, this.elems.length);
            a[this.elems.length] = other;
            return new SPath(a);
        }

        public String toString() {
            return String.join((CharSequence)".", this.elems);
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SPath sPath = (SPath)o;
            return Objects.deepEquals(this.elems, sPath.elems);
        }

        public int hashCode() {
            return Arrays.hashCode(this.elems);
        }

        public String name() {
            return this.elems[this.elems.length - 1];
        }

        public SPath resolve(SPath path) {
            ArrayList<String> all = new ArrayList<String>(this.elems.length + path.elems.length);
            all.addAll(Arrays.asList(this.elems));
            all.addAll(Arrays.asList(path.elems));
            return new SPath(all.toArray(new String[0]));
        }

        public SPath skipFirst() {
            if (this.elems.length == 1) {
                return null;
            }
            return new SPath(Arrays.copyOfRange(this.elems, 1, this.elems.length));
        }
    }

    public static class TypeConverterKey {
        private NReflectType fromType;
        private NReflectType toType;

        public TypeConverterKey(NReflectType fromType, NReflectType toType) {
            this.fromType = fromType;
            this.toType = toType;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypeConverterKey that = (TypeConverterKey)o;
            return Objects.equals(this.fromType, that.fromType) && Objects.equals(this.toType, that.toType);
        }

        public int hashCode() {
            return Objects.hash(this.fromType, this.toType);
        }
    }
}

