/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import net.thevpc.nuts.reflect.NReflectPropertyDefaultValueStrategy;
import net.thevpc.nuts.reflect.NReflectType;
import net.thevpc.nuts.runtime.standalone.reflect.AbstractReflectProperty;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NExceptions;

public class FieldReflectProperty
extends AbstractReflectProperty {
    private Field field;
    private boolean accessible;

    public FieldReflectProperty(Field field, Object cleanInstance, NReflectType declaringType, NReflectPropertyDefaultValueStrategy defaultValueStrategy) {
        if (field != null) {
            this.field = field;
            try {
                field.setAccessible(true);
                this.accessible = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.init(field.getName(), declaringType, cleanInstance, field.getGenericType(), defaultValueStrategy);
        }
    }

    @Override
    public boolean isRead() {
        return this.accessible;
    }

    @Override
    public boolean isWrite() {
        return this.accessible && !Modifier.isFinal(this.field.getModifiers());
    }

    @Override
    public Object read(Object instance) {
        try {
            return this.field.get(instance);
        }
        catch (IllegalAccessException ex) {
            throw NExceptions.ofSafeIllegalArgumentException(NMsg.ofC("illegal-access (%s) %s", this.toString(), NExceptions.getErrorMessage(ex)), ex);
        }
    }

    @Override
    public void write(Object instance, Object value) {
        try {
            this.field.set(instance, value);
        }
        catch (IllegalAccessException ex) {
            throw NExceptions.ofSafeIllegalArgumentException(NMsg.ofC("illegal-access (%s) %s", this.toString(), NExceptions.getErrorMessage(ex)), ex);
        }
        catch (IllegalArgumentException ex) {
            throw ex;
        }
    }
}

