/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.thevpc.nuts.reflect.NReflectMethod;
import net.thevpc.nuts.reflect.NReflectProperty;
import net.thevpc.nuts.reflect.NReflectPropertyAccessStrategy;
import net.thevpc.nuts.reflect.NReflectPropertyDefaultValueStrategy;
import net.thevpc.nuts.reflect.NReflectRepository;
import net.thevpc.nuts.reflect.NReflectType;
import net.thevpc.nuts.reflect.NReflectUtils;
import net.thevpc.nuts.reflect.NSignature;
import net.thevpc.nuts.runtime.standalone.reflect.DefaultNReflectMethod;
import net.thevpc.nuts.runtime.standalone.reflect.FieldReflectProperty;
import net.thevpc.nuts.runtime.standalone.reflect.MethodReflectProperty1;
import net.thevpc.nuts.runtime.standalone.reflect.MethodReflectProperty2;
import net.thevpc.nuts.runtime.standalone.reflect.MethodReflectProperty3;
import net.thevpc.nuts.runtime.standalone.reflect.ReflectUtils;
import net.thevpc.nuts.runtime.standalone.reflect.SimpleGenericArrayType;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NArrays;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NOptional;

public class DefaultNReflectType
implements NReflectType {
    private static final Pattern GETTER_SETTER = Pattern.compile("(?<prefix>(get|set|is))(?<suffix>([A-Z].*))");
    private Type javaType;
    private Map<String, NReflectProperty> propertiesDeclaredMap;
    private List<NReflectProperty> propertiesDeclaredList;
    private Map<String, NReflectProperty> propertiesAllMap;
    private List<NReflectProperty> propertiesAllList;
    private Map<String, NReflectMethod> methodsDeclaredMap;
    private List<NReflectMethod> methodsDeclaredList;
    private Map<String, NReflectMethod> methodsAllMap;
    private List<NReflectMethod> methodsAllList;
    private NReflectRepository repo;
    private NReflectPropertyAccessStrategy propertyAccessStrategy;
    private NReflectPropertyDefaultValueStrategy propertyDefaultValueStrategy;
    private ConstrHolder constrType;
    private ConstrHolder noArgConstr;
    private ConstrHolder specialConstr;

    public DefaultNReflectType(Type javaType, NReflectRepository repo) {
        this.javaType = javaType;
        this.repo = repo;
        Class<?> c2 = this.asJavaClass().orNull();
        this.propertyAccessStrategy = c2 == null ? NReflectPropertyAccessStrategy.FIELD : this.repo.getConfiguration().getAccessStrategy(c2);
        this.propertyDefaultValueStrategy = c2 == null ? NReflectPropertyDefaultValueStrategy.TYPE_DEFAULT : this.repo.getConfiguration().getDefaultValueStrategy(c2);
    }

    @Override
    public NReflectPropertyAccessStrategy getAccessStrategy() {
        return this.propertyAccessStrategy;
    }

    @Override
    public NReflectPropertyDefaultValueStrategy getDefaultValueStrategy() {
        return this.propertyDefaultValueStrategy;
    }

    @Override
    public List<NReflectProperty> getDeclaredProperties() {
        this.build();
        return this.propertiesDeclaredList;
    }

    @Override
    public String getName() {
        return this.javaType.getTypeName();
    }

    @Override
    public List<NReflectProperty> getProperties() {
        this.build();
        return this.propertiesAllList;
    }

    @Override
    public NOptional<NReflectProperty> getProperty(String name) {
        this.build();
        return NOptional.ofNamed(this.propertiesAllMap.get(name), "property " + this.getName() + "::" + name);
    }

    @Override
    public NOptional<NReflectProperty> getDeclaredProperty(String name) {
        return NOptional.ofNamed(this.propertiesDeclaredMap.get(name), "property " + name);
    }

    private Supplier<Object> resolveNoArgsConstr() {
        if (this.noArgConstr == null) {
            int m;
            Supplier<Object> instanceSupplier = null;
            Class<?> jc = this.asJavaClass().orNull();
            if (jc != null && !jc.isInterface() && !Modifier.isAbstract(m = jc.getModifiers())) {
                try {
                    Constructor<?> sessionConstr0 = jc.getDeclaredConstructor(new Class[0]);
                    sessionConstr0.setAccessible(true);
                    instanceSupplier = () -> {
                        try {
                            return sessionConstr0.newInstance(new Object[0]);
                        }
                        catch (Exception ex) {
                            throw this.asRuntimeException(ex);
                        }
                    };
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.noArgConstr = new ConstrHolder(ConstrType.DEFAULT, instanceSupplier);
        }
        return this.noArgConstr.supplier;
    }

    @Override
    public NOptional<Class<?>> asJavaClass() {
        Class c2 = this.javaType instanceof Class ? (Class)this.javaType : ReflectUtils.getRawClass(this.javaType);
        return NOptional.of(c2);
    }

    private Supplier<Object> resolveSpecialConstr() {
        if (this.specialConstr == null) {
            Supplier<Object> sessionConstr1 = null;
            Class c2 = null;
            c2 = this.javaType instanceof Class ? (Class)this.javaType : ReflectUtils.getRawClass(this.javaType);
            if (c2 != null && c2.isInterface()) {
                if (List.class.equals((Object)c2)) {
                    sessionConstr1 = () -> new ArrayList();
                } else if (Set.class.equals((Object)c2)) {
                    sessionConstr1 = () -> new HashSet();
                } else if (Collection.class.equals((Object)c2)) {
                    sessionConstr1 = () -> new ArrayList();
                } else if (Map.class.equals((Object)c2)) {
                    sessionConstr1 = () -> new LinkedHashMap();
                }
            }
            this.specialConstr = new ConstrHolder(ConstrType.SPECIAL, sessionConstr1);
        }
        return this.specialConstr.supplier;
    }

    private ConstrType getConstrType() {
        if (this.constrType == null) {
            Supplier<Object> s = this.resolveNoArgsConstr();
            if (s != null) {
                this.constrType = this.noArgConstr;
                return this.constrType.type;
            }
            s = this.resolveSpecialConstr();
            if (s != null) {
                this.constrType = this.specialConstr;
                return this.constrType.type;
            }
            this.constrType = new ConstrHolder(ConstrType.ERROR, null);
        }
        return this.constrType.type;
    }

    @Override
    public boolean isAssignableFrom(NReflectType type) {
        if (this.javaType instanceof Class && type instanceof DefaultNReflectType) {
            DefaultNReflectType d = (DefaultNReflectType)type;
            if (d.javaType instanceof Class) {
                return ((Class)this.javaType).isAssignableFrom((Class)d.javaType);
            }
        }
        return false;
    }

    @Override
    public boolean hasNoArgsConstructor() {
        return this.resolveNoArgsConstr() != null;
    }

    @Override
    public boolean hasSpecialConstructor() {
        return this.resolveSpecialConstr() != null;
    }

    private RuntimeException asRuntimeException(Throwable e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        if (e instanceof InstantiationException || e instanceof InvocationTargetException) {
            Throwable c = e.getCause();
            if (c instanceof RuntimeException) {
                return (RuntimeException)c;
            }
            return new IllegalArgumentException(c);
        }
        return new IllegalArgumentException(e);
    }

    @Override
    public NReflectType getRawType() {
        if (this.javaType instanceof ParameterizedType) {
            return this.repo.getType(((ParameterizedType)this.javaType).getRawType());
        }
        return null;
    }

    @Override
    public Object newInstance() {
        if (this.getConstrType() == ConstrType.ERROR) {
            throw new NIllegalArgumentException(NMsg.ofC("not instantiable %s", this.javaType));
        }
        return this.constrType.supplier.get();
    }

    @Override
    public NReflectType getSuperType() {
        if (this.javaType instanceof Class) {
            Type superclass = ((Class)this.javaType).getGenericSuperclass();
            return superclass == null ? null : this.repo.getType(superclass);
        }
        if (this.javaType instanceof ParameterizedType) {
            Type rt = ((ParameterizedType)this.javaType).getRawType();
            return this.repo.getType(rt).replaceVars(x -> this.getActualTypeArgument((NReflectType)x).orElse((NReflectType)x));
        }
        return null;
    }

    private void build() {
        if (this.propertiesDeclaredMap == null) {
            Object cleanInstance = null;
            try {
                cleanInstance = this.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
            LinkedHashMap<String, IndexedItem<NReflectMethod>> declaredMethods = new LinkedHashMap<String, IndexedItem<NReflectMethod>>();
            LinkedHashMap<String, IndexedItem<NReflectMethod>> allMethods = new LinkedHashMap<String, IndexedItem<NReflectMethod>>();
            LinkedHashMap<String, IndexedItem<NReflectProperty>> declaredProperties = new LinkedHashMap<String, IndexedItem<NReflectProperty>>();
            LinkedHashMap<String, IndexedItem<NReflectProperty>> allProperties = new LinkedHashMap<String, IndexedItem<NReflectProperty>>();
            HashSet<String> ambiguousWrites = new HashSet<String>();
            int hierarchyIndex = 0;
            this.fillProperties(hierarchyIndex, this.javaType, declaredProperties, cleanInstance, ambiguousWrites, this.propertyAccessStrategy, this.propertyDefaultValueStrategy);
            allProperties.putAll(declaredProperties);
            this.fillMethods(hierarchyIndex, this.javaType, declaredMethods, cleanInstance);
            allMethods.putAll(declaredMethods);
            for (NReflectType parent = this.getSuperType(); parent != null; parent = parent.getSuperType()) {
                ++hierarchyIndex;
                for (NReflectProperty property : parent.getProperties()) {
                    if (allProperties.containsKey(property.getName())) continue;
                    allProperties.put(property.getName(), new IndexedItem<NReflectProperty>(hierarchyIndex, property));
                }
                for (NReflectMethod m : parent.getDeclaredMethods()) {
                    String sig = this.normalizeSig(m.getName(), m.getSignature());
                    if (allMethods.containsKey(sig)) continue;
                    allMethods.put(sig, new IndexedItem<NReflectMethod>(hierarchyIndex, m));
                }
            }
            this.propertiesDeclaredMap = this.reorderProperties(declaredProperties);
            this.propertiesAllMap = this.reorderProperties(allProperties);
            this.propertiesDeclaredList = Collections.unmodifiableList(new ArrayList<NReflectProperty>(this.propertiesDeclaredMap.values()));
            this.propertiesAllList = Collections.unmodifiableList(new ArrayList<NReflectProperty>(this.propertiesAllMap.values()));
            this.methodsDeclaredMap = this.reorderMethods(declaredMethods);
            this.methodsAllMap = this.reorderMethods(allMethods);
            this.methodsDeclaredList = Collections.unmodifiableList(new ArrayList<NReflectMethod>(this.methodsDeclaredMap.values()));
            this.methodsAllList = Collections.unmodifiableList(new ArrayList<NReflectMethod>(this.methodsAllMap.values()));
        }
    }

    @Override
    public List<NReflectMethod> getMethods() {
        this.build();
        return Collections.unmodifiableList(this.methodsAllList);
    }

    @Override
    public NOptional<NReflectMethod> getMethod(String name, NSignature signature) {
        if (NBlankable.isBlank(name)) {
            return NOptional.ofNamedEmpty(signature.toString());
        }
        this.build();
        NReflectMethod value = this.methodsAllMap.get(this.normalizeSig(name, signature));
        if (value != null) {
            return NOptional.of(value);
        }
        return NOptional.ofNamedEmpty(signature.toString());
    }

    private String normalizeSig(String name, NSignature signature) {
        return name + signature.setVararg(false).toString();
    }

    @Override
    public List<NReflectMethod> getMatchingMethods(String name, NSignature signature) {
        NOptional<NReflectMethod> m = this.getMethod(name, signature);
        if (m.isPresent()) {
            return Arrays.asList(m.get());
        }
        return Collections.emptyList();
    }

    @Override
    public NOptional<NReflectMethod> getMatchingMethod(String name, NSignature signature) {
        return this.getMethod(name, signature);
    }

    @Override
    public List<NReflectMethod> getDeclaredMethods() {
        return Collections.unmodifiableList(this.methodsDeclaredList);
    }

    private void fillMethods(int hierarchyIndex, Type javaType, LinkedHashMap<String, IndexedItem<NReflectMethod>> declaredMethods, Object cleanInstance) {
        Method[] declaredMethods2;
        for (Method m : declaredMethods2 = DefaultNReflectType._getMethods(javaType)) {
            DefaultNReflectMethod rm = new DefaultNReflectMethod(m, this);
            declaredMethods.put(this.normalizeSig(m.getName(), rm.getSignature()), new IndexedItem<DefaultNReflectMethod>(hierarchyIndex, rm));
        }
    }

    private LinkedHashMap<String, NReflectProperty> reorderProperties(LinkedHashMap<String, IndexedItem<NReflectProperty>> fieldAllProperties) {
        Map.Entry[] ee = fieldAllProperties.entrySet().toArray(new Map.Entry[0]);
        Arrays.sort(ee, (o1, o2) -> Integer.compare(((IndexedItem)o2.getValue()).index, ((IndexedItem)o1.getValue()).index));
        LinkedHashMap<String, NReflectProperty> r = new LinkedHashMap<String, NReflectProperty>();
        for (Map.Entry entry : ee) {
            r.put((String)entry.getKey(), (NReflectProperty)((IndexedItem)entry.getValue()).item);
        }
        return r;
    }

    private LinkedHashMap<String, NReflectMethod> reorderMethods(LinkedHashMap<String, IndexedItem<NReflectMethod>> fieldAllProperties) {
        Map.Entry[] ee = fieldAllProperties.entrySet().toArray(new Map.Entry[0]);
        Arrays.sort(ee, (o1, o2) -> Integer.compare(((IndexedItem)o2.getValue()).index, ((IndexedItem)o1.getValue()).index));
        LinkedHashMap<String, NReflectMethod> r = new LinkedHashMap<String, NReflectMethod>();
        for (Map.Entry entry : ee) {
            r.put((String)entry.getKey(), (NReflectMethod)((IndexedItem)entry.getValue()).item);
        }
        return r;
    }

    private void fillProperties(int hierarchyIndex, Type clazz, LinkedHashMap<String, IndexedItem<NReflectProperty>> declaredProperties, Object cleanInstance, Set<String> ambiguousWrites, NReflectPropertyAccessStrategy propertyAccessStrategy, NReflectPropertyDefaultValueStrategy propertyDefaultValueStrategy) {
        if (propertyAccessStrategy == NReflectPropertyAccessStrategy.METHOD || propertyAccessStrategy == NReflectPropertyAccessStrategy.BOTH) {
            LinkedHashMap<Object, Method> methodGetters = new LinkedHashMap<Object, Method>();
            LinkedHashMap<Object, ArrayList<Method>> methodSetters = new LinkedHashMap<Object, ArrayList<Method>>();
            Method[] declaredMethods = DefaultNReflectType._getMethods(clazz);
            block12: for (Method m : declaredMethods) {
                String name;
                Matcher matcher;
                if (m.isSynthetic() || Modifier.isAbstract(m.getModifiers()) || Modifier.isStatic(m.getModifiers()) || !(matcher = GETTER_SETTER.matcher(name = m.getName())).find()) continue;
                char[] n2c = matcher.group("suffix").toCharArray();
                n2c[0] = Character.toLowerCase(n2c[0]);
                String n2 = new String(n2c);
                switch (matcher.group("prefix")) {
                    case "get": {
                        if (m.getParameterCount() != 0 || m.getReturnType().equals(Void.TYPE) || name.equals("getClass")) continue block12;
                        methodGetters.put(n2, m);
                        continue block12;
                    }
                    case "is": {
                        if (m.getParameterCount() != 0 || !m.getReturnType().equals(Boolean.TYPE) && !m.getReturnType().equals(Boolean.class)) continue block12;
                        methodGetters.put(n2, m);
                        continue block12;
                    }
                    case "set": {
                        if (m.getParameterCount() != 1) continue block12;
                        ArrayList<Method> li = (ArrayList<Method>)methodSetters.get(n2);
                        if (li == null) {
                            li = new ArrayList<Method>();
                            methodSetters.put(n2, li);
                        }
                        li.add(m);
                    }
                }
            }
            for (Map.Entry entry : methodGetters.entrySet()) {
                String propName = (String)entry.getKey();
                if (declaredProperties.containsKey(propName)) continue;
                Method readMethod = (Method)entry.getValue();
                Method writeMethod = null;
                Field writeField = null;
                List possibleSetters = (List)methodSetters.get(propName);
                if (possibleSetters != null) {
                    for (Method possibleSetter : possibleSetters) {
                        Class<?> ps = possibleSetter.getParameterTypes()[0];
                        if (!ps.equals(readMethod.getReturnType())) continue;
                        writeMethod = possibleSetter;
                        methodSetters.remove(propName);
                        break;
                    }
                }
                if (writeMethod == null && propertyAccessStrategy == NReflectPropertyAccessStrategy.BOTH) {
                    Field[] declaredFields = DefaultNReflectType._getFields(clazz);
                    for (Field f : declaredFields) {
                        if (Modifier.isStatic(f.getModifiers()) || Modifier.isTransient(f.getModifiers()) || declaredProperties.containsKey(f.getName()) || Modifier.isStatic(f.getModifiers()) || Modifier.isFinal(f.getModifiers()) || !f.getType().equals(readMethod.getReturnType())) continue;
                        writeField = f;
                    }
                }
                if (writeMethod != null) {
                    declaredProperties.put(propName, new IndexedItem<MethodReflectProperty1>(hierarchyIndex, new MethodReflectProperty1(propName, readMethod, writeMethod, cleanInstance, this, propertyDefaultValueStrategy)));
                    continue;
                }
                if (writeField != null) {
                    declaredProperties.put(propName, new IndexedItem<MethodReflectProperty2>(hierarchyIndex, new MethodReflectProperty2(propName, readMethod, writeField, cleanInstance, this, propertyDefaultValueStrategy)));
                    continue;
                }
                declaredProperties.put(propName, new IndexedItem<MethodReflectProperty1>(hierarchyIndex, new MethodReflectProperty1(propName, readMethod, null, cleanInstance, this, propertyDefaultValueStrategy)));
            }
            for (Map.Entry entry : methodSetters.entrySet()) {
                String propName = (String)entry.getKey();
                if (((List)entry.getValue()).size() == 1) {
                    Method writeMethod = (Method)((List)entry.getValue()).get(0);
                    if (declaredProperties.containsKey(propName)) continue;
                    Field readField = null;
                    Field[] _fields = DefaultNReflectType._getFields(clazz);
                    try {
                        readField = Arrays.stream(_fields).filter(x -> x.getName().equals(propName)).findAny().orElse(null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (readField == null || Modifier.isStatic(readField.getModifiers()) || !readField.getType().equals(writeMethod.getParameterTypes()[0])) continue;
                    declaredProperties.put(propName, new IndexedItem<MethodReflectProperty3>(hierarchyIndex, new MethodReflectProperty3(propName, readField, writeMethod, cleanInstance, this, propertyDefaultValueStrategy)));
                    continue;
                }
                if (((List)entry.getValue()).size() <= 0) continue;
                ambiguousWrites.add(propName);
            }
        }
        if (propertyAccessStrategy == NReflectPropertyAccessStrategy.FIELD || propertyAccessStrategy == NReflectPropertyAccessStrategy.BOTH) {
            Field[] declaredFields;
            for (Field field : declaredFields = DefaultNReflectType._getFields(clazz)) {
                if (declaredProperties.containsKey(field.getName()) || Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
                FieldReflectProperty p = new FieldReflectProperty(field, cleanInstance, this, propertyDefaultValueStrategy);
                declaredProperties.put(p.getName(), new IndexedItem<FieldReflectProperty>(hierarchyIndex, p));
            }
        }
    }

    private static Field[] _getFields(Type clazz) {
        Field[] declaredFields = new Field[]{};
        if (!(clazz instanceof Class)) {
            if (clazz instanceof ParameterizedType) {
                Class c2 = ReflectUtils.getRawClass(clazz);
                if (c2 != null) {
                    return c2.getDeclaredFields();
                }
                throw new IllegalArgumentException("TODO");
            }
            throw new IllegalArgumentException("TODO");
        }
        declaredFields = ((Class)clazz).getDeclaredFields();
        return declaredFields;
    }

    private static Method[] _getMethods(Type clazz) {
        Method[] declaredMethods = new Method[]{};
        if (!(clazz instanceof Class)) {
            if (clazz instanceof ParameterizedType) {
                Class c2 = ReflectUtils.getRawClass(clazz);
                if (c2 != null) {
                    return c2.getDeclaredMethods();
                }
                throw new IllegalArgumentException("TODO");
            }
            throw new IllegalArgumentException("TODO");
        }
        declaredMethods = ((Class)clazz).getDeclaredMethods();
        return declaredMethods;
    }

    private static Map<TypeVariable<?>, Type> getActualClassArguments0(Type type) {
        HashMap m = new HashMap();
        if (type instanceof ParameterizedType) {
            Type[] actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments();
            Type rawType = ((ParameterizedType)type).getRawType();
            if (rawType instanceof Class) {
                TypeVariable<Class<T>>[] typeParameters = ((Class)rawType).getTypeParameters();
                for (int i = 0; i < typeParameters.length; ++i) {
                    m.put(typeParameters[i], actualTypeArguments[i]);
                }
            }
        }
        return m;
    }

    @Override
    public boolean isParametrizedType() {
        return this.javaType instanceof ParameterizedType;
    }

    @Override
    public boolean isTypeVariable() {
        return this.javaType instanceof TypeVariable;
    }

    @Override
    public NReflectType[] getTypeParameters() {
        if (this.javaType instanceof Class) {
            return (NReflectType[])Arrays.stream(((Class)this.javaType).getTypeParameters()).map(x -> this.repo.getType((Type)x)).toArray(NReflectType[]::new);
        }
        if (this.javaType instanceof ParameterizedType) {
            return this.repo.getType(((ParameterizedType)this.javaType).getRawType()).getTypeParameters();
        }
        return new NReflectType[0];
    }

    @Override
    public NOptional<NReflectType> getActualTypeArgument(NReflectType type) {
        NReflectType[] typeParameters = this.getTypeParameters();
        NReflectType[] r = this.getActualTypeArguments();
        if (r.length == 0) {
            return NOptional.ofNamedEmpty(NMsg.ofC("actual type argument %s", type).toString());
        }
        for (int i = 0; i < typeParameters.length; ++i) {
            NReflectType typeParameter = typeParameters[i];
            if (!typeParameter.equals(type)) continue;
            return NOptional.ofNamed(r[i], NMsg.ofC("actual type argument %s", type).toString());
        }
        return NOptional.ofNamedEmpty(NMsg.ofC("actual type argument %s", type).toString());
    }

    @Override
    public NReflectType[] getActualTypeArguments() {
        if (this.isParametrizedType()) {
            return (NReflectType[])Arrays.stream(((ParameterizedType)this.javaType).getActualTypeArguments()).map(x -> this.repo.getType((Type)x)).toArray(NReflectType[]::new);
        }
        return new NReflectType[0];
    }

    @Override
    public NReflectType replaceVars(Function<NReflectType, NReflectType> mapper) {
        if (this.javaType instanceof TypeVariable) {
            NReflectType t = mapper.apply(this);
            if (t != null) {
                return t;
            }
            return this;
        }
        if (this.javaType instanceof Class) {
            return this;
        }
        if (this.javaType instanceof ParameterizedType) {
            NReflectType[] actualTypeArguments = NArrays.copyOf(this.getActualTypeArguments());
            NReflectType[] typeParameters = NArrays.copyOf(this.getTypeParameters());
            boolean someUpdates = false;
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                NReflectType aa;
                NReflectType r = typeParameters[i];
                NReflectType a = actualTypeArguments[i];
                if (!a.isTypeVariable() || (aa = a.replaceVars(mapper)) == a || aa == null) continue;
                actualTypeArguments[i] = aa;
                someUpdates = true;
            }
            if (someUpdates) {
                DefaultNReflectType ownerType = (DefaultNReflectType)this.getOwnerType();
                Type c2 = ReflectUtils.getRawClass(this.javaType);
                if (c2 == null) {
                    c2 = this.javaType;
                }
                return this.repo.getParametrizedType(c2, ownerType == null ? null : ownerType.javaType, (Type[])Arrays.stream(actualTypeArguments).map(x -> ((DefaultNReflectType)x).javaType).toArray(Type[]::new));
            }
            return this;
        }
        if (this.javaType instanceof GenericArrayType) {
            NReflectType b;
            NReflectType a = this.getComponentType();
            if (a != (b = a.replaceVars(mapper)) && b != null) {
                return b.toArray();
            }
            return this;
        }
        if (this.javaType instanceof WildcardType) {
            return this;
        }
        return this;
    }

    @Override
    public boolean isArrayType() {
        if (this.javaType instanceof GenericArrayType) {
            return true;
        }
        if (this.javaType instanceof Class) {
            return ((Class)this.javaType).isArray();
        }
        return false;
    }

    @Override
    public NOptional<NReflectType> getBoxedType() {
        if (this.javaType instanceof Class) {
            Class c = (Class)this.javaType;
            if (!c.isPrimitive()) {
                return NOptional.of(this);
            }
            NOptional<Class<?>> b = NReflectUtils.toBoxedType(c);
            return b.map(x -> this.repo.getType((Type)x));
        }
        return NOptional.ofNamedEmpty("primitive for " + this);
    }

    @Override
    public boolean isDefaultValue(Object value) {
        return ReflectUtils.isDefaultValue(this.javaType, value);
    }

    @Override
    public Object getDefaultValue() {
        Class c;
        if (this.javaType instanceof Class && (c = (Class)this.javaType).isPrimitive()) {
            return NReflectUtils.getDefaultValue(c);
        }
        return null;
    }

    @Override
    public NOptional<NReflectType> getPrimitiveType() {
        if (this.javaType instanceof Class) {
            Class c = (Class)this.javaType;
            if (c.isPrimitive()) {
                return NOptional.of(this);
            }
            NOptional<Class<?>> b = NReflectUtils.toPrimitiveType(c);
            return b.map(x -> this.repo.getType((Type)x));
        }
        return NOptional.ofNamedEmpty("primitive for " + this);
    }

    @Override
    public boolean isPrimitive() {
        if (this.javaType instanceof Class) {
            Class c = (Class)this.javaType;
            return c.isPrimitive();
        }
        return false;
    }

    @Override
    public NReflectType toArray() {
        if (this.javaType instanceof Class) {
            Class c = (Class)this.javaType;
            try {
                Class<?> c2 = Class.forName("[L" + c.getCanonicalName() + ";", false, c.getClassLoader());
                return this.repo.getType(c2);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return this.repo.getType(new SimpleGenericArrayType(this.javaType));
    }

    public NReflectType getComponentType() {
        Class clazz;
        if (this.javaType instanceof GenericArrayType) {
            return this.repo.getType(((GenericArrayType)this.javaType).getGenericComponentType());
        }
        if (this.javaType instanceof Class && (clazz = (Class)this.javaType).isArray()) {
            return this.repo.getType(clazz.getComponentType());
        }
        return null;
    }

    public NReflectType getOwnerType() {
        Type ownerType;
        if (this.javaType instanceof ParameterizedType && (ownerType = ((ParameterizedType)this.javaType).getOwnerType()) != null) {
            return this.repo.getType(ownerType);
        }
        return null;
    }

    @Override
    public NReflectRepository getRepository() {
        return this.repo;
    }

    public String toString() {
        return String.valueOf(this.javaType);
    }

    @Override
    public Type getJavaType() {
        return this.javaType;
    }

    private class ConstrHolder {
        ConstrType type;
        Supplier<Object> supplier;

        public ConstrHolder(ConstrType type, Supplier<Object> supplier) {
            this.type = type;
            this.supplier = supplier;
        }
    }

    private static enum ConstrType {
        WORKSPACE,
        SESSION,
        DEFAULT,
        SPECIAL,
        ERROR;

    }

    private static class IndexedItem<T> {
        int index;
        T item;

        public IndexedItem(int index, T item) {
            this.index = index;
            this.item = item;
        }
    }
}

