/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.reflect;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;
import net.thevpc.nuts.reflect.NReflectProperty;
import net.thevpc.nuts.reflect.NReflectPropertyDefaultValueStrategy;
import net.thevpc.nuts.reflect.NReflectType;
import net.thevpc.nuts.runtime.standalone.reflect.ReflectUtils;

public abstract class AbstractReflectProperty
implements NReflectProperty {
    private String name;
    private Object cleanInstanceValue;
    private NReflectType propertyType;
    private NReflectType declaringType;
    private NReflectPropertyDefaultValueStrategy defaultValueStrategy;

    protected final void init(String name, NReflectType declaringType, Object cleanInstance, Type propertyType, NReflectPropertyDefaultValueStrategy defaultValueStrategy) {
        this.name = name;
        this.cleanInstanceValue = cleanInstance == null ? ReflectUtils.getDefaultValue(propertyType) : (this.isRead() ? this.read(cleanInstance) : null);
        this.declaringType = declaringType;
        NReflectType nReflectType = declaringType.getRepository().getType(propertyType).replaceVars(t -> declaringType.getActualTypeArgument((NReflectType)t).orElse((NReflectType)t));
        this.defaultValueStrategy = defaultValueStrategy;
        this.propertyType = nReflectType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public NReflectType getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public NReflectType getPropertyType() {
        return this.propertyType;
    }

    @Override
    public NReflectPropertyDefaultValueStrategy getDefaultValueStrategy() {
        return this.defaultValueStrategy;
    }

    @Override
    public boolean isDefaultValue(Object value, NReflectPropertyDefaultValueStrategy strategy) {
        if (strategy == null) {
            strategy = this.getDefaultValueStrategy();
        }
        switch (strategy) {
            case NO_DEFAULT: {
                return false;
            }
            case PROPERTY_DEFAULT: {
                if (value == null) {
                    return true;
                }
                if (this.cleanInstanceValue != null && this.cleanInstanceValue.getClass().isArray()) {
                    if (Array.getLength(this.cleanInstanceValue) == 0) {
                        return value.getClass().isArray() && Array.getLength(value) == 0;
                    }
                    if (value.getClass().isArray()) {
                        Class<?> e = this.cleanInstanceValue.getClass().getComponentType();
                        Class<?> f = value.getClass().getComponentType();
                        if (e.isPrimitive()) {
                            if (f.isPrimitive() && e.equals(f)) {
                                switch (e.getName()) {
                                    case "boolean": {
                                        return Arrays.equals((boolean[])this.cleanInstanceValue, (boolean[])value);
                                    }
                                    case "byte": {
                                        return Arrays.equals((byte[])this.cleanInstanceValue, (byte[])value);
                                    }
                                    case "char": {
                                        return Arrays.equals((char[])this.cleanInstanceValue, (char[])value);
                                    }
                                    case "short": {
                                        return Arrays.equals((short[])this.cleanInstanceValue, (short[])value);
                                    }
                                    case "int": {
                                        return Arrays.equals((int[])this.cleanInstanceValue, (int[])value);
                                    }
                                    case "long": {
                                        return Arrays.equals((long[])this.cleanInstanceValue, (long[])value);
                                    }
                                    case "float": {
                                        return Arrays.equals((float[])this.cleanInstanceValue, (float[])value);
                                    }
                                    case "double": {
                                        return Arrays.equals((double[])this.cleanInstanceValue, (double[])value);
                                    }
                                }
                            }
                            return false;
                        }
                        return Arrays.deepEquals((Object[])this.cleanInstanceValue, (Object[])value);
                    }
                    return Objects.deepEquals(this.cleanInstanceValue, value);
                }
                return Objects.deepEquals(this.cleanInstanceValue, value);
            }
            case TYPE_DEFAULT: {
                return this.getPropertyType().isDefaultValue(value);
            }
        }
        return Objects.equals(this.cleanInstanceValue, value);
    }

    @Override
    public boolean isDefaultValue(Object o) {
        return this.isDefaultValue(o, null);
    }

    public String toString() {
        return String.valueOf(this.declaringType) + "." + this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractReflectProperty that = (AbstractReflectProperty)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.cleanInstanceValue, that.cleanInstanceValue) && Objects.equals(this.propertyType, that.propertyType) && Objects.equals(this.declaringType, that.declaringType) && this.defaultValueStrategy == that.defaultValueStrategy;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.cleanInstanceValue, this.propertyType, this.declaringType, this.defaultValueStrategy);
    }
}

