/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.log;

import java.util.function.Supplier;
import java.util.logging.Level;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NLogContext;
import net.thevpc.nuts.log.NLogs;
import net.thevpc.nuts.runtime.standalone.log.DefaultNLogModel;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NMsgBuilder;

class ScopedNLog
implements NLog {
    private final DefaultNLogModel model;
    private final NLog base;

    public ScopedNLog(DefaultNLogModel model, NLog base) {
        this.model = model;
        this.base = base;
    }

    @Override
    public NLog scoped() {
        return this;
    }

    @Override
    public String getName() {
        return this.base.getName();
    }

    @Override
    public boolean isLoggable(Level level) {
        NLogContext c = NLogs.of().getContext();
        NLog s = c.getLog();
        if (s != null) {
            return s.isLoggable(level);
        }
        return this.base.isLoggable(level);
    }

    @Override
    public void log(Level level, Supplier<NMsg> msgSupplier) {
        NLogContext c = NLogs.of().getContext();
        NLog s = c.getLog();
        if (s != null) {
            s.log(level, () -> this.prepareMsg((NMsg)msgSupplier.get(), c));
            return;
        }
        this.base.log(level, msgSupplier);
    }

    @Override
    public void log(NMsg msg) {
        NLogContext c = NLogs.of().getContext();
        NLog s = c.getLog();
        if (s != null) {
            s.log(msg);
            return;
        }
        this.base.log(msg);
    }

    @Override
    public void log(NMsgBuilder msg) {
        this.log(msg.build());
    }

    private NMsg prepareMsg(NMsg other, NLogContext c) {
        return other.withPrefix(c.getMessagePrefix()).withSuffix(c.getMessageSuffix()).withPlaceholders(c::getPlaceholder);
    }
}

