/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.log;

import java.time.Instant;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.thevpc.nuts.log.NLogSPI;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.time.NDuration;

public class NLogSPIJUL
implements NLogSPI {
    private final Logger log;

    public NLogSPIJUL(String name) {
        this.log = Logger.getLogger(name);
    }

    @Override
    public boolean isLoggable(Level level) {
        return this.log.isLoggable(level);
    }

    @Override
    public void log(NMsg message) {
        String[] caller = this.findCaller();
        Instant now = Instant.now();
        NMsg msg2 = NMsg.ofC("%s [%-6s] [%-7s] %s%s", now, message.getLevel(), message.getIntent(), message, message.getDurationNanos() <= 0L ? "" : NMsg.ofC(" (duration: %s)", NDuration.ofNanos(message.getDurationNanos())));
        LogRecord rec = new LogRecord(message.getLevel(), "{0}");
        rec.setMillis(now.toEpochMilli());
        rec.setThrown(message.getThrowable());
        rec.setParameters(new Object[]{msg2.toString()});
        rec.setSourceClassName(caller[0]);
        rec.setSourceMethodName(caller[1]);
        this.log.log(rec);
    }

    private String[] findCaller() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        for (int i = 3; i < stack.length; ++i) {
            StackTraceElement e = stack[i];
            String cname = e.getClassName();
            if (cname.startsWith("net.thevpc.nuts.runtime.standalone.log") || cname.startsWith("java.util.logging")) continue;
            return new String[]{cname, e.getMethodName()};
        }
        return new String[]{"unknown", "unknown"};
    }
}

