/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.log;

import java.time.Instant;
import net.thevpc.nuts.runtime.standalone.log.NLogUtils;
import net.thevpc.nuts.runtime.standalone.util.CoreNUtils;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextBuilder;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTexts;
import net.thevpc.nuts.time.NDuration;
import net.thevpc.nuts.util.NStringUtils;

public class NLogRichFormatter2 {
    private long lastMillis = -1L;

    public String format(NMsg msg, long timestamp, String sourceClassName, boolean filtered) {
        NTexts tf = NTexts.of();
        NTextBuilder sb = tf.ofBuilder();
        String date = CoreNUtils.DEFAULT_DATE_TIME_FORMATTER.format(Instant.ofEpochMilli(timestamp));
        sb.append(tf.ofStyled(date, NTextStyle.pale()));
        boolean verboseLog = false;
        if (verboseLog) {
            sb.append(" ");
            int len = date.length() + 5;
            StringBuilder sb2 = new StringBuilder(5);
            if (this.lastMillis > 0L) {
                sb2.append(String.valueOf(timestamp - this.lastMillis));
            }
            while (sb2.length() < 5) {
                sb2.append(' ');
            }
            sb.append(sb.toString());
        }
        sb.append(" ");
        switch (msg.getLevel().intValue()) {
            case 1000: {
                sb.append((Object)NLogUtils.logLevel(msg.getLevel()), NTextStyle.error());
                break;
            }
            case 900: {
                sb.append((Object)NLogUtils.logLevel(msg.getLevel()), NTextStyle.warn());
                break;
            }
            case 800: {
                sb.append((Object)NLogUtils.logLevel(msg.getLevel()), NTextStyle.info());
                break;
            }
            case 700: {
                sb.append((Object)NLogUtils.logLevel(msg.getLevel()), NTextStyle.config());
                break;
            }
            case 500: {
                sb.append((Object)NLogUtils.logLevel(msg.getLevel()), NTextStyle.primary4());
                break;
            }
            case 400: {
                sb.append((Object)NLogUtils.logLevel(msg.getLevel()), NTextStyle.pale());
                break;
            }
            case 300: {
                sb.append((Object)NLogUtils.logLevel(msg.getLevel()), NTextStyle.pale());
                break;
            }
            default: {
                sb.append(NLogUtils.logLevel(msg.getLevel()));
            }
        }
        sb.append(" ");
        switch (msg.getIntent() == null ? "" : msg.getIntent().name()) {
            case "FAIL": {
                sb.append((Object)NLogUtils.logVerb(msg.getIntent().name()), NTextStyle.error());
                break;
            }
            case "WARNING": {
                sb.append((Object)NLogUtils.logVerb(msg.getIntent().name()), NTextStyle.warn());
                break;
            }
            case "UPDATE": 
            case "START": {
                sb.append((Object)NLogUtils.logVerb(msg.getIntent().name()), NTextStyle.info());
                break;
            }
            case "SUCCESS": {
                sb.append((Object)NLogUtils.logVerb(msg.getIntent().name()), NTextStyle.success());
                break;
            }
            case "INFO": 
            case "READ": {
                sb.append((Object)NLogUtils.logVerb(msg.getIntent().name()), NTextStyle.option());
                break;
            }
            case "CACHE": 
            case "DEBUG": {
                sb.append((Object)NLogUtils.logVerb(msg.getIntent().name()), NTextStyle.pale());
                break;
            }
            default: {
                sb.append(NLogUtils.logVerb(msg.getIntent() == null ? null : msg.getIntent().name()));
            }
        }
        sb.append(" " + NLogUtils.formatClassName(sourceClassName) + ": ");
        if (msg.getDurationNanos() > 0L) {
            sb.append("(");
            sb.append((Object)NDuration.ofNanos(msg.getDurationNanos()), NTextStyle.config());
            sb.append(") ");
        }
        NText msgStr = NTexts.of().of(msg);
        sb.append(msgStr);
        sb.append(NLogUtils.LINE_SEPARATOR);
        this.lastMillis = timestamp;
        if (msg.getThrowable() != null) {
            sb.append(NText.ofPlain(NStringUtils.stacktrace(msg.getThrowable())).toString());
        }
        if (filtered) {
            return sb.filteredText();
        }
        return sb.toString();
    }
}

