/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.log;

import java.time.Instant;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import net.thevpc.nuts.log.NLogRecord;
import net.thevpc.nuts.runtime.standalone.log.NLogUtils;
import net.thevpc.nuts.runtime.standalone.util.CoreNUtils;
import net.thevpc.nuts.runtime.standalone.util.CoreTimeUtils;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextBuilder;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTexts;
import net.thevpc.nuts.util.NStringUtils;

public class NLogRichFormatter
extends Formatter {
    private long lastMillis = -1L;
    private boolean filtered;

    public NLogRichFormatter(boolean filtered) {
        this.filtered = filtered;
    }

    @Override
    public String format(LogRecord record) {
        NLogRecord wRecord = NLogUtils.toNutsLogRecord(record);
        NTexts tf = NTexts.of();
        NTextBuilder sb = tf.ofBuilder();
        String date = CoreNUtils.DEFAULT_DATE_TIME_FORMATTER.format(Instant.ofEpochMilli(wRecord.getMillis()));
        sb.append(tf.ofStyled(date, NTextStyle.pale()));
        boolean verboseLog = false;
        if (verboseLog) {
            sb.append(" ");
            int len = date.length() + 5;
            StringBuilder sb2 = new StringBuilder(5);
            if (this.lastMillis > 0L) {
                sb2.append(String.valueOf(wRecord.getMillis() - this.lastMillis));
            }
            while (sb2.length() < 5) {
                sb2.append(' ');
            }
            sb.append(sb.toString());
        }
        sb.append(" ");
        switch (wRecord.getLevel().intValue()) {
            case 1000: {
                sb.append((Object)NLogUtils.logLevel(wRecord.getLevel()), NTextStyle.error());
                break;
            }
            case 900: {
                sb.append((Object)NLogUtils.logLevel(wRecord.getLevel()), NTextStyle.warn());
                break;
            }
            case 800: {
                sb.append((Object)NLogUtils.logLevel(wRecord.getLevel()), NTextStyle.info());
                break;
            }
            case 700: {
                sb.append((Object)NLogUtils.logLevel(wRecord.getLevel()), NTextStyle.config());
                break;
            }
            case 500: {
                sb.append((Object)NLogUtils.logLevel(wRecord.getLevel()), NTextStyle.primary4());
                break;
            }
            case 400: {
                sb.append((Object)NLogUtils.logLevel(wRecord.getLevel()), NTextStyle.pale());
                break;
            }
            case 300: {
                sb.append((Object)NLogUtils.logLevel(wRecord.getLevel()), NTextStyle.pale());
                break;
            }
            default: {
                sb.append(NLogUtils.logLevel(wRecord.getLevel()));
            }
        }
        sb.append(" ");
        switch (wRecord.getVerb() == null ? "" : wRecord.getVerb().name()) {
            case "FAIL": {
                sb.append((Object)NLogUtils.logVerb(wRecord.getVerb().name()), NTextStyle.error());
                break;
            }
            case "WARNING": {
                sb.append((Object)NLogUtils.logVerb(wRecord.getVerb().name()), NTextStyle.warn());
                break;
            }
            case "UPDATE": 
            case "START": {
                sb.append((Object)NLogUtils.logVerb(wRecord.getVerb().name()), NTextStyle.info());
                break;
            }
            case "SUCCESS": {
                sb.append((Object)NLogUtils.logVerb(wRecord.getVerb().name()), NTextStyle.success());
                break;
            }
            case "INFO": 
            case "READ": {
                sb.append((Object)NLogUtils.logVerb(wRecord.getVerb().name()), NTextStyle.option());
                break;
            }
            case "CACHE": 
            case "DEBUG": {
                sb.append((Object)NLogUtils.logVerb(wRecord.getVerb().name()), NTextStyle.pale());
                break;
            }
            default: {
                sb.append(NLogUtils.logVerb(wRecord.getVerb() == null ? null : wRecord.getVerb().name()));
            }
        }
        sb.append(" " + NLogUtils.formatClassName(wRecord.getSourceClassName()) + ": ");
        if (wRecord.getTime() > 0L) {
            sb.append("(");
            sb.append((Object)CoreTimeUtils.formatPeriodMilli(wRecord.getTime()), NTextStyle.config());
            sb.append(") ");
        }
        NMsg message = wRecord.getFormattedMessage();
        NText msgStr = NTexts.of().of(message);
        sb.append(msgStr);
        sb.append(NLogUtils.LINE_SEPARATOR);
        this.lastMillis = wRecord.getMillis();
        if (wRecord.getThrown() != null) {
            sb.append(NText.ofPlain(NStringUtils.stacktrace(wRecord.getThrown())).toString());
        }
        if (this.filtered) {
            return sb.filteredText();
        }
        return sb.toString();
    }
}

