/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.log;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.thevpc.nuts.app.NApp;
import net.thevpc.nuts.concurrent.NCallable;
import net.thevpc.nuts.concurrent.NScopedValue;
import net.thevpc.nuts.core.NBootOptions;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NLogConfig;
import net.thevpc.nuts.log.NLogContext;
import net.thevpc.nuts.log.NLogFactorySPI;
import net.thevpc.nuts.log.NLogSPI;
import net.thevpc.nuts.platform.NStoreType;
import net.thevpc.nuts.runtime.standalone.log.DefaultNLog;
import net.thevpc.nuts.runtime.standalone.log.DefaultNLogs;
import net.thevpc.nuts.runtime.standalone.log.NLogConsoleHandler;
import net.thevpc.nuts.runtime.standalone.log.NLogContextImpl;
import net.thevpc.nuts.runtime.standalone.log.NLogFactorySPIJUL;
import net.thevpc.nuts.runtime.standalone.log.NLogFileHandler;
import net.thevpc.nuts.spi.NScopeType;
import net.thevpc.nuts.text.NMsg;

public class DefaultNLogModel {
    private static Handler[] EMPTY = new Handler[0];
    private NWorkspace workspace;
    private NLogConsoleHandler consoleHandler;
    private NLogFileHandler fileHandler;
    private NLogConfig logConfig = new NLogConfig();
    private List<Handler> extraHandlers = new ArrayList<Handler>();
    private Path logFolder;
    private NLogFactorySPI defaultFactorySPI = new NLogFactorySPIJUL();
    private NLogFactorySPI factorySPI;
    private NLog nullLogger;
    private NScopedValue<NLogContext> logContext = NScopedValue.of(NLogContextImpl.BLANK);

    public DefaultNLogModel(NWorkspace ws) {
        this.workspace = ws;
    }

    public void init(NBootOptions effOptions, NBootOptions userOptions) {
        this.logFolder = Paths.get(effOptions.getStoreType(NStoreType.LOG).get(), new String[0]);
        NLogConfig lc = userOptions.getLogConfig().orNull();
        if (lc != null) {
            if (lc.getLogFileLevel() != null) {
                this.logConfig.setLogFileLevel(lc.getLogFileLevel());
            }
            if (lc.getLogTermLevel() != null) {
                this.logConfig.setLogTermLevel(lc.getLogTermLevel());
            }
            this.logConfig.setLogFileName(lc.getLogFileName());
            this.logConfig.setLogFileCount(lc.getLogFileCount());
            this.logConfig.setLogFileBase(lc.getLogFileBase());
            this.logConfig.setLogFileSize(lc.getLogFileSize());
        }
        this.consoleHandler = new NLogConsoleHandler(this);
        this.consoleHandler.suspendTerminal();
        try {
            this.fileHandler = NLogFileHandler.create(this.logConfig, true, this.logFolder);
            this.fileHandler.setLevel(this.logConfig.getLogFileLevel());
        }
        catch (Exception ex) {
            Logger.getLogger(DefaultNLogs.class.getName()).log(Level.FINE, "unable to create file handler", ex);
        }
    }

    public void runWithContext(NLogContext context, Runnable runnable) {
        NLogContext c2 = this.logContext.get().mergedWith(context);
        this.logContext.runWith(c2, runnable);
    }

    public <T> T callWithContext(NLogContext context, NCallable<T> callable) {
        NLogContext c2 = this.logContext.get().mergedWith(context);
        return this.logContext.callWith(c2, callable);
    }

    public NLogContext getContext() {
        return this.logContext.get();
    }

    public NLogFactorySPI getFactorySPI() {
        return this.factorySPI == null ? this.defaultFactorySPI : this.factorySPI;
    }

    public DefaultNLogModel setFactorySPI(NLogFactorySPI factorySPI) {
        NLogFactorySPI oldFactorySPI;
        if (factorySPI == null) {
            factorySPI = this.defaultFactorySPI;
        }
        if ((oldFactorySPI = factorySPI) != this.factorySPI && !Objects.equals(this.factorySPI, oldFactorySPI)) {
            this.factorySPI = factorySPI;
            NLogFactorySPI f2 = this.getFactorySPI();
            for (NLog l : this.loaded().values()) {
                ((DefaultNLog)l).updateSPI(f2.getLogSPI(l.getName()));
            }
        }
        return this;
    }

    public List<Handler> getHandlers() {
        if (this.extraHandlers.isEmpty()) {
            return Collections.emptyList();
        }
        return this.extraHandlers;
    }

    public void removeHandler(Handler handler) {
        this.extraHandlers.remove(handler);
    }

    public void addHandler(Handler handler) {
        if (handler != null) {
            this.extraHandlers.add(handler);
        }
    }

    public NLogConsoleHandler getTermHandler() {
        return this.consoleHandler;
    }

    public NLogSPI getFileHandler() {
        return this.fileHandler;
    }

    private Map<String, NLog> loaded() {
        return NApp.of().getOrComputeProperty(NLog.class.getName() + "#Map", NScopeType.WORKSPACE, () -> new HashMap());
    }

    public NLog getNullLogger() {
        if (this.nullLogger == null) {
            this.nullLogger = new DefaultNLog("", new NLogSPI(){

                @Override
                public void log(NMsg message) {
                }
            }, this, false);
        }
        return this.nullLogger;
    }

    public NLog getLogger(String name) {
        Map<String, NLog> loaded = this.loaded();
        NLog y = loaded.get(name);
        if (y == null) {
            y = new DefaultNLog(name, this.getFactorySPI().getLogSPI(name), this, false);
            loaded.put(name, y);
        }
        return y;
    }

    public NLog createCustomLogger(String name, NLogSPI spi) {
        if (name == null) {
            name = "LOGGER-" + UUID.randomUUID();
        }
        return new DefaultNLog(name, spi, this, true);
    }

    public Level getTermLevel() {
        return this.logConfig.getLogTermLevel();
    }

    public void setTermLevel(Level level) {
        if (level == null) {
            level = Level.INFO;
        }
        this.logConfig.setLogFileLevel(level);
    }

    public Level getFileLevel() {
        return this.logConfig.getLogFileLevel();
    }

    public void setFileLevel(Level level) {
        if (level == null) {
            level = Level.INFO;
        }
        this.logConfig.setLogFileLevel(level);
        if (this.fileHandler != null) {
            this.fileHandler.setLevel(level);
        }
    }

    public NWorkspace getWorkspace() {
        return this.workspace;
    }
}

