/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.thevpc.nuts.io.NByteArrayQueue;
import net.thevpc.nuts.io.NContentMetadata;
import net.thevpc.nuts.io.NContentMetadataProvider;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NInterruptException;
import net.thevpc.nuts.io.NInterruptible;
import net.thevpc.nuts.io.NMemoryPrintStream;
import net.thevpc.nuts.io.NNonBlockingInputStream;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.io.NTerminalMode;
import net.thevpc.nuts.runtime.standalone.NWorkspaceProfilerImpl;
import net.thevpc.nuts.runtime.standalone.io.NCoreIOUtils;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NUtils;

public class NNonBlockingInputStreamAdapter
extends FilterInputStream
implements NNonBlockingInputStream,
NInterruptible<InputStream>,
NContentMetadataProvider {
    private boolean hasMoreBytes = true;
    private boolean closed = false;
    private boolean interrupted = false;
    private NContentMetadata md;
    private InputStream base;
    private NMsg sourceName;
    private long lastReadTime;
    private NByteArrayQueue buffer = new NByteArrayQueue();
    private boolean enqueing;
    private long expectedSize;
    private long lengthRead;

    public NNonBlockingInputStreamAdapter(InputStream base, NContentMetadata md, NMsg sourceName) {
        super(base);
        Object m2;
        this.base = base;
        this.md = CoreIOUtils.createContentMetadata(md, base);
        if (sourceName == null && (m2 = (NMsg)this.md.getMessage().orElse(null)) != null) {
            sourceName = m2;
        }
        if (sourceName == null && (m2 = (String)this.md.getName().orElse(null)) != null) {
            sourceName = NMsg.ofPlain((String)m2);
        }
        this.sourceName = sourceName;
        this.expectedSize = NUtils.firstNonNull(NCoreIOUtils.detectLength(base), Long.valueOf(-1L));
    }

    public long getLastReadTime() {
        return this.lastReadTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enqueue() {
        boolean doEnqueue = false;
        NNonBlockingInputStreamAdapter nNonBlockingInputStreamAdapter = this;
        synchronized (nNonBlockingInputStreamAdapter) {
            if (!this.enqueing) {
                this.enqueing = true;
                doEnqueue = true;
            }
        }
        if (doEnqueue) {
            new Thread(() -> {
                byte[] b = new byte[256];
                int x = 0;
                try {
                    x = this.read(b);
                    if (x > 0) {
                        this.buffer.write(b, 0, x);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    this.enqueing = false;
                }
            }).start();
            return true;
        }
        return false;
    }

    private void checkInterrupted() {
        if (this.interrupted) {
            throw new NIOException(NMsg.ofPlain("stream is interrupted"));
        }
    }

    @Override
    public InputStream base() {
        return this;
    }

    @Override
    public void interrupt() throws NInterruptException {
        this.interrupted = true;
        if (this.base instanceof NInterruptible) {
            ((NInterruptible)((Object)this.base)).interrupt();
        }
    }

    @Override
    public int read() throws IOException {
        this.checkInterrupted();
        if (this.closed) {
            return -1;
        }
        if (this.available() == 0 && !this.hasMoreBytes()) {
            return -1;
        }
        int read = super.read();
        if (read < 0) {
            this.hasMoreBytes = false;
        } else {
            ++this.lengthRead;
            this.lastReadTime = System.currentTimeMillis();
        }
        return read;
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.checkInterrupted();
        if (this.available() == 0 && !this.hasMoreBytes()) {
            return -1;
        }
        int read = super.read(b);
        if (read < 0) {
            this.hasMoreBytes = false;
        } else {
            this.lengthRead += (long)read;
            this.lastReadTime = System.currentTimeMillis();
        }
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read;
        block5: {
            this.checkInterrupted();
            if (this.available() == 0 && !this.hasMoreBytes()) {
                return -1;
            }
            read = -1;
            try {
                read = super.read(b, off, len);
            }
            catch (IOException ex) {
                if (ex.getMessage().equals("Stream closed")) break block5;
                throw ex;
            }
        }
        if (read < 0) {
            this.hasMoreBytes = false;
        } else {
            this.lengthRead += (long)read;
            this.lastReadTime = System.currentTimeMillis();
        }
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        this.checkInterrupted();
        if (this.available() == 0 && !this.hasMoreBytes()) {
            return 0L;
        }
        return super.skip(n);
    }

    @Override
    public int available() throws IOException {
        this.checkInterrupted();
        if (this.closed) {
            return -1;
        }
        int available = -1;
        try {
            available = super.available();
        }
        catch (IOException ex) {
            return -1;
        }
        if (available < 0) {
            if (!this.closed) {
                this.close();
            }
            return -1;
        }
        if (available == 0 && !this.hasMoreBytes) {
            return -1;
        }
        if (this.closed) {
            return -1;
        }
        return available;
    }

    @Override
    public int readNonBlocking(byte[] b, long timeout) throws IOException {
        return this.readNonBlocking(b, 0, b.length, timeout);
    }

    @Override
    public int readNonBlocking(byte[] b, int off, int len, long timeout) throws IOException {
        if (len <= 0) {
            if (this.closed || !this.hasMoreBytes()) {
                return -1;
            }
            return 0;
        }
        this.checkInterrupted();
        long now = System.currentTimeMillis();
        long then = now + timeout;
        long tic = 100L;
        this.checkInterrupted();
        if (this.closed) {
            return -1;
        }
        int available = this.available();
        if (available < 0) {
            this.hasMoreBytes = false;
            return -1;
        }
        if (available > 0) {
            return this.read(b, off, len);
        }
        if (!this.hasMoreBytes()) {
            return -1;
        }
        if (this.buffer.canRead()) {
            int bb = this.buffer.read(b, off, len);
            return bb;
        }
        this.enqueue();
        while (true) {
            if (!this.enqueing) {
                if (this.buffer.canRead()) {
                    int bb = this.buffer.read(b, off, len);
                    return bb;
                }
                if (this.closed || !this.hasMoreBytes()) {
                    return -1;
                }
                return 0;
            }
            now = System.currentTimeMillis();
            if (now > then) break;
            NWorkspaceProfilerImpl.sleep(tic, "NNonBlockingInputStreamAdapter::readNonBlocking");
        }
        return 0;
    }

    @Override
    public int readNonBlocking(byte[] b) throws IOException {
        return this.readNonBlocking(b, 0, b.length);
    }

    @Override
    public int readNonBlocking(byte[] b, int off, int len) throws IOException {
        this.checkInterrupted();
        int available = this.available();
        if (available < 0) {
            this.hasMoreBytes = false;
        } else {
            if (available > 0) {
                return this.read(b, off, len);
            }
            if (!this.hasMoreBytes()) {
                return -1;
            }
            if (this.buffer.canRead()) {
                return this.buffer.read(b, off, len);
            }
        }
        return 0;
    }

    @Override
    public void noMoreBytes() {
        this.hasMoreBytes = false;
    }

    @Override
    public boolean hasMoreBytes() {
        if (!this.hasMoreBytes) {
            return false;
        }
        return this.expectedSize < 0L || this.lengthRead < 0L;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.hasMoreBytes = false;
        this.closed = true;
    }

    @Override
    public NContentMetadata getMetaData() {
        return this.md;
    }

    public NMsg getSourceName() {
        return this.sourceName;
    }

    public String toString() {
        NMemoryPrintStream out = NPrintStream.ofMem(NTerminalMode.FILTERED);
        NOptional<NMsg> m = this.getMetaData().getMessage();
        if (m.isPresent()) {
            out.print(m.get());
        } else if (this.sourceName != null) {
            out.print(NText.ofStyled(this.sourceName, NTextStyle.path()));
        } else {
            out.print((Object)this.getClass().getSimpleName(), NTextStyle.path());
        }
        return out.toString();
    }
}

