/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.util;

import java.io.IOException;
import java.io.InputStream;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NContentMetadata;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.runtime.standalone.io.util.AbstractSingleReadNInputSource;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;

public class NInputStreamSource
extends AbstractSingleReadNInputSource {
    private InputStream inputStream;
    private NContentMetadata md;

    public NInputStreamSource(InputStream inputStream, NContentMetadata md, NWorkspace workspace) {
        super(workspace);
        this.inputStream = inputStream;
        this.md = CoreIOUtils.createContentMetadata(md, inputStream);
    }

    @Override
    public long getContentLength() {
        return this.md.getContentLength().orElse(-1L);
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public NContentMetadata getMetaData() {
        return this.md;
    }

    @Override
    public String getName() {
        return this.getMetaData().getName().orNull();
    }

    @Override
    public String getContentType() {
        return this.getMetaData().getContentType().orNull();
    }

    @Override
    public String getCharset() {
        return this.getMetaData().getCharset().orNull();
    }

    @Override
    public void dispose() {
        try {
            this.inputStream.close();
        }
        catch (IOException e) {
            throw new NIOException(e);
        }
    }
}

