/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.util;

import java.io.IOException;
import java.io.InputStream;
import net.thevpc.nuts.io.NContentMetadata;
import net.thevpc.nuts.io.NContentMetadataProvider;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NInterruptException;
import net.thevpc.nuts.io.NInterruptible;
import net.thevpc.nuts.io.NMemoryPrintStream;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.io.NTerminalMode;
import net.thevpc.nuts.runtime.standalone.io.NCoreIOUtils;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.time.NProgressEvent;
import net.thevpc.nuts.time.NProgressListener;
import net.thevpc.nuts.util.NOptional;

public class InputStreamExt
extends InputStream
implements NInterruptible<InputStream>,
NContentMetadataProvider {
    private InputStream base;
    private NContentMetadata md;
    private Runnable onClose;
    private Long length;
    private final NProgressListener monitor;
    private final Object source;
    private NMsg sourceName;
    private long count;
    private long lastCount;
    private long startTime;
    private long lastTime;
    private boolean completed = false;
    private boolean closed = false;
    private boolean interrupted;
    private boolean closeBase;

    public InputStreamExt(InputStream base, NContentMetadata md0, boolean closeBase, Runnable onClose, NProgressListener monitor, Object source, NMsg sourceName, Long length) {
        Object m2;
        this.base = base;
        this.closeBase = closeBase;
        this.onClose = onClose;
        this.md = CoreIOUtils.createContentMetadata(md0, base);
        this.monitor = monitor;
        this.source = source;
        if (length == null || length < 0L) {
            Long len = this.md.getContentLength().orElse(null);
            if (len != null) {
                long l = len;
                if (l >= 0L) {
                    length = l;
                }
            } else {
                length = NCoreIOUtils.detectLength(base);
            }
        }
        this.length = length;
        if (sourceName == null && (m2 = (NMsg)this.md.getMessage().orElse(null)) != null) {
            sourceName = m2;
        }
        if (sourceName == null && (m2 = (String)this.md.getName().orElse(null)) != null) {
            sourceName = NMsg.ofPlain((String)m2);
        }
        this.sourceName = sourceName;
    }

    @Override
    public InputStream base() {
        return this;
    }

    @Override
    public void interrupt() throws NInterruptException {
        this.interrupted = true;
        if (this.base instanceof NInterruptible) {
            ((NInterruptible)((Object)this.base)).interrupt();
        }
    }

    @Override
    public int read() throws IOException {
        this.checkInterrupted();
        if (this.monitor != null) {
            try {
                this.onBeforeRead();
                int r = this.base.read();
                if (r != -1) {
                    this.onAfterRead(1L);
                } else {
                    this.onComplete(null);
                }
                return r;
            }
            catch (IOException ex) {
                this.onComplete(ex);
                throw ex;
            }
        }
        return this.base.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.checkInterrupted();
        if (this.monitor != null) {
            try {
                this.onBeforeRead();
                int r = this.base.read(b);
                this.onAfterRead(r);
                return r;
            }
            catch (IOException ex) {
                this.onComplete(ex);
                throw ex;
            }
        }
        return this.base.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkInterrupted();
        if (this.monitor != null) {
            try {
                this.onBeforeRead();
                int r = this.base.read(b, off, len);
                this.onAfterRead(r);
                return r;
            }
            catch (IOException ex) {
                this.onComplete(ex);
                throw ex;
            }
        }
        return this.base.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        this.checkInterrupted();
        if (this.monitor != null) {
            try {
                this.onBeforeRead();
                long r = this.base.skip(n);
                this.onAfterRead(r);
                return r;
            }
            catch (IOException ex) {
                this.onComplete(ex);
                throw ex;
            }
        }
        return this.base.skip(n);
    }

    @Override
    public int available() throws IOException {
        this.checkInterrupted();
        if (this.monitor != null) {
            try {
                return this.base.available();
            }
            catch (IOException ex) {
                this.onComplete(ex);
                throw ex;
            }
        }
        return this.base.available();
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.monitor != null) {
            this.onComplete(null);
        }
        if (this.closeBase) {
            try {
                this.base.close();
            }
            catch (IOException e) {
                throw new NIOException(NMsg.ofPlain("error closing base stream"), (Throwable)e);
            }
        }
        if (this.onClose != null) {
            this.onClose.run();
        }
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.base.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        try {
            this.base.reset();
        }
        catch (IOException ex) {
            if (this.monitor != null) {
                this.onComplete(ex);
            }
            throw ex;
        }
    }

    @Override
    public boolean markSupported() {
        return this.base.markSupported();
    }

    public Long getLength() {
        return this.length;
    }

    private void onBeforeRead() {
        if (!this.completed && this.startTime == 0L) {
            long now;
            this.startTime = now = System.nanoTime();
            this.lastTime = now;
            this.lastCount = 0L;
            this.count = 0L;
            this.monitor.onProgress(NProgressEvent.ofStart(this.source, this.sourceName, this.length == null ? -1L : this.length));
        }
    }

    private void onAfterRead(long count) {
        if (!this.completed) {
            long now = System.nanoTime();
            this.count += count;
            if (this.monitor.onProgress(NProgressEvent.ofProgress(this.source, this.sourceName, this.count, now - this.startTime, null, this.count - this.lastCount, now - this.lastTime, this.length == null ? -1L : this.length, null))) {
                this.lastCount = this.count;
                this.lastTime = now;
            }
        }
    }

    private void onComplete(IOException ex) {
        if (!this.completed) {
            this.completed = true;
            long now = System.nanoTime();
            this.monitor.onProgress(NProgressEvent.ofComplete(this.source, this.sourceName, this.count, now - this.startTime, null, this.count - this.lastCount, now - this.lastTime, this.length == null ? -1L : this.length, ex));
        }
    }

    private void checkInterrupted() {
        if (this.interrupted) {
            throw new NIOException(NMsg.ofPlain("stream is interrupted"));
        }
    }

    @Override
    public NContentMetadata getMetaData() {
        return this.md;
    }

    public NMsg getSourceName() {
        return this.sourceName;
    }

    public String toString() {
        NMemoryPrintStream out = NPrintStream.ofMem(NTerminalMode.FILTERED);
        NOptional<NMsg> m = this.getMetaData().getMessage();
        if (m.isPresent()) {
            out.print(m.get());
        } else if (this.sourceName != null) {
            out.print(NText.ofStyled(this.sourceName, NTextStyle.path()));
        } else {
            out.print((Object)this.getClass().getSimpleName(), NTextStyle.path());
        }
        return out.toString();
    }
}

